/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;

public class Throwable
implements Serializable {
    private String message;
    private Throwable cause;
    private boolean enableSuppression = false;
    private boolean writableStackTrace = false;
    private StackTraceElement[] stackTrace;
    private ArrayList<Throwable> supressed;
    private static Throwable[] EMPTY_ARRAY = new Throwable[0];

    public Throwable() {
        this.fillInStackTrace();
        this.t_init(null, null, false, false);
    }

    public Throwable(String message) {
        this.fillInStackTrace();
        this.t_init(message, null, false, false);
    }

    public Throwable(String message, Throwable cause) {
        this.fillInStackTrace();
        this.t_init(message, cause, false, false);
    }

    public Throwable(Throwable cause) {
        this.fillInStackTrace();
        this.t_init(null, cause, false, false);
    }

    protected Throwable(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        this.fillInStackTrace();
        this.t_init(message, cause, enableSuppression, writableStackTrace);
    }

    private void t_init(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        this.message = message;
        this.cause = cause;
        this.enableSuppression = enableSuppression;
        this.writableStackTrace = writableStackTrace;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocalizedMessage() {
        return this.message;
    }

    public synchronized Throwable getCause() {
        return this.cause;
    }

    public synchronized Throwable initCause(Throwable cause) {
        this.cause = cause;
        return this.cause;
    }

    public String toString() {
        return "Exception:" + this.message;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        s.println(this);
        StackTraceElement[] trace = this.stackTrace;
        for (StackTraceElement stackTraceElement : trace) {
            s.println("\tat " + stackTraceElement);
        }
        for (Serializable serializable : this.getSuppressed()) {
            System.out.println("Supressed:");
            ((Throwable)serializable).printStackTrace(s);
        }
        Throwable ourCause = this.getCause();
        if (ourCause != null) {
            System.out.println("Cause:");
            ourCause.printStackTrace(s);
        }
    }

    public native void printStackTrace(PrintWriter var1);

    public synchronized Throwable fillInStackTrace() {
        this.fillInStackTrace(0);
        return this;
    }

    private void fillInStackTrace(int dummy) {
        this.setStackTrace(this.getStackTraceInternal());
    }

    @HaxeMethodBody(value="return N.getStackTrace(1);")
    @JTranscMethodBody(target="js", value={"return N.getStackTrace(1);"})
    private StackTraceElement[] getStackTraceInternal() {
        return new StackTraceElement[]{new StackTraceElement("DummyClass", "dummyMethod", "DummyClass.java", 1), new StackTraceElement("DummyClass", "dummyMethod", "DummyClass.java", 1), new StackTraceElement("DummyClass", "dummyMethod", "DummyClass.java", 1)};
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.stackTrace.clone();
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public final synchronized void addSuppressed(Throwable exception) {
        if (this.supressed == null) {
            this.supressed = new ArrayList();
        }
        this.supressed.add(exception);
    }

    public final synchronized Throwable[] getSuppressed() {
        return this.supressed != null ? this.supressed.toArray(EMPTY_ARRAY) : EMPTY_ARRAY;
    }
}

