/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.lang.jtransc.JTranscStrings;
import java.util.Arrays;

@HaxeAddMembers(value={"public var buffer2:StringBuf = new StringBuf();", "public var str2:String = null;", "public function add(str:String) { this.str2 = null; buffer2.add(str); return this; }", "public function addChar(c:Int) { this.str2 = null; buffer2.add(String.fromCharCode(c)); return this; }", "public function getStr() { if (this.str2 == null) this.str2 = buffer2.toString(); return this.str2; }", "public function setStr(str:String) { this.str2 = str; buffer2 = new StringBuf(); buffer2.add(str); return this; }"})
abstract class AbstractStringBuilder
implements Appendable,
CharSequence {
    protected char[] buffer;
    protected int length;

    AbstractStringBuilder() {
        this(0);
    }

    @JTranscMethodBody(target="js", value={"this._str = '';"})
    AbstractStringBuilder(int capacity) {
        this.buffer = new char[capacity];
    }

    @Override
    @HaxeMethodBody(value="return this.buffer2.length;")
    @JTranscMethodBody(target="js", value={"return this._str.length;"})
    public int length() {
        return this.length;
    }

    @HaxeMethodBody(value="setStr(getStr());")
    @JTranscMethodBody(target="js", value={""})
    public void trimToSize() {
        this.buffer = Arrays.copyOf(this.buffer, this.length);
    }

    @Override
    @HaxeMethodBody(value="return this.getStr().charCodeAt(p0);")
    @JTranscMethodBody(target="js", value={"return this._str.charCodeAt(p0);"})
    public char charAt(int index) {
        return this.buffer[index];
    }

    @HaxeMethodBody(value="return this.getStr().indexOf(p0._str);")
    @JTranscMethodBody(target="js", value={"return this._str.indexOf(p0._str);"})
    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    @HaxeMethodBody(value="return this.getStr().indexOf(p0._str, p1);")
    @JTranscMethodBody(target="js", value={"return this._str.indexOf(p0._str, p1);"})
    public int indexOf(String str, int fromIndex) {
        return JTranscStrings.indexOf(this.buffer, fromIndex, JTranscStrings.getData(str));
    }

    @HaxeMethodBody(value="return this.getStr().lastIndexOf(p0._str);")
    @JTranscMethodBody(target="js", value={"return this._str.lastIndexOf(p0._str);"})
    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.length);
    }

    @HaxeMethodBody(value="return this.getStr().lastIndexOf(p0._str, p1);")
    @JTranscMethodBody(target="js", value={"return this._str.lastIndexOf(p0._str, p1);"})
    public int lastIndexOf(String str, int fromIndex) {
        return JTranscStrings.lastIndexOf(this.buffer, fromIndex, JTranscStrings.getData(str));
    }

    @HaxeMethodBody(value="var reversed = ''; var str = getStr(); for (n in 0 ... str.length) reversed += str.charAt(str.length - n - 1); return this.setStr(reversed);")
    @JTranscMethodBody(target="js", value={"this._str = this._str.reverse(); return this;"})
    public AbstractStringBuilder reverse() {
        int len = this.length / 2;
        for (int n = 0; n < len; ++n) {
            int m = this.length - n - 1;
            char temp = this.buffer[n];
            this.buffer[n] = this.buffer[m];
            this.buffer[m] = temp;
        }
        return this;
    }

    @HaxeMethodBody(value="return this.add(N.toNativeString(p0));")
    @JTranscMethodBody(target="js", value={"this._str += N.istr(p0); return this;"})
    public AbstractStringBuilder append(String _str) {
        String str = String.valueOf(_str);
        int strlen = str.length();
        this.ensureCapacity(this.length + strlen);
        System.arraycopy(JTranscStrings.getData(str), 0, this.buffer, this.length, strlen);
        this.length += strlen;
        return this;
    }

    @Override
    @HaxeMethodBody(value="return this.addChar(p0);")
    @JTranscMethodBody(target="js", value={"this._str += String.fromCharCode(p0); return this;"})
    public AbstractStringBuilder append(char v) {
        this.ensureCapacity(this.length + 1);
        this.buffer[this.length++] = v;
        return this;
    }

    @HaxeMethodBody(value="return this.setStr(this.getStr().substr(0, p0) + this.getStr().substr(p1));")
    @JTranscMethodBody(target="js", value={"this._str = this._str.substr(0, p0) + this._str.substr(p1); return this;"})
    public AbstractStringBuilder delete(int start, int end) {
        return this.replace(start, end, "");
    }

    @HaxeMethodBody(value="return this.setStr(this.getStr().substr(0, p0) + p2._str + this.getStr().substr(p1));")
    @JTranscMethodBody(target="js", value={"this._str = this._str.substr(0, p0) + N.istr(p2) + this._str.substr(p1); return this;"})
    public AbstractStringBuilder replace(int start, int end, String str) {
        int addLength = str.length();
        int removeLength = end - start;
        this.ensureCapacity(this.length - removeLength + addLength);
        System.arraycopy(this.buffer, end, this.buffer, start + addLength, this.length - end);
        System.arraycopy(JTranscStrings.getData(str), 0, this.buffer, start, addLength);
        this.length = this.length - removeLength + addLength;
        return this;
    }

    public int capacity() {
        return this.buffer.length;
    }

    private char[] ensure(int minimumCapacity) {
        if (minimumCapacity > this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, Math.max(minimumCapacity, this.buffer.length * 2 + 2));
        }
        return this.buffer;
    }

    public void ensureCapacity(int minimumCapacity) {
        this.ensure(minimumCapacity);
    }

    public void setLength(int newLength) {
        this.delete(newLength, this.length());
    }

    public AbstractStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public AbstractStringBuilder append(StringBuffer sb) {
        return this.append(String.valueOf(sb));
    }

    @Override
    public AbstractStringBuilder append(CharSequence s) {
        return this.append(String.valueOf(s));
    }

    @Override
    public AbstractStringBuilder append(CharSequence s, int start, int end) {
        return this.append(s.toString().substring(start, end));
    }

    public AbstractStringBuilder append(char[] str) {
        return this.append(new String(str));
    }

    public AbstractStringBuilder append(char[] str, int offset, int len) {
        return this.append(new String(str, offset, len));
    }

    public AbstractStringBuilder append(boolean v) {
        return this.append(String.valueOf(v));
    }

    public AbstractStringBuilder append(int v) {
        return this.append(String.valueOf(v));
    }

    public AbstractStringBuilder append(long v) {
        return this.append(String.valueOf(v));
    }

    public AbstractStringBuilder append(float v) {
        return this.append(String.valueOf(v));
    }

    public AbstractStringBuilder append(double v) {
        return this.append(String.valueOf(v));
    }

    public AbstractStringBuilder appendCodePoint(int codePoint) {
        return this.append(new String(new int[]{codePoint}, 0, 1));
    }

    public AbstractStringBuilder deleteCharAt(int index) {
        return this.delete(index, index + 1);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public AbstractStringBuilder insert(int offset, String str) {
        return this.replace(offset, offset, str);
    }

    public AbstractStringBuilder insert(int offset, char[] str, int pos, int len) {
        return this.insert(offset, String.valueOf(str, pos, len));
    }

    public AbstractStringBuilder insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public AbstractStringBuilder insert(int offset, char[] str) {
        return this.insert(offset, String.valueOf(str));
    }

    public AbstractStringBuilder insert(int offset, CharSequence s) {
        return this.insert(offset, s.toString());
    }

    public AbstractStringBuilder insert(int offset, CharSequence s, int start, int end) {
        return this.insert(offset, s.toString().substring(start, end));
    }

    public AbstractStringBuilder insert(int offset, boolean v) {
        return this.insert(offset, String.valueOf(v));
    }

    public AbstractStringBuilder insert(int offset, char v) {
        return this.insert(offset, String.valueOf(v));
    }

    public AbstractStringBuilder insert(int offset, int v) {
        return this.insert(offset, String.valueOf(v));
    }

    public AbstractStringBuilder insert(int offset, long v) {
        return this.insert(offset, String.valueOf(v));
    }

    public AbstractStringBuilder insert(int offset, float v) {
        return this.insert(offset, String.valueOf(v));
    }

    public AbstractStringBuilder insert(int offset, double v) {
        return this.insert(offset, String.valueOf(v));
    }

    public int codePointAt(int index) {
        return this.toString().codePointAt(index);
    }

    public int codePointBefore(int index) {
        return this.toString().codePointBefore(index);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        return this.toString().codePointCount(beginIndex, endIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return this.toString().offsetByCodePoints(index, codePointOffset);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        String s = this.toString();
        int len = srcEnd - srcBegin;
        for (int n = 0; n < len; ++n) {
            dst[n] = s.charAt(srcBegin + n);
        }
    }

    public void setCharAt(int index, char ch) {
        this.replace(index, index + 1, String.valueOf(ch));
    }

    public String substring(int start) {
        return this.toString().substring(start);
    }

    public String substring(int start, int end) {
        return this.toString().substring(start, end);
    }

    @Override
    @JTranscMethodBody(target="js", value={"return N.str(this._str);"})
    public String toString() {
        return new String(this.buffer, 0, this.length);
    }
}

