/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.io.JTranscSyncIO;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream {
    private final FileDescriptor fd;
    private final boolean append;
    private final String path;
    private final JTranscSyncIO.ImplStream jfd;
    private volatile boolean closed = false;

    public FileOutputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null, false);
    }

    public FileOutputStream(String name, boolean append) throws FileNotFoundException {
        this(name != null ? new File(name) : null, append);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        String name;
        String string = name = file != null ? file.getPath() : null;
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.append = append;
        this.path = name;
        this.jfd = JTranscSyncIO.impl.open(name, 2);
        if (append) {
            this.jfd.setPosition(this.jfd.getLength());
        }
    }

    public FileOutputStream(FileDescriptor fdObj) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void write(int b) throws IOException {
        this.jfd.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.jfd.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.jfd.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.jfd.close();
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }
}

