/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.text.internal;

public final class RealToString {
    public static long[] LONG_POWERS_OF_TEN;
    private static final ThreadLocal<RealToString> INSTANCE;
    private static final double invLogOfTenBaseTwo;
    private int firstK;
    private final int[] digits = new int[64];
    private int digitCount;

    private RealToString() {
    }

    public static RealToString getInstance() {
        return INSTANCE.get();
    }

    private static String resultOrSideEffect(StringBuilder sb, String s) {
        if (sb != null) {
            sb.append(s);
            return null;
        }
        return s;
    }

    public String doubleToString(double d) {
        return this.convertDouble(null, d);
    }

    public void appendDouble(StringBuilder sb, double d) {
        this.convertDouble(sb, d);
    }

    private String convertDouble(StringBuilder sb, double inputNumber) {
        StringBuilder dst;
        int pow;
        long inputNumberBits = Double.doubleToRawLongBits(inputNumber);
        boolean positive = (inputNumberBits & Long.MIN_VALUE) == 0L;
        int e = (int)((inputNumberBits & 0x7FF0000000000000L) >> 52);
        long f = inputNumberBits & 0xFFFFFFFFFFFFFL;
        boolean mantissaIsZero = f == 0L;
        String quickResult = null;
        if (e == 2047) {
            quickResult = mantissaIsZero ? (positive ? "Infinity" : "-Infinity") : "NaN";
        } else if (e == 0) {
            if (mantissaIsZero) {
                quickResult = positive ? "0.0" : "-0.0";
            } else if (f == 1L) {
                String string = quickResult = positive ? "4.9E-324" : "-4.9E-324";
            }
        }
        if (quickResult != null) {
            return RealToString.resultOrSideEffect(sb, quickResult);
        }
        int p = 1075;
        int numBits = 52;
        if (e == 0) {
            pow = 1 - p;
            long ff = f;
            while ((ff & 0x10000000000000L) == 0L) {
                ff <<= 1;
                --numBits;
            }
        } else {
            f |= 0x10000000000000L;
            pow = e - p;
        }
        this.digitCount = 0;
        this.firstK = 0;
        if (-59 < pow && pow < 6 || pow == -59 && !mantissaIsZero) {
            this.longDigitGenerator(f, pow, e == 0, mantissaIsZero, numBits);
        } else {
            this.bigIntDigitGenerator(f, pow, e == 0, numBits);
        }
        StringBuilder stringBuilder = dst = sb != null ? sb : new StringBuilder(26);
        if (inputNumber >= 1.0E7 || inputNumber <= -1.0E7 || inputNumber > -0.001 && inputNumber < 0.001) {
            this.freeFormatExponential(dst, positive);
        } else {
            this.freeFormat(dst, positive);
        }
        return sb != null ? null : dst.toString();
    }

    public String floatToString(float f) {
        return this.convertFloat(null, f);
    }

    public void appendFloat(StringBuilder sb, float f) {
        this.convertFloat(sb, f);
    }

    public String convertFloat(StringBuilder sb, float inputNumber) {
        StringBuilder dst;
        int pow;
        int inputNumberBits = Float.floatToRawIntBits(inputNumber);
        boolean positive = (inputNumberBits & Integer.MIN_VALUE) == 0;
        int e = (inputNumberBits & 0x7F800000) >> 23;
        int f = inputNumberBits & 0x7FFFFF;
        boolean mantissaIsZero = f == 0;
        String quickResult = null;
        if (e == 255) {
            quickResult = mantissaIsZero ? (positive ? "Infinity" : "-Infinity") : "NaN";
        } else if (e == 0 && mantissaIsZero) {
            String string = quickResult = positive ? "0.0" : "-0.0";
        }
        if (quickResult != null) {
            return RealToString.resultOrSideEffect(sb, quickResult);
        }
        int p = 150;
        int numBits = 23;
        if (e == 0) {
            pow = 1 - p;
            if (f < 8) {
                f <<= 2;
                pow -= 2;
            }
            int ff = f;
            while ((ff & 0x800000) == 0) {
                ff <<= 1;
                --numBits;
            }
        } else {
            f |= 0x800000;
            pow = e - p;
        }
        this.digitCount = 0;
        this.firstK = 0;
        if (-59 < pow && pow < 35 || pow == -59 && !mantissaIsZero) {
            this.longDigitGenerator(f, pow, e == 0, mantissaIsZero, numBits);
        } else {
            this.bigIntDigitGenerator(f, pow, e == 0, numBits);
        }
        StringBuilder stringBuilder = dst = sb != null ? sb : new StringBuilder(26);
        if (inputNumber >= 1.0E7f || inputNumber <= -1.0E7f || inputNumber > -0.001f && inputNumber < 0.001f) {
            this.freeFormatExponential(dst, positive);
        } else {
            this.freeFormat(dst, positive);
        }
        return sb != null ? null : dst.toString();
    }

    private void freeFormatExponential(StringBuilder sb, boolean positive) {
        int k;
        int digitIndex = 0;
        if (!positive) {
            sb.append('-');
        }
        sb.append((char)(48 + this.digits[digitIndex++]));
        sb.append('.');
        int exponent = k = this.firstK;
        while (true) {
            --k;
            if (digitIndex >= this.digitCount) break;
            sb.append((char)(48 + this.digits[digitIndex++]));
        }
        if (k == exponent - 1) {
            sb.append('0');
        }
        sb.append('E');
        sb.append(Integer.toString(exponent));
    }

    private void freeFormat(StringBuilder sb, boolean positive) {
        int k;
        int digitIndex = 0;
        if (!positive) {
            sb.append('-');
        }
        if ((k = this.firstK) < 0) {
            sb.append('0');
            sb.append('.');
            for (int i = k + 1; i < 0; ++i) {
                sb.append('0');
            }
        }
        int U = this.digits[digitIndex++];
        do {
            if (U != -1) {
                sb.append((char)(48 + U));
            } else if (k >= -1) {
                sb.append('0');
            }
            if (k != 0) continue;
            sb.append('.');
        } while ((U = digitIndex < this.digitCount ? this.digits[digitIndex++] : -1) != -1 || --k >= -1);
    }

    private native void bigIntDigitGenerator(long var1, int var3, boolean var4, int var5);

    private void longDigitGenerator(long f, int e, boolean isDenormalized, boolean mantissaIsZero, int p) {
        boolean high;
        boolean low;
        int U;
        long S;
        long R;
        long M;
        if (LONG_POWERS_OF_TEN == null) {
            LONG_POWERS_OF_TEN = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
        }
        if (e >= 0) {
            M = 1L << e;
            if (!mantissaIsZero) {
                R = f << e + 1;
                S = 2L;
            } else {
                R = f << e + 2;
                S = 4L;
            }
        } else {
            M = 1L;
            if (isDenormalized || !mantissaIsZero) {
                R = f << 1;
                S = 1L << 1 - e;
            } else {
                R = f << 2;
                S = 1L << 2 - e;
            }
        }
        int k = (int)Math.ceil((double)(e + p - 1) * invLogOfTenBaseTwo - 1.0E-10);
        if (k > 0) {
            S *= LONG_POWERS_OF_TEN[k];
        } else if (k < 0) {
            long scale = LONG_POWERS_OF_TEN[-k];
            R *= scale;
            long l = M = M == 1L ? scale : M * scale;
        }
        if (R + M > S) {
            this.firstK = k;
        } else {
            this.firstK = k - 1;
            R *= 10L;
            M *= 10L;
        }
        while (true) {
            U = 0;
            for (int i = 3; i >= 0; --i) {
                long remainder = R - (S << i);
                if (remainder < 0L) continue;
                R = remainder;
                U += 1 << i;
            }
            low = R < M;
            boolean bl = high = R + M > S;
            if (low || high) break;
            R *= 10L;
            M *= 10L;
            this.digits[this.digitCount++] = U;
        }
        this.digits[this.digitCount++] = low && !high ? U : (high && !low ? U + 1 : (R << 1 < S ? U : U + 1));
    }

    static {
        INSTANCE = new ThreadLocal<RealToString>(){

            @Override
            protected RealToString initialValue() {
                return new RealToString();
            }
        };
        invLogOfTenBaseTwo = Math.log(2.0) / Math.log(10.0);
    }
}

