/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.text;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.io.Serializable;
import java.util.ArrayList;

public class JTranscRegex {

    @HaxeAddMembers(value={"public var _pattern:String;", "public var _opts:String;", "public var _text:String;", "public var _ereg:EReg;", "public var _matches:Bool;", "public var _offset:Int = 0;", "public var _matchPos:Int = 0;", "public var _matchLen:Int = 0;", "public function _find() {\n\tvar r = this._ereg;\n\tthis._matches = r.matchSub(this.{% FIELD com.jtransc.text.JTranscRegex$Matcher:text:Ljava/lang/String; %}._str, this._offset);\n\tif (this._matches) {\n\t\tvar rpos = r.matchedPos();\n\t\tthis._matchPos = rpos.pos;\n\t\tthis._matchLen = rpos.len;\n\t\tthis._offset = rpos.pos + rpos.len;\n\t} else {\n\t\tthis._matchPos = 0;\n\t\tthis._matchLen = 0;\n\t}\n\treturn this._matches;\n}"})
    public static final class Matcher {
        private Pattern parent;
        private String pattern;
        private int flags;
        private String flagsString;
        private String text;
        private String subtext;
        private int matchStart = 0;
        private int matchEnd = 0;

        Matcher(Pattern parent, CharSequence text) {
            this.parent = parent;
            this.pattern = parent.pattern();
            this.flags = parent.flags();
            this.subtext = this.text = text.toString();
            this.flagsString = "";
            if ((this.flags & 2) != 0) {
                this.flagsString = this.flagsString + "i";
            }
            if ((this.flags & 8) != 0) {
                this.flagsString = this.flagsString + "m";
            }
            this._init();
        }

        @HaxeMethodBody(value="var opts = '';\nvar flags = this.{% FIELD com.jtransc.text.JTranscRegex$Matcher:flags %};\nvar pattern = this.{% FIELD com.jtransc.text.JTranscRegex$Matcher:pattern %};\nvar text = this.{% FIELD com.jtransc.text.JTranscRegex$Matcher:text %};\nif ((flags & 0x02) != 0) opts += 'i';\nif ((flags & 0x08) != 0) opts += 'm';\nthis._pattern = pattern._str;\nthis._opts = opts;\nthis._text = text._str;\nthis._ereg = new EReg(pattern._str, opts);\nthis._matches = (new EReg('^' + pattern._str + '$', opts)).match(text._str);")
        @JTranscMethodBody(target="js", value={"this._ereg = new RegExp(N.istr(this._pattern), N.istr(this._flagsString + 'g'));", "var flags = this.{% FIELD com.jtransc.text.JTranscRegex$Matcher:flags %};", "var opts = '';", "if ((flags & 0x02) != 0) opts += 'i';", "if ((flags & 0x08) != 0) opts += 'm';", "this._opts = opts;"})
        private void _init() {
        }

        public Pattern pattern() {
            return this.parent;
        }

        @HaxeMethodBody(value="return this._matchPos;")
        public int start() {
            return this.matchStart;
        }

        public int start(int group) {
            if (group == 0) {
                return this.start();
            }
            JTranscSystem.debugger();
            throw new Error("No implemented Matcher.start(int group) with group != 0");
        }

        @HaxeMethodBody(value="return this._matchPos + this._matchLen;")
        public int end() {
            return this.matchEnd;
        }

        public int end(int group) {
            if (group == 0) {
                return this.end();
            }
            JTranscSystem.debugger();
            throw new Error("No implemented Matcher.end(int group) with group != 0");
        }

        @HaxeMethodBody(value="return N.str(this._ereg.matched(0));")
        public String group() {
            return this.group(0);
        }

        @HaxeMethodBody(value="return N.str(this._ereg.matched(p0));")
        @JTranscMethodBody(target="js", value={"return N.str(this._groups[p0]);"})
        public native String group(int var1);

        @HaxeMethodBody(value="return this._matches;")
        @JTranscMethodBody(target="js", value={"return (new RegExp('^' + N.istr(this._pattern) + '$', opts)).test(N.istr(this._text));"})
        public native boolean matches();

        @HaxeMethodBody(value="return _find();")
        public boolean find() {
            return this._find();
        }

        @HaxeMethodBody(value="this._offset = p0; return _find();")
        public boolean find(int start) {
            this.subtext = this.text.substring(start);
            return this._find();
        }

        @JTranscMethodBody(target="js", value={"this._groups = this._ereg.exec(N.istr(this._subtext));", "this._matchStart = (this._groups) ? this._groups.index : -1;", "this._matchEnd   = this._ereg.lastIndex;", "return this._groups != null;"})
        private native boolean _find();

        public String replaceAll(String replacement) {
            return this.replaceFirstAll(replacement, true);
        }

        public String replaceFirst(String replacement) {
            return this.replaceFirstAll(replacement, false);
        }

        @HaxeMethodBody(value="return N.str(new EReg(this._pattern, p1 ? (this._opts + 'g') : (this._opts)).replace(this._text, p0._str));")
        @JTranscMethodBody(target="js", value={"var opts = p1 ? (this._opts + 'g') : (this._opts);", "var text = N.istr(this.{% FIELD com.jtransc.text.JTranscRegex$Matcher:text %});", "var pattern = N.istr(this.{% FIELD com.jtransc.text.JTranscRegex$Matcher:pattern %});", "return N.str(text.replace(new RegExp(pattern, opts), N.istr(p0)));"})
        private native String replaceFirstAll(String var1, boolean var2);
    }

    public static final class Pattern
    implements Serializable {
        public static final int UNIX_LINES = 1;
        public static final int CASE_INSENSITIVE = 2;
        public static final int COMMENTS = 4;
        public static final int MULTILINE = 8;
        public static final int LITERAL = 16;
        public static final int DOTALL = 32;
        public static final int UNICODE_CASE = 64;
        public static final int CANON_EQ = 128;
        public static final int UNICODE_CHARACTER_CLASS = 256;
        private String pattern;
        private int flags;

        public static Pattern compile(String regex) {
            return new Pattern(regex, 0);
        }

        public static Pattern compile(String regex, int flags) {
            return new Pattern(regex, flags);
        }

        private Pattern(String pattern, int flags) {
            this.pattern = pattern;
            this.flags = flags;
        }

        public String pattern() {
            return this.pattern;
        }

        public int flags() {
            return this.flags;
        }

        public String toString() {
            return this.pattern;
        }

        public Matcher matcher(CharSequence input) {
            return new Matcher(this, input);
        }

        public static boolean matches(String regex, CharSequence input) {
            return Pattern.compile(regex).matcher(input).matches();
        }

        public String[] split(CharSequence input, int limit) {
            int resultSize;
            int index = 0;
            boolean matchLimited = limit > 0;
            ArrayList<String> matchList = new ArrayList<String>();
            Matcher m = this.matcher(input);
            while (m.find()) {
                String match;
                if (!matchLimited || matchList.size() < limit - 1) {
                    if (index == 0 && index == m.start() && m.start() == m.end()) continue;
                    match = input.subSequence(index, m.start()).toString();
                    matchList.add(match);
                    index = m.end();
                    continue;
                }
                if (matchList.size() != limit - 1) continue;
                match = input.subSequence(index, input.length()).toString();
                matchList.add(match);
                index = m.end();
            }
            if (index == 0) {
                return new String[]{input.toString()};
            }
            if (!matchLimited || matchList.size() < limit) {
                matchList.add(input.subSequence(index, input.length()).toString());
            }
            if (limit == 0) {
                for (resultSize = matchList.size(); resultSize > 0 && ((String)matchList.get(resultSize - 1)).equals(""); --resultSize) {
                }
            }
            String[] result = new String[resultSize];
            return matchList.subList(0, resultSize).toArray(result);
        }

        public String[] split(CharSequence input) {
            return this.split(input, 0);
        }

        public static String quote(String s) {
            int slashEIndex = s.indexOf("\\E");
            if (slashEIndex == -1) {
                return "\\Q" + s + "\\E";
            }
            StringBuilder sb = new StringBuilder(s.length() * 2);
            sb.append("\\Q");
            slashEIndex = 0;
            int current = 0;
            while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
                sb.append(s.substring(current, slashEIndex));
                current = slashEIndex + 2;
                sb.append("\\E\\\\E\\Q");
            }
            sb.append(s.substring(current, s.length()));
            sb.append("\\E");
            return sb.toString();
        }
    }
}

