/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.ffi;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMeta;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBodyList;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;

public class JTranscFFI {
    public static <T> T loadLibrary(String name, Class<T> clazz) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (JTranscSystem.usingJTransc()) {
            String kind;
            switch (kind = JTranscSystem.getRuntimeKind()) {
                case "js": {
                    return NodeFFI_Library.loadLibrary(name, clazz);
                }
                case "cpp": {
                    return JTranscFFI.loadCppLibrary(name, clazz);
                }
            }
            throw new RuntimeException("Unsupported target for ffi " + kind);
        }
        throw new RuntimeException("Not running on jtransc! TODO: Use JNA instead");
    }

    @HaxeMethodBody(value="var instance = N.newInstance(Type.getClassName(p1._hxFfiClass));\ncast(instance, HaxeFfiLibrary)._ffi__load(p0._str);\nreturn instance;\n")
    private static native <T> T loadCppLibrary(String var0, Class<T> var1);

    public static class Loader {
        @HaxeMeta(value="@:noStack")
        @HaxeMethodBody(value="return HaxeDynamicLoad.dlopen(p0._str);")
        public static native long dlopen(String var0);

        @HaxeMeta(value="@:noStack")
        @HaxeMethodBody(value="return HaxeDynamicLoad.dlsym(p0, p1._str);")
        public static native long dlsym(long var0, String var2);

        @HaxeMeta(value="@:noStack")
        @HaxeMethodBody(value="return HaxeDynamicLoad.dlclose(p0);")
        public static native int dlclose(long var0);
    }

    @HaxeAddMembers(value={"public var lib:Dynamic;"})
    public static class NodeFFI_Library {
        private static String getTypeString(Type type) {
            if (type == Boolean.TYPE) {
                return "uint";
            }
            if (type == Integer.TYPE) {
                return "int";
            }
            if (type == Long.TYPE) {
                return "long";
            }
            if (type == Void.TYPE) {
                return "void";
            }
            if (type == String.class) {
                return "string";
            }
            throw new RuntimeException("Don't know how to serialize " + type);
        }

        public static <T> T loadLibrary(String name, Class<T> clazz) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Method[] methods = clazz.getDeclaredMethods();
            Function[] functions = new Function[methods.length];
            for (int m = 0; m < methods.length; ++m) {
                Method method = methods[m];
                Class<?>[] params = method.getParameterTypes();
                String[] paramsString = new String[params.length];
                for (int n = 0; n < params.length; ++n) {
                    paramsString[n] = NodeFFI_Library.getTypeString(params[n]);
                }
                functions[m] = new Function(method.getName(), NodeFFI_Library.getTypeString(method.getReturnType()), paramsString);
            }
            final NodeFFI_Library library = new NodeFFI_Library(name, functions);
            return (T)Proxy.newProxyInstance(classLoader, new Class[]{clazz}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object result = library.invoke(method.getName(), args);
                    if (method.getReturnType() == Boolean.TYPE) {
                        return (Integer)result != 0;
                    }
                    return result;
                }
            });
        }

        @HaxeMethodBodyList(value={@HaxeMethodBody(target="js", value="var ffi:Dynamic = untyped __js__(\"require('ffi')\");\nvar obj:Dynamic = {};\nfor (item in p1.toArray()) {\n  Reflect.setField(obj, item.name, [N.toNativeString(item.retval), N.toNativeStrArray(item.args)]);\n}\nthis.lib = ffi.Library(p0._str, obj);\n"), @HaxeMethodBody(value="")})
        public NodeFFI_Library(String name, Function[] functions) {
        }

        @HaxeMethodBodyList(value={@HaxeMethodBody(target="js", value="var name = N.toNativeString(p0);\nvar args = N.toNativeUnboxedArray(p1);\nreturn N.box(Reflect.callMethod(this.lib, Reflect.field(this.lib, name), args));"), @HaxeMethodBody(value="return null;")})
        public native Object invoke(String var1, Object ... var2);

        public static class Function {
            public final String name;
            public final String retval;
            public final String[] args;

            public Function(String name, String retval, String ... args) {
                this.name = name;
                this.retval = retval;
                this.args = args;
            }
        }
    }
}

