/*
 * Decompiled with CFR 0.152.
 */
package jtransc;

import java.util.ArrayList;
import jtransc.annotation.JTranscKeep;

public class JTranscInput {
    @JTranscKeep
    public static ListHandler impl = new ListHandler();
    @JTranscKeep
    public static MouseInfo mouseInfo = new MouseInfo();
    @JTranscKeep
    public static KeyInfo keyInfo = new KeyInfo();
    @JTranscKeep
    public static GamepadInfo gamepadInfo = new GamepadInfo();

    public static void addHandler(Handler handler) {
        impl.addHandler(handler);
    }

    public static class ListHandler
    implements Handler,
    Impl {
        private ArrayList<Handler> handlers = new ArrayList();

        @Override
        public void addHandler(Handler handler) {
            this.handlers.add(handler);
        }

        @Override
        public void onKeyTyped(KeyInfo info) {
            for (Handler handler : this.handlers) {
                handler.onKeyTyped(info);
            }
        }

        @Override
        public void onKeyDown(KeyInfo info) {
            for (Handler handler : this.handlers) {
                handler.onKeyDown(info);
            }
        }

        @Override
        public void onKeyUp(KeyInfo info) {
            for (Handler handler : this.handlers) {
                handler.onKeyUp(info);
            }
        }

        @Override
        public void onGamepadPressed(GamepadInfo info) {
            for (Handler handler : this.handlers) {
                handler.onGamepadPressed(info);
            }
        }

        @Override
        public void onGamepadRelepased(GamepadInfo info) {
            for (Handler handler : this.handlers) {
                handler.onGamepadRelepased(info);
            }
        }

        @Override
        public void onMouseDown(MouseInfo info) {
            for (Handler handler : this.handlers) {
                handler.onMouseDown(info);
            }
        }

        @Override
        public void onMouseUp(MouseInfo info) {
            for (Handler handler : this.handlers) {
                handler.onMouseUp(info);
            }
        }

        @Override
        public void onMouseMove(MouseInfo info) {
            for (Handler handler : this.handlers) {
                handler.onMouseMove(info);
            }
        }

        @Override
        public void onMouseScroll(MouseInfo info) {
            for (Handler handler : this.handlers) {
                handler.onMouseScroll(info);
            }
        }

        @Override
        public void onTouchDown(TouchInfo info) {
            for (Handler handler : this.handlers) {
                handler.onTouchDown(info);
            }
        }

        @Override
        public void onTouchDrag(TouchInfo info) {
            for (Handler handler : this.handlers) {
                handler.onTouchDrag(info);
            }
        }

        @Override
        public void onTouchUp(TouchInfo info) {
            for (Handler handler : this.handlers) {
                handler.onTouchUp(info);
            }
        }
    }

    public static interface Handler {
        @JTranscKeep
        public void onKeyTyped(KeyInfo var1);

        @JTranscKeep
        public void onKeyDown(KeyInfo var1);

        @JTranscKeep
        public void onKeyUp(KeyInfo var1);

        @JTranscKeep
        public void onGamepadPressed(GamepadInfo var1);

        @JTranscKeep
        public void onGamepadRelepased(GamepadInfo var1);

        @JTranscKeep
        public void onMouseDown(MouseInfo var1);

        @JTranscKeep
        public void onMouseUp(MouseInfo var1);

        @JTranscKeep
        public void onMouseMove(MouseInfo var1);

        @JTranscKeep
        public void onMouseScroll(MouseInfo var1);

        @JTranscKeep
        public void onTouchDown(TouchInfo var1);

        @JTranscKeep
        public void onTouchDrag(TouchInfo var1);

        @JTranscKeep
        public void onTouchUp(TouchInfo var1);
    }

    @JTranscKeep
    public static class TouchInfo {
    }

    @JTranscKeep
    public static class GamepadInfo {
    }

    @JTranscKeep
    public static class MouseInfo {
        public int x;
        public int y;
        public int buttons;
    }

    @JTranscKeep
    public static class KeyInfo {
        public int keyCode;
    }

    public static interface Impl {
        public void addHandler(Handler var1);
    }
}

