/*
 * Decompiled with CFR 0.152.
 */
package jtransc;

import jtransc.FastMemory;

public class JTranscEndian {
    private static boolean calculated = false;
    private static boolean _le = false;

    private static void calculateOnce() {
        if (calculated) {
            return;
        }
        FastMemory m = new FastMemory(4);
        m.setAlignedInt32(0, 0);
        m.setAlignedInt8(0, (byte)1);
        _le = m.getAlignedInt32(0) == 1;
        calculated = true;
    }

    public static boolean isLittleEndian() {
        JTranscEndian.calculateOnce();
        return _le;
    }

    public static boolean isBigEndian() {
        JTranscEndian.calculateOnce();
        return !_le;
    }

    public static short int16LE(short value) {
        return JTranscEndian.isLittleEndian() ? value : Short.reverseBytes(value);
    }

    public static int int32LE(int value) {
        return JTranscEndian.isLittleEndian() ? value : Integer.reverseBytes(value);
    }

    public static long int64LE(long value) {
        return JTranscEndian.isLittleEndian() ? value : Long.reverseBytes(value);
    }
}

