/*
 * Decompiled with CFR 0.152.
 */
package jtransc;

import java.util.Arrays;

public class IntStack {
    private int[] data;
    private int offset;

    public IntStack() {
        this(64);
    }

    public IntStack(int capacity) {
        this.data = new int[Math.max(1, capacity)];
    }

    private void ensure(int count) {
        int requiredSize = this.offset + count;
        if (requiredSize > this.data.length) {
            this.data = Arrays.copyOf(this.data, Math.max(requiredSize, this.data.length * 2));
        }
    }

    public void push(int value) {
        this.ensure(1);
        this.data[this.offset++] = value;
    }

    public int pop() {
        if (this.offset <= 0) {
            throw new StackOverflowError();
        }
        return this.data[--this.offset];
    }

    public int getLength() {
        return this.offset;
    }
}

