/*
 * Decompiled with CFR 0.152.
 */
package com.jraska.falcon;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public final class Falcon {
    private static final String TAG = "Falcon";

    public static void takeScreenshot(Activity activity, File toFile) {
        if (activity == null) {
            throw new IllegalArgumentException("Parameter activity cannot be null.");
        }
        if (toFile == null) {
            throw new IllegalArgumentException("Parameter toFile cannot be null.");
        }
        Bitmap bitmap = null;
        try {
            bitmap = Falcon.takeBitmapUnchecked(activity);
            Falcon.writeBitmap(bitmap, toFile);
        }
        catch (Exception e) {
            String message = "Unable to take screenshot to file " + toFile.getAbsolutePath() + " of activity " + activity.getClass().getName();
            Log.e((String)TAG, (String)message, (Throwable)e);
            throw new UnableToTakeScreenshotException(message, e);
        }
        finally {
            if (bitmap != null) {
                bitmap.recycle();
            }
        }
        Log.d((String)TAG, (String)("Screenshot captured to " + toFile.getAbsolutePath()));
    }

    public static Bitmap takeScreenshotBitmap(Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("Parameter activity cannot be null.");
        }
        try {
            return Falcon.takeBitmapUnchecked(activity);
        }
        catch (Exception e) {
            String message = "Unable to take screenshot to bitmap of activity " + activity.getClass().getName();
            Log.e((String)TAG, (String)message, (Throwable)e);
            throw new UnableToTakeScreenshotException(message, e);
        }
    }

    private static Bitmap takeBitmapUnchecked(Activity activity) throws InterruptedException {
        List<ViewRootData> viewRoots = Falcon.getRootViews(activity);
        if (viewRoots.isEmpty()) {
            throw new UnableToTakeScreenshotException("Unable to capture any view data in " + activity);
        }
        int maxWidth = Integer.MIN_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        for (ViewRootData viewRoot : viewRoots) {
            if (((ViewRootData)viewRoot)._winFrame.right > maxWidth) {
                maxWidth = ((ViewRootData)viewRoot)._winFrame.right;
            }
            if (((ViewRootData)viewRoot)._winFrame.bottom <= maxHeight) continue;
            maxHeight = ((ViewRootData)viewRoot)._winFrame.bottom;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)maxWidth, (int)maxHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Falcon.drawRootsToBitmap(viewRoots, bitmap);
        } else {
            Falcon.drawRootsToBitmapOtherThread(activity, viewRoots, bitmap);
        }
        return bitmap;
    }

    private static void drawRootsToBitmapOtherThread(Activity activity, final List<ViewRootData> viewRoots, final Bitmap bitmap) throws InterruptedException {
        final AtomicReference errorInMainThread = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Falcon.drawRootsToBitmap(viewRoots, bitmap);
                }
                catch (Exception ex) {
                    errorInMainThread.set(ex);
                }
                finally {
                    latch.countDown();
                }
            }
        });
        latch.await();
        Exception exception = (Exception)errorInMainThread.get();
        if (exception != null) {
            throw new UnableToTakeScreenshotException(exception);
        }
    }

    private static void drawRootsToBitmap(List<ViewRootData> viewRoots, Bitmap bitmap) {
        for (ViewRootData rootData : viewRoots) {
            Falcon.drawRootToBitmap(rootData, bitmap);
        }
    }

    private static void drawRootToBitmap(ViewRootData config, Bitmap bitmap) {
        if ((((ViewRootData)config)._layoutParams.flags & 2) == 2) {
            Canvas dimCanvas = new Canvas(bitmap);
            int alpha = (int)(255.0f * ((ViewRootData)config)._layoutParams.dimAmount);
            dimCanvas.drawARGB(alpha, 0, 0, 0);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)((ViewRootData)config)._winFrame.left, (float)((ViewRootData)config)._winFrame.top);
        config._view.draw(canvas);
    }

    private static void writeBitmap(Bitmap bitmap, File toFile) throws IOException {
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(toFile));
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            Falcon.closeQuietly(outputStream);
            throw throwable;
        }
        Falcon.closeQuietly(outputStream);
    }

    private static void closeQuietly(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static List<ViewRootData> getRootViews(Activity activity) {
        WindowManager.LayoutParams[] params;
        Object[] roots;
        Object globalWindowManager = Build.VERSION.SDK_INT <= 16 ? Falcon.getFieldValue("mWindowManager", activity.getWindowManager()) : Falcon.getFieldValue("mGlobal", activity.getWindowManager());
        Object rootObjects = Falcon.getFieldValue("mRoots", globalWindowManager);
        Object paramsObject = Falcon.getFieldValue("mParams", globalWindowManager);
        if (Build.VERSION.SDK_INT >= 19) {
            roots = ((List)rootObjects).toArray();
            List paramsList = (List)paramsObject;
            params = paramsList.toArray(new WindowManager.LayoutParams[paramsList.size()]);
        } else {
            roots = (Object[])rootObjects;
            params = (WindowManager.LayoutParams[])paramsObject;
        }
        List<ViewRootData> rootViews = Falcon.viewRootData(roots, params);
        if (rootViews.isEmpty()) {
            return Collections.emptyList();
        }
        Falcon.offsetRootsTopLeft(rootViews);
        Falcon.ensureDialogsAreAfterItsParentActivities(rootViews);
        return rootViews;
    }

    private static List<ViewRootData> viewRootData(Object[] roots, WindowManager.LayoutParams[] params) {
        ArrayList<ViewRootData> rootViews = new ArrayList<ViewRootData>();
        for (int i = 0; i < roots.length; ++i) {
            Object root = roots[i];
            View rootView = (View)Falcon.getFieldValue("mView", root);
            if (rootView == null) {
                Log.e((String)TAG, (String)"null View stored as root in Global window manager, skipping");
                continue;
            }
            if (!rootView.isShown()) continue;
            int[] location = new int[2];
            rootView.getLocationOnScreen(location);
            int left = location[0];
            int top = location[1];
            Rect area = new Rect(left, top, left + rootView.getWidth(), top + rootView.getHeight());
            rootViews.add(new ViewRootData(rootView, area, params[i]));
        }
        return rootViews;
    }

    private static void offsetRootsTopLeft(List<ViewRootData> rootViews) {
        int minTop = Integer.MAX_VALUE;
        int minLeft = Integer.MAX_VALUE;
        for (ViewRootData rootView : rootViews) {
            if (((ViewRootData)rootView)._winFrame.top < minTop) {
                minTop = ((ViewRootData)rootView)._winFrame.top;
            }
            if (((ViewRootData)rootView)._winFrame.left >= minLeft) continue;
            minLeft = ((ViewRootData)rootView)._winFrame.left;
        }
        for (ViewRootData rootView : rootViews) {
            rootView._winFrame.offset(-minLeft, -minTop);
        }
    }

    private static void ensureDialogsAreAfterItsParentActivities(List<ViewRootData> viewRoots) {
        if (viewRoots.size() <= 1) {
            return;
        }
        block0: for (int dialogIndex = 0; dialogIndex < viewRoots.size() - 1; ++dialogIndex) {
            ViewRootData viewRoot = viewRoots.get(dialogIndex);
            if (!viewRoot.isDialogType()) continue;
            Activity dialogOwnerActivity = Falcon.ownerActivity(viewRoot.context());
            if (dialogOwnerActivity == null) {
                return;
            }
            for (int parentIndex = dialogIndex + 1; parentIndex < viewRoots.size(); ++parentIndex) {
                ViewRootData possibleParent = viewRoots.get(parentIndex);
                if (!possibleParent.isActivityType() || Falcon.ownerActivity(possibleParent.context()) != dialogOwnerActivity) continue;
                viewRoots.remove(possibleParent);
                viewRoots.add(dialogIndex, possibleParent);
                continue block0;
            }
        }
    }

    private static Activity ownerActivity(Context context) {
        Context currentContext = context;
        while (currentContext != null) {
            if (currentContext instanceof Activity) {
                return (Activity)currentContext;
            }
            if (!(currentContext instanceof ContextWrapper) || currentContext instanceof Application) break;
            currentContext = ((ContextWrapper)currentContext).getBaseContext();
        }
        return null;
    }

    private static Object getFieldValue(String fieldName, Object target) {
        try {
            return Falcon.getFieldValueUnchecked(fieldName, target);
        }
        catch (Exception e) {
            throw new UnableToTakeScreenshotException(e);
        }
    }

    private static Object getFieldValueUnchecked(String fieldName, Object target) throws NoSuchFieldException, IllegalAccessException {
        Field field = Falcon.findField(fieldName, target.getClass());
        field.setAccessible(true);
        return field.get(target);
    }

    static Field findField(String name, Class clazz) throws NoSuchFieldException {
        for (Class currentClass = clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        throw new NoSuchFieldException("Field " + name + " not found for class " + clazz);
    }

    private Falcon() {
    }

    static class ViewRootData {
        final View _view;
        private final Rect _winFrame;
        private final WindowManager.LayoutParams _layoutParams;

        ViewRootData(View view, Rect winFrame, WindowManager.LayoutParams layoutParams) {
            this._view = view;
            this._winFrame = winFrame;
            this._layoutParams = layoutParams;
        }

        boolean isDialogType() {
            return this._layoutParams.type == 2;
        }

        boolean isActivityType() {
            return this._layoutParams.type == 1;
        }

        Context context() {
            return this._view.getContext();
        }
    }

    public static class UnableToTakeScreenshotException
    extends RuntimeException {
        private UnableToTakeScreenshotException(String detailMessage) {
            super(detailMessage);
        }

        private UnableToTakeScreenshotException(String detailMessage, Exception exception) {
            super(detailMessage, UnableToTakeScreenshotException.extractException(exception));
        }

        private UnableToTakeScreenshotException(Exception ex) {
            super(UnableToTakeScreenshotException.extractException(ex));
        }

        private static Throwable extractException(Exception ex) {
            if (ex instanceof UnableToTakeScreenshotException) {
                return ex.getCause();
            }
            return ex;
        }
    }
}

