/*
 * Decompiled with CFR 0.152.
 */
package com.jraska.falcon;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public final class Falcon {
    private static final String TAG = "Falcon";

    public static void takeScreenshot(Activity activity, File toFile) {
        if (activity == null) {
            throw new IllegalArgumentException("Parameter activity cannot be null.");
        }
        if (toFile == null) {
            throw new IllegalArgumentException("Parameter toFile cannot be null.");
        }
        Bitmap bitmap = null;
        try {
            bitmap = Falcon.takeBitmapUnchecked(activity);
            Falcon.writeBitmap(bitmap, toFile);
        }
        catch (Exception e) {
            String message = "Unable to take screenshot to file " + toFile.getAbsolutePath() + " of activity " + activity.getClass().getName();
            Log.e((String)TAG, (String)message, (Throwable)e);
            throw new UnableToTakeScreenshotException(message, e);
        }
        finally {
            if (bitmap != null) {
                bitmap.recycle();
            }
        }
        Log.d((String)TAG, (String)("Screenshot captured to " + toFile.getAbsolutePath()));
    }

    public static Bitmap takeScreenshotBitmap(Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("Parameter activity cannot be null.");
        }
        try {
            return Falcon.takeBitmapUnchecked(activity);
        }
        catch (Exception e) {
            String message = "Unable to take screenshot to bitmap of activity " + activity.getClass().getName();
            Log.e((String)TAG, (String)message, (Throwable)e);
            throw new UnableToTakeScreenshotException(message, e);
        }
    }

    private static Bitmap takeBitmapUnchecked(Activity activity) throws InterruptedException {
        final List<ViewRootData> viewRoots = Falcon.getRootViews(activity);
        View main = activity.getWindow().getDecorView();
        final Bitmap bitmap = Bitmap.createBitmap((int)main.getWidth(), (int)main.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Falcon.drawRootsToBitmap(viewRoots, bitmap);
        } else {
            final CountDownLatch latch = new CountDownLatch(1);
            activity.runOnUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Falcon.drawRootsToBitmap(viewRoots, bitmap);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            latch.await();
        }
        return bitmap;
    }

    private static void drawRootsToBitmap(List<ViewRootData> viewRoots, Bitmap bitmap) {
        for (ViewRootData rootData : viewRoots) {
            Falcon.drawRootToBitmap(rootData, bitmap);
        }
    }

    private static void drawRootToBitmap(ViewRootData config, Bitmap bitmap) {
        if ((((ViewRootData)config)._layoutParams.flags & 2) == 2) {
            Canvas dimCanvas = new Canvas(bitmap);
            int alpha = (int)(255.0f * ((ViewRootData)config)._layoutParams.dimAmount);
            dimCanvas.drawARGB(alpha, 0, 0, 0);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)((ViewRootData)config)._winFrame.left, (float)((ViewRootData)config)._winFrame.top);
        config._view.draw(canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBitmap(Bitmap bitmap, File toFile) throws IOException {
        try (OutputStream outputStream = null;){
            outputStream = new BufferedOutputStream(new FileOutputStream(toFile));
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, outputStream);
        }
    }

    private static List<ViewRootData> getRootViews(Activity activity) {
        WindowManager.LayoutParams[] params;
        Object[] roots;
        ArrayList<ViewRootData> rootViews = new ArrayList<ViewRootData>();
        Object globalWindowManager = Build.VERSION.SDK_INT <= 15 ? Falcon.getFieldValue("mWindowManager", activity.getWindowManager()) : Falcon.getFieldValue("mGlobal", activity.getWindowManager());
        Object rootObjects = Falcon.getFieldValue("mRoots", globalWindowManager);
        Object paramsObject = Falcon.getFieldValue("mParams", globalWindowManager);
        if (Build.VERSION.SDK_INT >= 19) {
            roots = ((List)rootObjects).toArray();
            List paramsList = (List)paramsObject;
            params = paramsList.toArray(new WindowManager.LayoutParams[paramsList.size()]);
        } else {
            roots = (Object[])rootObjects;
            params = (WindowManager.LayoutParams[])paramsObject;
        }
        for (int i = 0; i < roots.length; ++i) {
            Object root = roots[i];
            Object attachInfo = Falcon.getFieldValue("mAttachInfo", root);
            int top = (Integer)Falcon.getFieldValue("mWindowTop", attachInfo);
            int left = (Integer)Falcon.getFieldValue("mWindowLeft", attachInfo);
            Rect winFrame = (Rect)Falcon.getFieldValue("mWinFrame", root);
            Rect area = new Rect(left, top, left + winFrame.width(), top + winFrame.height());
            View view = (View)Falcon.getFieldValue("mView", root);
            rootViews.add(new ViewRootData(view, area, params[i]));
        }
        return rootViews;
    }

    private static Object getFieldValue(String fieldName, Object target) {
        try {
            return Falcon.getFieldValueUnchecked(fieldName, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getFieldValueUnchecked(String fieldName, Object target) throws NoSuchFieldException, IllegalAccessException {
        Field field = Falcon.findField(fieldName, target.getClass());
        field.setAccessible(true);
        return field.get(target);
    }

    private static Field findField(String name, Class clazz) throws NoSuchFieldException {
        for (Class currentClass = clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        throw new NoSuchFieldException("Field " + name + " not found for class " + clazz);
    }

    private Falcon() {
    }

    private static class ViewRootData {
        private final View _view;
        private final Rect _winFrame;
        private final WindowManager.LayoutParams _layoutParams;

        public ViewRootData(View view, Rect winFrame, WindowManager.LayoutParams layoutParams) {
            this._view = view;
            this._winFrame = winFrame;
            this._layoutParams = layoutParams;
        }
    }

    public static class UnableToTakeScreenshotException
    extends RuntimeException {
        private UnableToTakeScreenshotException(String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
        }
    }
}

