/*
 * Decompiled with CFR 0.152.
 */
package com.jpardogo.android.googleprogressbar.library;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.jpardogo.android.googleprogressbar.library.R;

public class NexusRotationCrossDrawable
extends Drawable
implements Drawable.Callback {
    private static final int ANIMATION_DURATION = 150;
    private static final int ANIMATION_START_DELAY = 300;
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private int mCenter;
    private Point[] mArrowPoints = new Point[5];
    private Path mPath = new Path();
    private Paint mPaint1 = new Paint(1);
    private Paint mPaint2;
    private Paint mPaint3;
    private Paint mPaint4;
    private int mRotationAngle;

    public NexusRotationCrossDrawable(int[] colors) {
        this.mPaint1.setColor(colors[0]);
        this.mPaint2 = new Paint(1);
        this.mPaint2.setColor(colors[1]);
        this.mPaint3 = new Paint(1);
        this.mPaint3.setColor(colors[2]);
        this.mPaint4 = new Paint(1);
        this.mPaint4.setColor(colors[3]);
        this.initObjectAnimator();
    }

    private void initObjectAnimator() {
        final ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)((Object)this), (String)"rotationAngle", (int[])new int[]{0, 180});
        objectAnimator.setInterpolator((TimeInterpolator)LINEAR_INTERPOLATOR);
        objectAnimator.setDuration(150L);
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (NexusRotationCrossDrawable.this.mRotationAngle == 180) {
                    objectAnimator.setIntValues(new int[]{180, 360});
                    objectAnimator.setStartDelay(600L);
                } else {
                    objectAnimator.setIntValues(new int[]{0, 180});
                    objectAnimator.setStartDelay(300L);
                    NexusRotationCrossDrawable.this.mRotationAngle = 0;
                }
                objectAnimator.start();
            }
        });
        objectAnimator.start();
    }

    public void draw(Canvas canvas) {
        this.drawArrows(canvas);
    }

    private void drawArrows(Canvas canvas) {
        canvas.rotate((float)this.mRotationAngle, (float)this.mCenter, (float)this.mCenter);
        this.mPath.reset();
        this.mPath.moveTo((float)this.mArrowPoints[0].x, (float)this.mArrowPoints[0].y);
        for (int i = 1; i < this.mArrowPoints.length; ++i) {
            this.mPath.lineTo((float)this.mArrowPoints[i].x, (float)this.mArrowPoints[i].y);
        }
        this.mPath.lineTo((float)this.mArrowPoints[0].x, (float)this.mArrowPoints[0].y);
        canvas.save();
        canvas.drawPath(this.mPath, this.mPaint1);
        canvas.restore();
        canvas.save();
        canvas.rotate(90.0f, (float)this.mCenter, (float)this.mCenter);
        canvas.drawPath(this.mPath, this.mPaint2);
        canvas.restore();
        canvas.save();
        canvas.rotate(180.0f, (float)this.mCenter, (float)this.mCenter);
        canvas.drawPath(this.mPath, this.mPaint3);
        canvas.restore();
        canvas.save();
        canvas.rotate(270.0f, (float)this.mCenter, (float)this.mCenter);
        canvas.drawPath(this.mPath, this.mPaint4);
        canvas.restore();
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint1.setAlpha(alpha);
        this.mPaint2.setAlpha(alpha);
        this.mPaint3.setAlpha(alpha);
        this.mPaint4.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint1.setColorFilter(cf);
        this.mPaint2.setColorFilter(cf);
        this.mPaint3.setColorFilter(cf);
        this.mPaint4.setColorFilter(cf);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.measureDrawable(bounds);
    }

    private void measureDrawable(Rect bounds) {
        this.mCenter = bounds.centerX();
        int arrowMargin = bounds.width() / 50;
        int arrowWidth = bounds.width() / 15;
        int padding = this.mCenter - (int)((double)this.mCenter / Math.sqrt(2.0));
        this.mArrowPoints[0] = new Point(this.mCenter - arrowMargin, this.mCenter - arrowMargin);
        this.mArrowPoints[1] = new Point(this.mArrowPoints[0].x, this.mArrowPoints[0].y - arrowWidth);
        this.mArrowPoints[2] = new Point(padding + arrowWidth, padding);
        this.mArrowPoints[3] = new Point(padding, padding + arrowWidth);
        this.mArrowPoints[4] = new Point(this.mArrowPoints[0].x - arrowWidth, this.mArrowPoints[0].y);
    }

    public int getOpacity() {
        return -3;
    }

    void setRotationAngle(int angle) {
        this.mRotationAngle = angle;
    }

    int getRotationAngle() {
        return this.mRotationAngle;
    }

    public static class Builder {
        private int[] mColors;

        public Builder(Context context) {
            this.initDefaults(context);
        }

        private void initDefaults(Context context) {
            this.mColors = context.getResources().getIntArray(R.array.google_colors);
        }

        public Builder colors(int[] colors) {
            if (colors == null || colors.length != 4) {
                throw new IllegalArgumentException("Your color array must contains 4 values");
            }
            this.mColors = colors;
            return this;
        }

        public Drawable build() {
            return new NexusRotationCrossDrawable(this.mColors);
        }
    }
}

