/*
 * Decompiled with CFR 0.152.
 */
package com.wangzai.rvadapter.base;

import android.content.Context;
import android.support.v4.util.SparseArrayCompat;
import com.wangzai.rvadapter.base.DelegateType;
import com.wangzai.rvadapter.base.ViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\"\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ+\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u001b\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001cJ\u0014\u0010\u001b\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000f\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/wangzai/rvadapter/base/DelegateManager;", "T", "", "()V", "delegateCount", "", "getDelegateCount", "()I", "mDelegates", "Landroid/support/v4/util/SparseArrayCompat;", "Lcom/wangzai/rvadapter/base/DelegateType;", "getMDelegates", "()Landroid/support/v4/util/SparseArrayCompat;", "addDelegate", "delegate", "viewType", "convert", "", "context", "Landroid/content/Context;", "holder", "Lcom/wangzai/rvadapter/base/ViewHolder;", "item", "position", "(Landroid/content/Context;Lcom/wangzai/rvadapter/base/ViewHolder;Ljava/lang/Object;I)V", "getItemViewDelegate", "getItemViewLayoutId", "getItemViewType", "(Ljava/lang/Object;I)I", "removeDelegate", "rvadapter_release"})
public final class DelegateManager<T> {
    @NotNull
    private final SparseArrayCompat<DelegateType<T>> mDelegates = new SparseArrayCompat();

    @NotNull
    public final SparseArrayCompat<DelegateType<T>> getMDelegates() {
        return this.mDelegates;
    }

    public final int getDelegateCount() {
        return this.mDelegates.size();
    }

    /*
     * WARNING - void declaration
     */
    public final int getItemViewType(T item, int position) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = (Iterable)new IntRange(0, this.getDelegateCount() - 1);
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            if (!((DelegateType)this.mDelegates.valueAt(it)).isItemViewType(item, position)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterator = $receiver$iv.iterator();
        if (iterator.hasNext()) {
            Object element$iv = iterator.next();
            int it = ((Number)element$iv).intValue();
            return this.mDelegates.keyAt(it);
        }
        throw (Throwable)new IllegalArgumentException("No ItemViewDelegate added that matches position = " + position + " in data = " + item + " source");
    }

    /*
     * WARNING - void declaration
     */
    public final void convert(@NotNull Context context, @NotNull ViewHolder holder, T item, int position) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        int n = 0;
        int n2 = this.getDelegateCount() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                DelegateType delegate;
                if ((delegate = (DelegateType)this.mDelegates.valueAt((int)i)).isItemViewType(item, position)) {
                    delegate.convert(context, holder, item, position);
                    return;
                }
                if (i == n2) break;
                ++i;
            }
        }
        throw (Throwable)new IllegalArgumentException("No ItemViewDelegateManager added that matches position= " + position + " in data = " + item + " source");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DelegateManager<T> addDelegate(@NotNull DelegateType<? super T> delegate) {
        Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
        int n = 0;
        int n2 = this.getDelegateCount() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (((DelegateType)this.mDelegates.valueAt((int)i)).getItemViewLayoutId() == delegate.getItemViewLayoutId()) {
                    throw (Throwable)new IllegalArgumentException("An ItemViewDelegate is already registered for the delegate = " + delegate + ".");
                }
                if (i == n2) break;
                ++i;
            }
        }
        this.mDelegates.put(this.mDelegates.size(), delegate);
        return this;
    }

    @NotNull
    public final DelegateManager<T> addDelegate(int viewType, @NotNull DelegateType<? super T> delegate) {
        Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
        if (this.mDelegates.get(viewType) != null) {
            throw (Throwable)new IllegalArgumentException("An ItemViewDelegate is already registered for the viewType = " + viewType + ". Already registered ItemViewDelegate is " + (DelegateType)this.mDelegates.get(viewType));
        }
        this.mDelegates.put(viewType, delegate);
        return this;
    }

    @NotNull
    public final DelegateManager<T> removeDelegate(@NotNull DelegateType<? super T> delegate) {
        Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
        int indexToRemove = this.mDelegates.indexOfValue(delegate);
        if (indexToRemove >= 0) {
            this.mDelegates.removeAt(indexToRemove);
        }
        return this;
    }

    @NotNull
    public final DelegateManager<T> removeDelegate(int viewType) {
        int indexToRemove = this.mDelegates.indexOfKey(viewType);
        if (indexToRemove >= 0) {
            this.mDelegates.removeAt(indexToRemove);
        }
        return this;
    }

    @NotNull
    public final DelegateType<T> getItemViewDelegate(int viewType) {
        Object object = this.mDelegates.get(viewType);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mDelegates.get(viewType)");
        return (DelegateType)object;
    }

    public final int getItemViewLayoutId(int viewType) {
        return this.getItemViewDelegate(viewType).getItemViewLayoutId();
    }

    public final int getItemViewType(@NotNull DelegateType<? super T> delegate) {
        Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
        return this.mDelegates.indexOfValue(delegate);
    }
}

