/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.integration.android;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.Display;
import android.view.WindowManager;
import com.google.zxing.integration.android.IntentResult;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntentIntegrator {
    public static final int REQUEST_CODE = 49374;
    private static final String TAG = IntentIntegrator.class.getSimpleName();
    public static final Collection<String> PRODUCT_CODE_TYPES = IntentIntegrator.list("UPC_A", "UPC_E", "EAN_8", "EAN_13", "RSS_14");
    public static final Collection<String> ONE_D_CODE_TYPES = IntentIntegrator.list("UPC_A", "UPC_E", "EAN_8", "EAN_13", "CODE_39", "CODE_93", "CODE_128", "ITF", "RSS_14", "RSS_EXPANDED");
    public static final Collection<String> QR_CODE_TYPES = Collections.singleton("QR_CODE");
    public static final Collection<String> DATA_MATRIX_TYPES = Collections.singleton("DATA_MATRIX");
    public static final Collection<String> ALL_CODE_TYPES = null;
    private final Activity activity;
    private Fragment fragment;
    private android.support.v4.app.Fragment supportFragment;
    private final Map<String, Object> moreExtras = new HashMap<String, Object>(3);
    private Collection<String> desiredBarcodeFormats;
    private static final boolean HAVE_STANDARD_SCANNER;
    private static final boolean HAVE_LEGACY_SCANNER;
    private static final String STANDARD_PACKAGE_NAME = "com.google.zxing.client.android";
    private static final String LEGACY_PACKAGE_NAME = "com.google.zxing.client.androidlegacy";

    protected Class<?> getCaptureActivity() {
        try {
            return Class.forName(IntentIntegrator.getScannerPackage() + ".CaptureActivity");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find CaptureActivity. Make sure one of the zxing-android libraries are loaded.", e);
        }
    }

    private static String getScannerPackage() {
        if (HAVE_STANDARD_SCANNER && Build.VERSION.SDK_INT >= 15) {
            return STANDARD_PACKAGE_NAME;
        }
        if (HAVE_LEGACY_SCANNER) {
            return LEGACY_PACKAGE_NAME;
        }
        return STANDARD_PACKAGE_NAME;
    }

    public IntentIntegrator(Activity activity) {
        this.activity = activity;
    }

    public static IntentIntegrator forSupportFragment(android.support.v4.app.Fragment fragment) {
        IntentIntegrator integrator = new IntentIntegrator((Activity)fragment.getActivity());
        integrator.supportFragment = fragment;
        return integrator;
    }

    @TargetApi(value=11)
    public static IntentIntegrator forFragment(Fragment fragment) {
        IntentIntegrator integrator = new IntentIntegrator(fragment.getActivity());
        integrator.fragment = fragment;
        return integrator;
    }

    public Map<String, ?> getMoreExtras() {
        return this.moreExtras;
    }

    public final IntentIntegrator addExtra(String key, Object value) {
        this.moreExtras.put(key, value);
        return this;
    }

    public final IntentIntegrator setCaptureLayout(int resourceId) {
        this.addExtra("ZXING_CAPTURE_LAYOUT_ID_KEY", resourceId);
        return this;
    }

    public final IntentIntegrator setLegacyCaptureLayout(int resourceId) {
        this.addExtra("ZXINGLEGACY_CAPTURE_LAYOUT_ID_KEY", resourceId);
        return this;
    }

    public final IntentIntegrator setPrompt(String prompt) {
        if (prompt != null) {
            this.addExtra("PROMPT_MESSAGE", prompt);
        }
        return this;
    }

    public final IntentIntegrator setResultDisplayDuration(long ms) {
        this.addExtra("RESULT_DISPLAY_DURATION_MS", ms);
        return this;
    }

    public final IntentIntegrator setScanningRectangle(int desiredWidth, int desiredHeight) {
        this.addExtra("SCAN_WIDTH", desiredWidth);
        this.addExtra("SCAN_HEIGHT", desiredHeight);
        return this;
    }

    public void setOrientation(int orientation) {
        this.addExtra("SCAN_ORIENTATION", orientation);
    }

    public void setWide() {
        this.addExtra("SCAN_WIDE", true);
        WindowManager window = this.activity.getWindowManager();
        Display display = window.getDefaultDisplay();
        int displayWidth = display.getWidth();
        int displayHeight = display.getHeight();
        if (displayHeight > displayWidth) {
            int temp = displayWidth;
            displayWidth = displayHeight;
            displayHeight = temp;
        }
        int desiredWidth = displayWidth * 9 / 10;
        int desiredHeight = Math.min(displayHeight * 3 / 4, 400);
        this.setScanningRectangle(desiredWidth, desiredHeight);
    }

    public static boolean shouldBeWide(Collection<String> desiredBarcodeFormats) {
        boolean scan1d = false;
        boolean scan2d = false;
        for (String format : desiredBarcodeFormats) {
            if (ONE_D_CODE_TYPES.contains(format)) {
                scan1d = true;
            }
            if (!QR_CODE_TYPES.contains(format) && !DATA_MATRIX_TYPES.contains(format)) continue;
            scan2d = true;
        }
        return scan1d && !scan2d;
    }

    public IntentIntegrator autoWide() {
        if (this.desiredBarcodeFormats != null && IntentIntegrator.shouldBeWide(this.desiredBarcodeFormats)) {
            this.setWide();
        }
        return this;
    }

    public IntentIntegrator setCameraId(int cameraId) {
        if (cameraId >= 0) {
            this.addExtra("SCAN_CAMERA_ID", cameraId);
        }
        return this;
    }

    public IntentIntegrator setDesiredBarcodeFormats(Collection<String> desiredBarcodeFormats) {
        this.desiredBarcodeFormats = desiredBarcodeFormats;
        return this;
    }

    public final void initiateScan() {
        this.startActivityForResult(this.createScanIntent(), 49374);
    }

    public Intent createScanIntent() {
        Intent intentScan = new Intent((Context)this.activity, this.getCaptureActivity());
        intentScan.setAction("com.google.zxing.client.android.SCAN");
        if (this.desiredBarcodeFormats != null) {
            StringBuilder joinedByComma = new StringBuilder();
            for (String format : this.desiredBarcodeFormats) {
                if (joinedByComma.length() > 0) {
                    joinedByComma.append(',');
                }
                joinedByComma.append(format);
            }
            intentScan.putExtra("SCAN_FORMATS", joinedByComma.toString());
        }
        intentScan.addFlags(0x4000000);
        intentScan.addFlags(524288);
        this.attachMoreExtras(intentScan);
        return intentScan;
    }

    public final void initiateScan(Collection<String> desiredBarcodeFormats) {
        this.setDesiredBarcodeFormats(desiredBarcodeFormats);
        this.initiateScan();
    }

    protected void startActivityForResult(Intent intent, int code) {
        if (this.fragment != null) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.fragment.startActivityForResult(intent, code);
            }
        } else if (this.supportFragment != null) {
            this.supportFragment.startActivityForResult(intent, code);
        } else {
            this.activity.startActivityForResult(intent, code);
        }
    }

    protected void startActivity(Intent intent) {
        if (this.fragment != null) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.fragment.startActivity(intent);
            }
        } else if (this.supportFragment != null) {
            this.supportFragment.startActivity(intent);
        } else {
            this.activity.startActivity(intent);
        }
    }

    public static IntentResult parseActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == 49374) {
            if (resultCode == -1) {
                String contents = intent.getStringExtra("SCAN_RESULT");
                String formatName = intent.getStringExtra("SCAN_RESULT_FORMAT");
                byte[] rawBytes = intent.getByteArrayExtra("SCAN_RESULT_BYTES");
                int intentOrientation = intent.getIntExtra("SCAN_RESULT_ORIENTATION", Integer.MIN_VALUE);
                Integer orientation = intentOrientation == Integer.MIN_VALUE ? null : Integer.valueOf(intentOrientation);
                String errorCorrectionLevel = intent.getStringExtra("SCAN_RESULT_ERROR_CORRECTION_LEVEL");
                return new IntentResult(contents, formatName, rawBytes, orientation, errorCorrectionLevel);
            }
            return new IntentResult();
        }
        return null;
    }

    private static List<String> list(String ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    private void attachMoreExtras(Intent intent) {
        for (Map.Entry<String, Object> entry : this.moreExtras.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Integer) {
                intent.putExtra(key, (Serializable)((Integer)value));
                continue;
            }
            if (value instanceof Long) {
                intent.putExtra(key, (Serializable)((Long)value));
                continue;
            }
            if (value instanceof Boolean) {
                intent.putExtra(key, (Serializable)((Boolean)value));
                continue;
            }
            if (value instanceof Double) {
                intent.putExtra(key, (Serializable)((Double)value));
                continue;
            }
            if (value instanceof Float) {
                intent.putExtra(key, (Serializable)((Float)value));
                continue;
            }
            if (value instanceof Bundle) {
                intent.putExtra(key, (Bundle)value);
                continue;
            }
            intent.putExtra(key, value.toString());
        }
    }

    static {
        boolean test1 = false;
        try {
            Class.forName("com.google.zxing.client.android.CaptureActivity");
            test1 = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        HAVE_STANDARD_SCANNER = test1;
        boolean test2 = false;
        try {
            Class.forName("com.google.zxing.client.androidlegacy.CaptureActivity");
            test2 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAVE_LEGACY_SCANNER = test2;
    }
}

