/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner.camera;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.journeyapps.barcodescanner.camera.CameraSettings;
import java.util.ArrayList;
import java.util.Collection;

public final class AutoFocusManager {
    private static final String TAG = AutoFocusManager.class.getSimpleName();
    private static final long AUTO_FOCUS_INTERVAL_MS = 2000L;
    private boolean stopped;
    private boolean focusing;
    private final boolean useAutoFocus;
    private final Camera camera;
    private Handler handler;
    private int MESSAGE_FOCUS = 1;
    private static final Collection<String> FOCUS_MODES_CALLING_AF = new ArrayList<String>(2);
    private final Handler.Callback focusHandlerCallback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (msg.what == AutoFocusManager.this.MESSAGE_FOCUS) {
                AutoFocusManager.this.focus();
                return true;
            }
            return false;
        }
    };
    private final Camera.AutoFocusCallback autoFocusCallback = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean success, Camera theCamera) {
            AutoFocusManager.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AutoFocusManager.this.focusing = false;
                    AutoFocusManager.this.autoFocusAgainLater();
                }
            });
        }
    };

    public AutoFocusManager(Camera camera, CameraSettings settings) {
        this.handler = new Handler(this.focusHandlerCallback);
        this.camera = camera;
        String currentFocusMode = camera.getParameters().getFocusMode();
        this.useAutoFocus = settings.isAutoFocusEnabled() && FOCUS_MODES_CALLING_AF.contains(currentFocusMode);
        Log.i((String)TAG, (String)("Current focus mode '" + currentFocusMode + "'; use auto focus? " + this.useAutoFocus));
        this.start();
    }

    private synchronized void autoFocusAgainLater() {
        if (!this.stopped && !this.handler.hasMessages(this.MESSAGE_FOCUS)) {
            this.handler.sendMessageDelayed(this.handler.obtainMessage(this.MESSAGE_FOCUS), 2000L);
        }
    }

    public void start() {
        this.stopped = false;
        this.focus();
    }

    private void focus() {
        if (this.useAutoFocus && !this.stopped && !this.focusing) {
            try {
                this.camera.autoFocus(this.autoFocusCallback);
                this.focusing = true;
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Unexpected exception while focusing", (Throwable)re);
                this.autoFocusAgainLater();
            }
        }
    }

    private void cancelOutstandingTask() {
        this.handler.removeMessages(this.MESSAGE_FOCUS);
    }

    public void stop() {
        this.stopped = true;
        this.focusing = false;
        this.cancelOutstandingTask();
        if (this.useAutoFocus) {
            try {
                this.camera.cancelAutoFocus();
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Unexpected exception while cancelling focusing", (Throwable)re);
            }
        }
    }

    static {
        FOCUS_MODES_CALLING_AF.add("auto");
        FOCUS_MODES_CALLING_AF.add("macro");
    }
}

