/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner;

public class Size
implements Comparable<Size> {
    public final int width;
    public final int height;

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Size rotate() {
        return new Size(this.height, this.width);
    }

    public Size scale(int n, int d) {
        return new Size(this.width * n / d, this.height * n / d);
    }

    public Size scaleFit(Size into) {
        if (this.width * into.height >= into.width * this.height) {
            return new Size(into.width, this.height * into.width / this.width);
        }
        return new Size(this.width * into.height / this.height, into.height);
    }

    public Size scaleCrop(Size into) {
        if (this.width * into.height <= into.width * this.height) {
            return new Size(into.width, this.height * into.width / this.width);
        }
        return new Size(this.width * into.height / this.height, into.height);
    }

    public boolean fitsIn(Size other) {
        return this.width <= other.width && this.height <= other.height;
    }

    @Override
    public int compareTo(Size other) {
        int bPixels = other.height * other.width;
        int aPixels = this.height * this.width;
        if (bPixels < aPixels) {
            return 1;
        }
        if (bPixels > aPixels) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.width + "x" + this.height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Size size = (Size)o;
        if (this.width != size.width) {
            return false;
        }
        return this.height == size.height;
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        return result;
    }
}

