/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.google.zxing.client.android.R;
import com.journeyapps.barcodescanner.RotationCallback;
import com.journeyapps.barcodescanner.RotationListener;
import com.journeyapps.barcodescanner.Size;
import com.journeyapps.barcodescanner.Util;
import com.journeyapps.barcodescanner.camera.CameraInstance;
import com.journeyapps.barcodescanner.camera.CameraSettings;
import com.journeyapps.barcodescanner.camera.DisplayConfiguration;
import java.util.ArrayList;
import java.util.List;

public class CameraPreview
extends ViewGroup {
    private static final String TAG = CameraPreview.class.getSimpleName();
    private CameraInstance cameraInstance;
    private WindowManager windowManager;
    private Handler stateHandler;
    private SurfaceView surfaceView;
    private boolean previewActive = false;
    private RotationListener rotationListener;
    private List<StateListener> stateListeners = new ArrayList<StateListener>();
    private DisplayConfiguration displayConfiguration;
    private CameraSettings cameraSettings = new CameraSettings();
    private Size containerSize;
    private Size previewSize;
    private Rect surfaceRect;
    private Size currentSurfaceSize;
    private Rect framingRect = null;
    private Rect previewFramingRect = null;
    private final SurfaceHolder.Callback surfaceCallback = new SurfaceHolder.Callback(){

        public void surfaceCreated(SurfaceHolder holder) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            CameraPreview.this.currentSurfaceSize = null;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (holder == null) {
                Log.e((String)TAG, (String)"*** WARNING *** surfaceChanged() gave us a null surface!");
                return;
            }
            CameraPreview.this.currentSurfaceSize = new Size(width, height);
            CameraPreview.this.startPreviewIfReady();
        }
    };
    private final Handler.Callback stateCallback = new Handler.Callback(){

        public boolean handleMessage(Message message) {
            if (message.what == R.id.zxing_prewiew_size_ready) {
                CameraPreview.this.previewSized((Size)message.obj);
                return true;
            }
            if (message.what == R.id.zxing_camera_error) {
                Exception error = (Exception)message.obj;
                if (CameraPreview.this.isActive()) {
                    CameraPreview.this.pause();
                    CameraPreview.this.fireState.cameraError(error);
                }
            }
            return false;
        }
    };
    private RotationCallback rotationCallback = new RotationCallback(){

        @Override
        public void onRotationChanged(int rotation) {
            CameraPreview.this.stateHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraPreview.this.rotationChanged();
                }
            });
        }
    };
    private final StateListener fireState = new StateListener(){

        @Override
        public void previewSized() {
            for (StateListener listener : CameraPreview.this.stateListeners) {
                listener.previewSized();
            }
        }

        @Override
        public void previewStarted() {
            for (StateListener listener : CameraPreview.this.stateListeners) {
                listener.previewStarted();
            }
        }

        @Override
        public void previewStopped() {
            for (StateListener listener : CameraPreview.this.stateListeners) {
                listener.previewStopped();
            }
        }

        @Override
        public void cameraError(Exception error) {
            for (StateListener listener : CameraPreview.this.stateListeners) {
                listener.cameraError(error);
            }
        }
    };

    public CameraPreview(Context context) {
        super(context);
        this.initialize(context, null, 0, 0);
    }

    public CameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0, 0);
    }

    public CameraPreview(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr, 0);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (this.getBackground() == null) {
            this.setBackgroundColor(-16777216);
        }
        this.windowManager = (WindowManager)context.getSystemService("window");
        this.stateHandler = new Handler(this.stateCallback);
        this.setupSurfaceView();
        this.rotationListener = new RotationListener();
    }

    private void rotationChanged() {
        this.pause();
        this.resume();
    }

    private void setupSurfaceView() {
        this.surfaceView = new SurfaceView(this.getContext());
        if (Build.VERSION.SDK_INT < 11) {
            this.surfaceView.getHolder().setType(3);
        }
        this.surfaceView.getHolder().addCallback(this.surfaceCallback);
        this.addView((View)this.surfaceView);
    }

    public void addStateListener(StateListener listener) {
        this.stateListeners.add(listener);
    }

    private void calculateFrames() {
        if (this.containerSize == null || this.previewSize == null || this.displayConfiguration == null) {
            this.previewFramingRect = null;
            this.framingRect = null;
            this.surfaceRect = null;
            throw new IllegalStateException("containerSize or previewSize is not set yet");
        }
        int previewWidth = this.previewSize.width;
        int previewHeight = this.previewSize.height;
        int width = this.containerSize.width;
        int height = this.containerSize.height;
        this.surfaceRect = this.displayConfiguration.scalePreview(this.previewSize);
        Rect container = new Rect(0, 0, width, height);
        this.framingRect = this.calculateFramingRect(container, this.surfaceRect);
        Rect frameInPreview = new Rect(this.framingRect);
        frameInPreview.offset(-this.surfaceRect.left, -this.surfaceRect.top);
        this.previewFramingRect = new Rect(frameInPreview.left * previewWidth / this.surfaceRect.width(), frameInPreview.top * previewHeight / this.surfaceRect.height(), frameInPreview.right * previewWidth / this.surfaceRect.width(), frameInPreview.bottom * previewHeight / this.surfaceRect.height());
        if (this.previewFramingRect.width() <= 0 || this.previewFramingRect.height() <= 0) {
            this.previewFramingRect = null;
            this.framingRect = null;
            Log.w((String)TAG, (String)"Preview frame is too small");
        } else {
            this.fireState.previewSized();
        }
    }

    public void setTorch(boolean on) {
        if (this.cameraInstance != null) {
            this.cameraInstance.setTorch(on);
        }
    }

    private void containerSized(Size containerSize) {
        this.containerSize = containerSize;
        if (this.cameraInstance != null && this.cameraInstance.getDisplayConfiguration() == null) {
            this.displayConfiguration = new DisplayConfiguration(this.getDisplayRotation(), containerSize);
            this.cameraInstance.setDisplayConfiguration(this.displayConfiguration);
            this.cameraInstance.configureCamera();
        }
    }

    private void previewSized(Size size) {
        this.previewSize = size;
        if (this.containerSize != null) {
            this.calculateFrames();
            this.requestLayout();
            this.startPreviewIfReady();
        }
    }

    private void startPreviewIfReady() {
        if (this.currentSurfaceSize != null && this.previewSize != null && this.surfaceRect != null && this.currentSurfaceSize.equals(new Size(this.surfaceRect.width(), this.surfaceRect.height()))) {
            this.startCameraPreview(this.surfaceView.getHolder());
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.containerSized(new Size(r - l, b - t));
        if (this.surfaceRect == null) {
            this.surfaceView.layout(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.surfaceView.layout(this.surfaceRect.left, this.surfaceRect.top, this.surfaceRect.right, this.surfaceRect.bottom);
        }
    }

    public Rect getFramingRect() {
        return this.framingRect;
    }

    public Rect getPreviewFramingRect() {
        return this.previewFramingRect;
    }

    public CameraSettings getCameraSettings() {
        return this.cameraSettings;
    }

    public void setCameraSettings(CameraSettings cameraSettings) {
        this.cameraSettings = cameraSettings;
    }

    public void resume() {
        Util.validateMainThread();
        Log.d((String)TAG, (String)"resume()");
        this.initCamera();
        if (this.currentSurfaceSize != null) {
            this.startPreviewIfReady();
        } else {
            this.surfaceView.getHolder().addCallback(this.surfaceCallback);
        }
        this.requestLayout();
        this.rotationListener.listen(this.getContext(), this.rotationCallback);
    }

    public void pause() {
        Util.validateMainThread();
        Log.d((String)TAG, (String)"pause()");
        if (this.cameraInstance != null) {
            this.cameraInstance.close();
            this.cameraInstance = null;
            this.previewActive = false;
        }
        if (this.currentSurfaceSize == null) {
            SurfaceHolder surfaceHolder = this.surfaceView.getHolder();
            surfaceHolder.removeCallback(this.surfaceCallback);
        }
        this.containerSize = null;
        this.previewSize = null;
        this.previewFramingRect = null;
        this.rotationListener.stop();
        this.fireState.previewStopped();
    }

    protected boolean isActive() {
        return this.cameraInstance != null;
    }

    private int getDisplayRotation() {
        return this.windowManager.getDefaultDisplay().getRotation();
    }

    private void initCamera() {
        if (this.cameraInstance != null) {
            Log.w((String)TAG, (String)"initCamera called twice");
            return;
        }
        this.cameraInstance = new CameraInstance(this.getContext());
        this.cameraInstance.setCameraSettings(this.cameraSettings);
        this.cameraInstance.setReadyHandler(this.stateHandler);
        this.cameraInstance.open();
    }

    private void startCameraPreview(SurfaceHolder holder) {
        if (!this.previewActive) {
            Log.i((String)TAG, (String)"Starting preview");
            this.cameraInstance.setSurfaceHolder(holder);
            this.cameraInstance.startPreview();
            this.previewActive = true;
            this.previewStarted();
            this.fireState.previewStarted();
        }
    }

    protected void previewStarted() {
    }

    public CameraInstance getCameraInstance() {
        return this.cameraInstance;
    }

    public boolean isPreviewActive() {
        return this.previewActive;
    }

    protected Rect calculateFramingRect(Rect container, Rect surface) {
        Rect intersection = new Rect(container);
        intersection.intersect(surface);
        int margin = Math.min(intersection.width() / 10, intersection.height() / 10);
        intersection.inset(margin, margin);
        if (intersection.height() > intersection.width()) {
            intersection.inset(0, (intersection.height() - intersection.width()) / 2);
        }
        return intersection;
    }

    public static interface StateListener {
        public void previewSized();

        public void previewStarted();

        public void previewStopped();

        public void cameraError(Exception var1);
    }
}

