/*
 * Decompiled with CFR 0.152.
 */
package com.joshdholtz.sentry;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Sentry {
    private static final String TAG = "Sentry";
    private static final String sentryVersion = "7";
    private static final int MAX_QUEUE_LENGTH = 50;
    public static boolean debug = false;
    private Context context;
    private String baseUrl;
    private Uri dsn;
    private AppInfo appInfo = AppInfo.Empty;
    private boolean verifySsl;
    private SentryEventCaptureListener captureListener;
    private JSONObject contexts = new JSONObject();
    private Executor executor;
    final Breadcrumbs breadcrumbs = new Breadcrumbs();

    private Sentry() {
    }

    private static void log(String text) {
        if (debug) {
            Log.d((String)TAG, (String)text);
        }
    }

    private static Sentry getInstance() {
        return LazyHolder.instance;
    }

    public static void init(Context context, String dsn) {
        Sentry.init(context, dsn, true);
    }

    public static void init(Context context, String dsn, boolean setupUncaughtExceptionHandler) {
        Sentry sentry = Sentry.getInstance();
        sentry.context = context.getApplicationContext();
        Uri uri = Uri.parse((String)dsn);
        String port = "";
        if (uri.getPort() >= 0) {
            port = ":" + uri.getPort();
        }
        sentry.baseUrl = uri.getScheme() + "://" + uri.getHost() + port;
        sentry.dsn = uri;
        sentry.appInfo = AppInfo.Read(sentry.context);
        sentry.verifySsl = Sentry.getVerifySsl(dsn);
        sentry.contexts = Sentry.readContexts(sentry.context, sentry.appInfo);
        sentry.executor = Sentry.fixedQueueDiscardingExecutor(50);
        if (setupUncaughtExceptionHandler) {
            sentry.setupUncaughtExceptionHandler();
        }
    }

    private static Executor fixedQueueDiscardingExecutor(int queueSize) {
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicLong count = new AtomicLong();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(String.format(Locale.US, "Sentry HTTP Thread %d", this.count.incrementAndGet()));
                return thread;
            }
        };
        return new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize), threadFactory, new ThreadPoolExecutor.DiscardPolicy());
    }

    private static boolean getVerifySsl(String dsn) {
        try {
            Uri uri = Uri.parse((String)dsn);
            String value = uri.getQueryParameter("verify_ssl");
            return value == null || Integer.parseInt(value) != 0;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Could not parse verify_ssl correctly", (Throwable)e);
            return true;
        }
    }

    private void setupUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler != null) {
            Sentry.log("current handler class=" + currentHandler.getClass().getName());
        }
        if (!(currentHandler instanceof SentryUncaughtExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new SentryUncaughtExceptionHandler(currentHandler, InternalStorage.getInstance()));
        }
        Sentry.sendAllCachedCapturedEvents();
    }

    private static String createXSentryAuthHeader(Uri dsn) {
        StringBuilder header = new StringBuilder();
        String authority = dsn.getAuthority().replace("@" + dsn.getHost(), "");
        String[] authorityParts = authority.split(":");
        String publicKey = authorityParts[0];
        String secretKey = authorityParts[1];
        header.append("Sentry ").append(String.format("sentry_version=%s,", sentryVersion)).append(String.format("sentry_client=sentry-android/%s,", "1.6.2")).append(String.format("sentry_key=%s,", publicKey)).append(String.format("sentry_secret=%s", secretKey));
        return header.toString();
    }

    private static String getProjectId(Uri dsn) {
        String path = dsn.getPath();
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static void sendAllCachedCapturedEvents() {
        List<SentryEventRequest> unsentRequests = InternalStorage.getInstance().getUnsentRequests();
        Sentry.log("Sending up " + unsentRequests.size() + " cached response(s)");
        for (SentryEventRequest request : unsentRequests) {
            Sentry.doCaptureEventPost(request);
        }
    }

    public static void setCaptureListener(SentryEventCaptureListener captureListener) {
        Sentry.getInstance().captureListener = captureListener;
    }

    public static void setMaxBreadcrumbs(int maxBreadcrumbs) {
        Sentry.getInstance().breadcrumbs.setMaxBreadcrumbs(maxBreadcrumbs);
    }

    public static void captureMessage(String message) {
        Sentry.captureMessage(message, SentryEventLevel.INFO);
    }

    public static void captureMessage(String message, SentryEventLevel level) {
        Sentry.captureEvent(new SentryEventBuilder().setMessage(message).setLevel(level));
    }

    public static void captureException(Throwable t) {
        Sentry.captureException(t, t.getMessage(), SentryEventLevel.ERROR);
    }

    public static void captureException(Throwable t, String message) {
        Sentry.captureException(t, message, SentryEventLevel.ERROR);
    }

    public static void captureException(Throwable t, SentryEventLevel level) {
        Sentry.captureException(t, t.getMessage(), level);
    }

    public static void captureException(Throwable t, String message, SentryEventLevel level) {
        String culprit = Sentry.getCause(t, t.getMessage());
        Sentry.captureEvent(new SentryEventBuilder().setMessage(message).setCulprit(culprit).setLevel(level).setException(t));
    }

    private static String getCause(Throwable t, String culprit) {
        String packageName = Sentry.getInstance().appInfo.name;
        for (StackTraceElement stackTrace : t.getStackTrace()) {
            if (!stackTrace.toString().contains(packageName)) continue;
            return stackTrace.toString();
        }
        return culprit;
    }

    public static void captureEvent(SentryEventBuilder builder) {
        Sentry sentry = Sentry.getInstance();
        builder.event.put("contexts", sentry.contexts);
        Sentry.addDefaultRelease(builder, sentry.appInfo);
        builder.event.put("breadcrumbs", Sentry.getInstance().breadcrumbs.current());
        if (sentry.captureListener != null && (builder = sentry.captureListener.beforeCapture(builder)) == null) {
            Log.e((String)TAG, (String)"SentryEventBuilder in captureEvent is null");
            return;
        }
        SentryEventRequest request = new SentryEventRequest(builder);
        Sentry.log("Request - " + request.requestData);
        Sentry.doCaptureEventPost(request);
    }

    private boolean shouldAttemptPost() {
        PackageManager pm = this.context.getPackageManager();
        int hasPerm = pm.checkPermission("android.permission.ACCESS_NETWORK_STATE", this.context.getPackageName());
        if (hasPerm != 0) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    private static void ignoreSslErrors(HttpURLConnection connection) {
        try {
            if (!(connection instanceof HttpsURLConnection)) {
                return;
            }
            HttpsURLConnection https = (HttpsURLConnection)connection;
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
            https.setSSLSocketFactory(sslContext.getSocketFactory());
            https.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String host, SSLSession sess) {
                    return true;
                }
            });
        }
        catch (Exception ex) {
            Log.w((String)TAG, (String)"Error bypassing SSL validation", (Throwable)ex);
        }
    }

    private Runnable makePoster(final SentryEventRequest request) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    int projectId = Integer.parseInt(Sentry.getProjectId(Sentry.this.dsn));
                    URL url = new URL(Sentry.this.baseUrl + "/api/" + projectId + "/store/");
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    if (!Sentry.this.verifySsl) {
                        Sentry.ignoreSslErrors(conn);
                    }
                    int timeoutMillis = (int)TimeUnit.SECONDS.toMillis(10L);
                    conn.setConnectTimeout(timeoutMillis);
                    conn.setReadTimeout(timeoutMillis);
                    conn.setDoOutput(true);
                    conn.setDoInput(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("X-Sentry-Auth", Sentry.createXSentryAuthHeader(Sentry.this.dsn));
                    conn.setRequestProperty("User-Agent", "sentry-android/1.6.2");
                    conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                    OutputStream os = conn.getOutputStream();
                    os.write(request.requestData.getBytes("UTF-8"));
                    os.close();
                    int status = conn.getResponseCode();
                    boolean success = status == 200;
                    conn.disconnect();
                    Sentry.log("SendEvent status=" + status);
                    if (success) {
                        InternalStorage.getInstance().removeBuilder(request);
                    } else {
                        InternalStorage.getInstance().addRequest(request);
                    }
                }
                catch (Exception e) {
                    Log.e((String)Sentry.TAG, (String)"Error sending event", (Throwable)e);
                }
            }
        };
    }

    private static void doCaptureEventPost(SentryEventRequest request) {
        Sentry sentry = Sentry.getInstance();
        if (!sentry.shouldAttemptPost()) {
            InternalStorage.getInstance().addRequest(request);
            return;
        }
        sentry.executor.execute(sentry.makePoster(request));
    }

    public static void addNavigationBreadcrumb(String category, String from, String to) {
        Breadcrumb b = new Breadcrumb(System.currentTimeMillis() / 1000L, Breadcrumb.Type.Navigation, "", category, SentryEventLevel.INFO);
        b.data.put("from", from);
        b.data.put("to", to);
        Sentry.getInstance().breadcrumbs.push(b);
    }

    public static void addHttpBreadcrumb(String url, String method, int statusCode) {
        String reason = Sentry.httpReason(statusCode);
        Breadcrumb b = new Breadcrumb(System.currentTimeMillis() / 1000L, Breadcrumb.Type.HTTP, "", String.format("http.%s", method.toLowerCase()), SentryEventLevel.INFO);
        b.data.put("url", url);
        b.data.put("method", method);
        b.data.put("status_code", Integer.toString(statusCode));
        b.data.put("reason", reason);
        Sentry.getInstance().breadcrumbs.push(b);
    }

    public static void addBreadcrumb(String category, String message) {
        Sentry.getInstance().breadcrumbs.push(new Breadcrumb(System.currentTimeMillis() / 1000L, Breadcrumb.Type.Default, message, category, SentryEventLevel.INFO));
    }

    private static DateFormat iso8601() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    private static JSONObject readContexts(Context context, AppInfo appInfo) {
        JSONObject contexts = new JSONObject();
        try {
            contexts.put("os", (Object)Sentry.osContext());
            contexts.put("device", (Object)Sentry.deviceContext(context));
            contexts.put("package", (Object)Sentry.packageContext(appInfo));
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to build device contexts", (Throwable)e);
        }
        return contexts;
    }

    private static JSONObject deviceContext(Context context) {
        JSONObject device = new JSONObject();
        try {
            int orient;
            device.put("family", (Object)Build.BRAND);
            device.put("model", (Object)Build.PRODUCT);
            device.put("model_id", (Object)Build.MODEL);
            String architecture = System.getProperty("os.arch");
            if (Sentry.Present(architecture)) {
                device.put("arch", (Object)architecture);
            }
            device.put("orientation", (Object)((orient = context.getResources().getConfiguration().orientation) == 2 ? "landscape" : "portrait"));
            Object windowManager = context.getSystemService("window");
            if (windowManager != null && windowManager instanceof WindowManager) {
                DisplayMetrics metrics = new DisplayMetrics();
                ((WindowManager)windowManager).getDefaultDisplay().getMetrics(metrics);
                device.put("screen_resolution", (Object)String.format("%sx%s", Math.max(metrics.widthPixels, metrics.heightPixels), Math.min(metrics.widthPixels, metrics.heightPixels)));
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error reading device context", (Throwable)e);
        }
        return device;
    }

    private static JSONObject osContext() {
        JSONObject os = new JSONObject();
        try {
            os.put("type", (Object)"os");
            os.put("name", (Object)"Android");
            os.put("version", (Object)Build.VERSION.RELEASE);
            if (Build.VERSION.SDK_INT < 4) {
                os.put("build", (Object)Build.VERSION.SDK);
            } else {
                os.put("build", (Object)Integer.toString(Build.VERSION.SDK_INT));
            }
            String kernelVersion = System.getProperty("os.version");
            if (Sentry.Present(kernelVersion)) {
                os.put("kernel_version", (Object)kernelVersion);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error reading OS context", (Throwable)e);
        }
        return os;
    }

    private static JSONObject packageContext(AppInfo appInfo) {
        JSONObject pack = new JSONObject();
        try {
            pack.put("type", (Object)"package");
            pack.put("name", (Object)appInfo.name);
            pack.put("version_name", (Object)appInfo.versionName);
            pack.put("version_code", (Object)Integer.toString(appInfo.versionCode));
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error reading package context", (Throwable)e);
        }
        return pack;
    }

    private static String httpReason(int statusCode) {
        switch (statusCode) {
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Temporary Redirect";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Time-Out";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Large";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "Version Not Supported";
            }
        }
        return "unknown";
    }

    private static boolean Present(String s) {
        return s != null && s.length() > 0;
    }

    static void addDefaultRelease(SentryEventBuilder event, AppInfo appInfo) {
        if (event.event.containsKey("release")) {
            return;
        }
        event.setRelease(appInfo.versionName);
    }

    static /* synthetic */ DateFormat access$1800() {
        return Sentry.iso8601();
    }

    static final class AppInfo {
        static final AppInfo Empty = new AppInfo("", "", 0);
        final String name;
        final String versionName;
        final int versionCode;

        AppInfo(String name, String versionName, int versionCode) {
            this.name = name;
            this.versionName = versionName;
            this.versionCode = versionCode;
        }

        static AppInfo Read(Context context) {
            try {
                PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                return new AppInfo(info.packageName, info.versionName, info.versionCode);
            }
            catch (Exception e) {
                Log.e((String)Sentry.TAG, (String)"Error reading package context", (Throwable)e);
                return Empty;
            }
        }
    }

    public static class SentryEventBuilder
    implements Serializable {
        private static final long serialVersionUID = -8589756678369463988L;
        static final String isInternalPackage = "^(java|android|com\\.android|com\\.google\\.android|dalvik\\.system)\\..*";
        private static final DateFormat timestampFormat = Sentry.access$1800();
        final Map<String, Object> event = new HashMap<String, Object>();

        public JSONObject toJSON() {
            return new JSONObject(this.event);
        }

        public SentryEventBuilder() {
            this.event.put("event_id", UUID.randomUUID().toString().replace("-", ""));
            this.event.put("platform", "java");
            this.setTimestamp(System.currentTimeMillis());
        }

        public SentryEventBuilder(Throwable t, SentryEventLevel level) {
            this();
            String culprit = Sentry.getCause(t, t.getMessage());
            this.setMessage(t.getMessage()).setCulprit(culprit).setLevel(level).setException(t);
        }

        public SentryEventBuilder setMessage(String message) {
            this.event.put("message", message);
            return this;
        }

        public SentryEventBuilder setTimestamp(long timestamp) {
            this.event.put("timestamp", timestampFormat.format(new Date(timestamp)));
            return this;
        }

        public SentryEventBuilder setLevel(SentryEventLevel level) {
            this.event.put("level", level.value);
            return this;
        }

        public SentryEventBuilder setLogger(String logger) {
            this.event.put("logger", logger);
            return this;
        }

        public SentryEventBuilder setEnvironment(String env) {
            this.event.put("environment", env);
            return this;
        }

        public SentryEventBuilder setCulprit(String culprit) {
            this.event.put("culprit", culprit);
            return this;
        }

        public SentryEventBuilder setUser(Map<String, String> user) {
            this.setUser(new JSONObject(user));
            return this;
        }

        public SentryEventBuilder setUser(JSONObject user) {
            this.event.put("user", user);
            return this;
        }

        public JSONObject getUser() {
            if (!this.event.containsKey("user")) {
                this.setTags(new HashMap<String, String>());
            }
            return (JSONObject)this.event.get("user");
        }

        public SentryEventBuilder setTags(Map<String, String> tags) {
            this.setTags(new JSONObject(tags));
            return this;
        }

        public SentryEventBuilder setTags(JSONObject tags) {
            this.event.put("tags", tags);
            return this;
        }

        public SentryEventBuilder addTag(String key, String value) {
            try {
                this.getTags().put(key, (Object)value);
            }
            catch (JSONException e) {
                Log.e((String)Sentry.TAG, (String)"Error adding tag in SentryEventBuilder");
            }
            return this;
        }

        public JSONObject getTags() {
            if (!this.event.containsKey("tags")) {
                this.setTags(new HashMap<String, String>());
            }
            return (JSONObject)this.event.get("tags");
        }

        public SentryEventBuilder setServerName(String serverName) {
            this.event.put("server_name", serverName);
            return this;
        }

        public SentryEventBuilder setRelease(String release) {
            this.event.put("release", release);
            return this;
        }

        public SentryEventBuilder addModule(String name, String version) {
            JSONArray modules;
            if (!this.event.containsKey("modules")) {
                modules = new JSONArray();
                this.event.put("modules", modules);
            } else {
                modules = (JSONArray)this.event.get("modules");
            }
            if (name != null && version != null) {
                String[] module = new String[]{name, version};
                modules.put((Object)new JSONArray(Arrays.asList(module)));
            }
            return this;
        }

        public SentryEventBuilder setExtra(Map<String, String> extra) {
            this.setExtra(new JSONObject(extra));
            return this;
        }

        public SentryEventBuilder setExtra(JSONObject extra) {
            this.event.put("extra", extra);
            return this;
        }

        public SentryEventBuilder addExtra(String key, String value) {
            try {
                this.getExtra().put(key, (Object)value);
            }
            catch (JSONException e) {
                Log.e((String)Sentry.TAG, (String)"Error adding extra in SentryEventBuilder");
            }
            return this;
        }

        public JSONObject getExtra() {
            if (!this.event.containsKey("extra")) {
                this.setExtra(new HashMap<String, String>());
            }
            return (JSONObject)this.event.get("extra");
        }

        public SentryEventBuilder setException(Throwable t) {
            JSONArray values = new JSONArray();
            while (t != null) {
                JSONObject exception = new JSONObject();
                try {
                    exception.put("type", (Object)t.getClass().getSimpleName());
                    exception.put("value", (Object)t.getMessage());
                    exception.put("module", (Object)t.getClass().getPackage().getName());
                    exception.put("stacktrace", (Object)SentryEventBuilder.getStackTrace(t.getStackTrace()));
                    values.put((Object)exception);
                }
                catch (JSONException e) {
                    Log.e((String)Sentry.TAG, (String)("Failed to build sentry report for " + t), (Throwable)e);
                }
                t = t.getCause();
            }
            JSONObject exceptionReport = new JSONObject();
            try {
                exceptionReport.put("values", (Object)values);
                this.event.put("exception", exceptionReport);
            }
            catch (JSONException e) {
                Log.e((String)Sentry.TAG, (String)("Unable to attach exception to event " + values), (Throwable)e);
            }
            return this;
        }

        private static JSONObject getStackTrace(StackTraceElement[] stackFrames) {
            JSONObject stacktrace = new JSONObject();
            try {
                JSONArray frameList = new JSONArray();
                for (int i = stackFrames.length - 1; i >= 0; --i) {
                    frameList.put((Object)SentryEventBuilder.frameJson(stackFrames[i]));
                }
                stacktrace.put("frames", (Object)frameList);
            }
            catch (JSONException e) {
                Log.e((String)Sentry.TAG, (String)"Error serializing stack frames", (Throwable)e);
            }
            return stacktrace;
        }

        public SentryEventBuilder setStackTrace(StackTraceElement[] stackTrace) {
            this.event.put("stacktrace", SentryEventBuilder.getStackTrace(stackTrace));
            return this;
        }

        static JSONObject frameJson(StackTraceElement ste) throws JSONException {
            String fileName;
            JSONObject frame = new JSONObject();
            String method = ste.getMethodName();
            if (Sentry.Present(method)) {
                frame.put("function", (Object)method);
            }
            if (Sentry.Present(fileName = ste.getFileName())) {
                frame.put("filename", (Object)fileName);
            }
            int lineno = ste.getLineNumber();
            if (!ste.isNativeMethod() && lineno >= 0) {
                frame.put("lineno", lineno);
            }
            String className = ste.getClassName();
            frame.put("module", (Object)className);
            frame.put("in_app", !className.matches(isInternalPackage));
            return frame;
        }
    }

    private static class SentryEventRequest
    implements Serializable {
        final String requestData;
        final UUID uuid;

        SentryEventRequest(SentryEventBuilder builder) {
            this.requestData = new JSONObject(builder.event).toString();
            this.uuid = UUID.randomUUID();
        }

        public boolean equals(Object other) {
            boolean sameClass = other instanceof SentryEventRequest;
            return sameClass && this.uuid == ((SentryEventRequest)other).uuid;
        }
    }

    static class Breadcrumbs {
        final AtomicInteger maxBreadcrumbs = new AtomicInteger(100);
        final LinkedList<Breadcrumb> breadcrumbs = new LinkedList();
        final ReadWriteLock lock = new ReentrantReadWriteLock();

        Breadcrumbs() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void push(Breadcrumb b) {
            try {
                this.lock.writeLock().lock();
                int toRemove = this.breadcrumbs.size() - this.maxBreadcrumbs.get() + 1;
                for (int i = 0; i < toRemove; ++i) {
                    this.breadcrumbs.removeFirst();
                }
                this.breadcrumbs.add(b);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JSONArray current() {
            JSONArray crumbs = new JSONArray();
            try {
                this.lock.readLock().lock();
                for (Breadcrumb breadcrumb : this.breadcrumbs) {
                    JSONObject json = new JSONObject();
                    json.put("timestamp", breadcrumb.timestamp);
                    json.put("type", (Object)breadcrumb.type.value);
                    json.put("message", (Object)breadcrumb.message);
                    json.put("category", (Object)breadcrumb.category);
                    json.put("level", (Object)breadcrumb.level.value);
                    json.put("data", (Object)new JSONObject(breadcrumb.data));
                    crumbs.put((Object)json);
                }
            }
            catch (Exception e) {
                Log.e((String)Sentry.TAG, (String)"Error serializing breadcrumbs", (Throwable)e);
            }
            finally {
                this.lock.readLock().unlock();
            }
            return crumbs;
        }

        void setMaxBreadcrumbs(int maxBreadcrumbs) {
            maxBreadcrumbs = Math.min(200, Math.max(0, maxBreadcrumbs));
            this.maxBreadcrumbs.set(maxBreadcrumbs);
        }
    }

    private static final class Breadcrumb {
        final long timestamp;
        final Type type;
        final String message;
        final String category;
        final SentryEventLevel level;
        final Map<String, String> data = new HashMap<String, String>();

        Breadcrumb(long timestamp, Type type, String message, String category, SentryEventLevel level) {
            this.timestamp = timestamp;
            this.type = type;
            this.message = message;
            this.category = category;
            this.level = level;
        }

        static enum Type {
            Default("default"),
            HTTP("http"),
            Navigation("navigation");

            private final String value;

            private Type(String value) {
                this.value = value;
            }
        }
    }

    public static interface SentryEventCaptureListener {
        public SentryEventBuilder beforeCapture(SentryEventBuilder var1);
    }

    private static class InternalStorage {
        private static final String FILE_NAME = "unsent_requests";
        private final List<SentryEventRequest> unsentRequests;

        private static InternalStorage getInstance() {
            return LazyHolder.instance;
        }

        private InternalStorage() {
            Context context = Sentry.getInstance().context;
            try {
                File unsetRequestsFile = new File(context.getFilesDir(), FILE_NAME);
                if (!unsetRequestsFile.exists()) {
                    this.writeObject(context, new ArrayList<SentryEventRequest>());
                }
            }
            catch (Exception e) {
                Log.e((String)Sentry.TAG, (String)"Error initializing storage", (Throwable)e);
            }
            this.unsentRequests = this.readObject(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SentryEventRequest> getUnsentRequests() {
            ArrayList<SentryEventRequest> copy = new ArrayList<SentryEventRequest>();
            InternalStorage internalStorage = this;
            synchronized (internalStorage) {
                copy.addAll(this.unsentRequests);
            }
            return copy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRequest(SentryEventRequest request) {
            InternalStorage internalStorage = this;
            synchronized (internalStorage) {
                Sentry.log("Adding request - " + request.uuid);
                if (!this.unsentRequests.contains(request)) {
                    this.unsentRequests.add(request);
                    this.writeObject(Sentry.getInstance().context, this.unsentRequests);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeBuilder(SentryEventRequest request) {
            InternalStorage internalStorage = this;
            synchronized (internalStorage) {
                Sentry.log("Removing request - " + request.uuid);
                this.unsentRequests.remove(request);
                this.writeObject(Sentry.getInstance().context, this.unsentRequests);
            }
        }

        private void writeObject(Context context, List<SentryEventRequest> requests) {
            try {
                FileOutputStream fos = context.openFileOutput(FILE_NAME, 0);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(requests);
                oos.close();
                fos.close();
            }
            catch (IOException e) {
                Log.e((String)Sentry.TAG, (String)"Error saving to storage", (Throwable)e);
            }
        }

        private List<SentryEventRequest> readObject(Context context) {
            try {
                FileInputStream fis = context.openFileInput(FILE_NAME);
                ObjectInputStream ois = new ObjectInputStream(fis);
                ArrayList requests = (ArrayList)ois.readObject();
                ois.close();
                fis.close();
                return requests;
            }
            catch (IOException | ClassNotFoundException e) {
                Log.e((String)Sentry.TAG, (String)"Error loading from storage", (Throwable)e);
                return new ArrayList<SentryEventRequest>();
            }
        }

        private static class LazyHolder {
            private static final InternalStorage instance = new InternalStorage();

            private LazyHolder() {
            }
        }
    }

    private static class SentryUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final InternalStorage storage;
        private final Thread.UncaughtExceptionHandler defaultExceptionHandler;

        public SentryUncaughtExceptionHandler(Thread.UncaughtExceptionHandler pDefaultExceptionHandler, InternalStorage storage) {
            this.defaultExceptionHandler = pDefaultExceptionHandler;
            this.storage = storage;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable e) {
            Sentry sentry = Sentry.getInstance();
            SentryEventBuilder builder = new SentryEventBuilder(e, SentryEventLevel.FATAL);
            Sentry.addDefaultRelease(builder, sentry.appInfo);
            builder.event.put("breadcrumbs", sentry.breadcrumbs.current());
            if (sentry.captureListener != null) {
                builder = sentry.captureListener.beforeCapture(builder);
            }
            if (builder != null) {
                builder.event.put("contexts", sentry.contexts);
                this.storage.addRequest(new SentryEventRequest(builder));
            } else {
                Log.e((String)Sentry.TAG, (String)"SentryEventBuilder in uncaughtException is null");
            }
            this.defaultExceptionHandler.uncaughtException(thread, e);
        }
    }

    static class LazyHolder {
        static final Sentry instance = new Sentry();

        LazyHolder() {
        }
    }

    public static enum SentryEventLevel {
        FATAL("fatal"),
        ERROR("error"),
        WARNING("warning"),
        INFO("info"),
        DEBUG("debug");

        private final String value;

        private SentryEventLevel(String value) {
            this.value = value;
        }
    }
}

