/*
 * Decompiled with CFR 0.152.
 */
package com.joshdholtz.sentry;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Sentry {
    private static final String TAG = "Sentry";
    private static final String sentryVersion = "7";
    private static final int MAX_QUEUE_LENGTH = 50;
    private static final int MAX_BREADCRUMBS = 10;
    public static boolean debug = false;
    private Context context;
    private String baseUrl;
    private String dsn;
    private AppInfo appInfo = AppInfo.Empty;
    private int verifySsl;
    private SentryEventCaptureListener captureListener;
    private JSONObject contexts = new JSONObject();
    private Executor executor;
    private LinkedList<Breadcrumb> breadcrumbs = new LinkedList();

    private Sentry() {
    }

    private static void log(String text) {
        if (debug) {
            Log.d((String)TAG, (String)text);
        }
    }

    private static Sentry getInstance() {
        return LazyHolder.instance;
    }

    public static void init(Context context, String dsn) {
        Sentry.init(context, dsn, true);
    }

    public static void init(Context context, String dsn, boolean setupUncaughtExceptionHandler) {
        Sentry sentry = Sentry.getInstance();
        sentry.context = context.getApplicationContext();
        Uri uri = Uri.parse((String)dsn);
        String port = "";
        if (uri.getPort() >= 0) {
            port = ":" + uri.getPort();
        }
        sentry.baseUrl = uri.getScheme() + "://" + uri.getHost() + port;
        sentry.dsn = dsn;
        sentry.appInfo = AppInfo.Read(sentry.context);
        sentry.verifySsl = Sentry.getVerifySsl(dsn);
        sentry.contexts = Sentry.readContexts(sentry.context, sentry.appInfo);
        sentry.executor = Sentry.fixedQueueDiscardingExecutor(50);
        if (setupUncaughtExceptionHandler) {
            sentry.setupUncaughtExceptionHandler();
        }
    }

    private static Executor fixedQueueDiscardingExecutor(int queueSize) {
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicLong count = new AtomicLong();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(String.format(Locale.US, "Sentry HTTP Thread %d", this.count.incrementAndGet()));
                return thread;
            }
        };
        return new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize), threadFactory, new ThreadPoolExecutor.DiscardPolicy());
    }

    private static int getVerifySsl(String dsn) {
        int verifySsl = 1;
        List<NameValuePair> params = Sentry.getAllGetParams(dsn);
        for (NameValuePair param : params) {
            if (!param.getName().equals("verify_ssl")) continue;
            return Integer.parseInt(param.getValue());
        }
        return verifySsl;
    }

    private static List<NameValuePair> getAllGetParams(String dsn) {
        List params = null;
        try {
            params = URLEncodedUtils.parse((URI)new URI(dsn), (String)"UTF-8");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return params;
    }

    private void setupUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler != null) {
            Sentry.log("current handler class=" + currentHandler.getClass().getName());
        }
        if (!(currentHandler instanceof SentryUncaughtExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new SentryUncaughtExceptionHandler(currentHandler));
        }
        Sentry.sendAllCachedCapturedEvents();
    }

    private static String createXSentryAuthHeader(String dsn) {
        StringBuilder header = new StringBuilder();
        Uri uri = Uri.parse((String)dsn);
        String authority = uri.getAuthority().replace("@" + uri.getHost(), "");
        String[] authorityParts = authority.split(":");
        String publicKey = authorityParts[0];
        String secretKey = authorityParts[1];
        header.append("Sentry ").append(String.format("sentry_version=%s,", sentryVersion)).append(String.format("sentry_client=sentry-android/%s,", "1.5.1")).append(String.format("sentry_key=%s,", publicKey)).append(String.format("sentry_secret=%s", secretKey));
        return header.toString();
    }

    private String getProjectId() {
        Uri uri = Uri.parse((String)this.dsn);
        String path = uri.getPath();
        String projectId = path.substring(path.lastIndexOf("/") + 1);
        return projectId;
    }

    public static void sendAllCachedCapturedEvents() {
        List<SentryEventRequest> unsentRequests = InternalStorage.getInstance().getUnsentRequests();
        Sentry.log("Sending up " + unsentRequests.size() + " cached response(s)");
        for (SentryEventRequest request : unsentRequests) {
            Sentry.doCaptureEventPost(request);
        }
    }

    public static void setCaptureListener(SentryEventCaptureListener captureListener) {
        Sentry.getInstance().captureListener = captureListener;
    }

    public static void captureMessage(String message) {
        Sentry.captureMessage(message, SentryEventLevel.INFO);
    }

    public static void captureMessage(String message, SentryEventLevel level) {
        Sentry.captureEvent(new SentryEventBuilder().setMessage(message).setLevel(level));
    }

    public static void captureException(Throwable t) {
        Sentry.captureException(t, t.getMessage(), SentryEventLevel.ERROR);
    }

    public static void captureException(Throwable t, String message) {
        Sentry.captureException(t, message, SentryEventLevel.ERROR);
    }

    public static void captureException(Throwable t, SentryEventLevel level) {
        Sentry.captureException(t, t.getMessage(), level);
    }

    public static void captureException(Throwable t, String message, SentryEventLevel level) {
        String culprit = Sentry.getCause(t, t.getMessage());
        Sentry.captureEvent(new SentryEventBuilder().setMessage(message).setCulprit(culprit).setLevel(level).setException(t));
    }

    private static String getCause(Throwable t, String culprit) {
        String packageName = Sentry.getInstance().appInfo.name;
        for (StackTraceElement stackTrace : t.getStackTrace()) {
            if (!stackTrace.toString().contains(packageName)) continue;
            return stackTrace.toString();
        }
        return culprit;
    }

    public static void captureEvent(SentryEventBuilder builder) {
        SentryEventRequest request;
        Sentry sentry = Sentry.getInstance();
        builder.event.put("contexts", sentry.contexts);
        builder.setRelease(Integer.toString(sentry.appInfo.versionCode));
        builder.event.put("breadcrumbs", Sentry.getInstance().currentBreadcrumbs());
        if (sentry.captureListener != null) {
            if ((builder = sentry.captureListener.beforeCapture(builder)) == null) {
                Log.e((String)TAG, (String)"SentryEventBuilder in captureEvent is null");
                return;
            }
            request = new SentryEventRequest(builder);
        } else {
            request = new SentryEventRequest(builder);
        }
        Sentry.log("Request - " + request.getRequestData());
        Sentry.doCaptureEventPost(request);
    }

    private boolean shouldAttemptPost() {
        PackageManager pm = this.context.getPackageManager();
        int hasPerm = pm.checkPermission("android.permission.ACCESS_NETWORK_STATE", this.context.getPackageName());
        if (hasPerm != 0) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    private static HttpClient getHttpsClient(HttpClient client) {
        try {
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
            ExSSLSocketFactory sslSocketFactory = new ExSSLSocketFactory(sslContext);
            sslSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager clientConnectionManager = client.getConnectionManager();
            SchemeRegistry schemeRegistry = clientConnectionManager.getSchemeRegistry();
            schemeRegistry.register(new Scheme("https", (SocketFactory)sslSocketFactory, 443));
            return new DefaultHttpClient(clientConnectionManager, client.getParams());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void doCaptureEventPost(final SentryEventRequest request) {
        final Sentry sentry = Sentry.getInstance();
        if (!sentry.shouldAttemptPost()) {
            InternalStorage.getInstance().addRequest(request);
            return;
        }
        sentry.executor.execute(new Runnable(){

            @Override
            public void run() {
                DefaultHttpClient httpClient;
                int projectId = Integer.parseInt(sentry.getProjectId());
                String url = sentry.baseUrl + "/api/" + projectId + "/store/";
                Sentry.log("Sending to URL - " + url);
                if (Sentry.getInstance().verifySsl != 0) {
                    Sentry.log("Using http client");
                    httpClient = new DefaultHttpClient();
                } else {
                    Sentry.log("Using https client");
                    httpClient = Sentry.getHttpsClient((HttpClient)new DefaultHttpClient());
                }
                HttpPost httpPost = new HttpPost(url);
                int TIMEOUT_MILLISEC = 10000;
                HttpParams httpParams = httpPost.getParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)TIMEOUT_MILLISEC);
                HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)TIMEOUT_MILLISEC);
                HttpProtocolParams.setContentCharset((HttpParams)httpParams, (String)"UTF-8");
                HttpProtocolParams.setHttpElementCharset((HttpParams)httpParams, (String)"UTF-8");
                boolean success = false;
                try {
                    httpPost.setHeader("X-Sentry-Auth", Sentry.createXSentryAuthHeader(sentry.dsn));
                    httpPost.setHeader("User-Agent", "sentry-android/1.5.1");
                    httpPost.setHeader("Content-Type", "application/json; charset=utf-8");
                    httpPost.setEntity((HttpEntity)new StringEntity(request.getRequestData(), "UTF-8"));
                    HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                    int status = httpResponse.getStatusLine().getStatusCode();
                    byte[] byteResp = null;
                    if (httpResponse.getEntity() != null) {
                        try {
                            InputStream in = httpResponse.getEntity().getContent();
                            byteResp = this.readBytes(in);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    String stringResponse = null;
                    Charset charsetInput = Charset.forName("UTF-8");
                    CharsetDecoder decoder = charsetInput.newDecoder();
                    CharBuffer cbuf = null;
                    try {
                        cbuf = decoder.decode(ByteBuffer.wrap(byteResp));
                        stringResponse = cbuf.toString();
                    }
                    catch (CharacterCodingException e) {
                        e.printStackTrace();
                    }
                    success = status == 200;
                    Sentry.log("SendEvent - " + status + " " + stringResponse);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (success) {
                    InternalStorage.getInstance().removeBuilder(request);
                } else {
                    InternalStorage.getInstance().addRequest(request);
                }
            }

            private byte[] readBytes(InputStream inputStream) throws IOException {
                ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
                int bufferSize = 1024;
                byte[] buffer = new byte[bufferSize];
                int len = 0;
                while ((len = inputStream.read(buffer)) != -1) {
                    byteBuffer.write(buffer, 0, len);
                }
                return byteBuffer.toByteArray();
            }
        });
    }

    private void pushBreadcrumb(Breadcrumb b) {
        while (this.breadcrumbs.size() >= 10) {
            this.breadcrumbs.removeFirst();
        }
        this.breadcrumbs.add(b);
    }

    public static void addNavigationBreadcrumb(String category, String from, String to) {
        Breadcrumb b = new Breadcrumb(System.currentTimeMillis() / 1000L, Breadcrumb.Type.Navigation, "", category, SentryEventLevel.INFO);
        b.data.put("from", from);
        b.data.put("to", to);
        Sentry.getInstance().pushBreadcrumb(b);
    }

    public static void addHttpBreadcrumb(String url, String method, int statusCode) {
        String reason = EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, Locale.US);
        Breadcrumb b = new Breadcrumb(System.currentTimeMillis() / 1000L, Breadcrumb.Type.HTTP, "", String.format("http.%s", method.toLowerCase()), SentryEventLevel.INFO);
        b.data.put("url", url);
        b.data.put("method", method);
        b.data.put("status_code", Integer.toString(statusCode));
        b.data.put("reason", reason);
        Sentry.getInstance().pushBreadcrumb(b);
    }

    public static void addBreadcrumb(String category, String message) {
        Sentry.getInstance().pushBreadcrumb(new Breadcrumb(System.currentTimeMillis() / 1000L, Breadcrumb.Type.Default, message, category, SentryEventLevel.INFO));
    }

    private JSONArray currentBreadcrumbs() {
        JSONArray crumbs = new JSONArray();
        for (Breadcrumb breadcrumb : this.breadcrumbs) {
            JSONObject json = new JSONObject();
            try {
                json.put("timestamp", breadcrumb.timestamp);
                json.put("type", (Object)breadcrumb.type.value);
                json.put("message", (Object)breadcrumb.message);
                json.put("category", (Object)breadcrumb.category);
                json.put("level", (Object)breadcrumb.level.value);
                json.put("data", (Object)new JSONObject(breadcrumb.data));
            }
            catch (JSONException jse) {
                Log.e((String)TAG, (String)"Error serializing breadcrumbs", (Throwable)jse);
            }
            crumbs.put((Object)json);
        }
        return crumbs;
    }

    private static JSONObject readContexts(Context context, AppInfo appInfo) {
        JSONObject contexts = new JSONObject();
        try {
            contexts.put("os", (Object)Sentry.osContext());
            contexts.put("device", (Object)Sentry.deviceContext(context));
            contexts.put("package", (Object)Sentry.packageContext(appInfo));
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to build device contexts", (Throwable)e);
        }
        return contexts;
    }

    private static JSONObject deviceContext(Context context) {
        JSONObject device = new JSONObject();
        try {
            int orient;
            device.put("family", (Object)Build.BRAND);
            device.put("model", (Object)Build.PRODUCT);
            device.put("model_id", (Object)Build.MODEL);
            String architecture = System.getProperty("os.arch");
            if (Sentry.Present(architecture)) {
                device.put("arch", (Object)architecture);
            }
            device.put("orientation", (Object)((orient = context.getResources().getConfiguration().orientation) == 2 ? "landscape" : "portrait"));
            Object windowManager = context.getSystemService("window");
            if (windowManager != null && windowManager instanceof WindowManager) {
                DisplayMetrics metrics = new DisplayMetrics();
                ((WindowManager)windowManager).getDefaultDisplay().getMetrics(metrics);
                device.put("screen_resolution", (Object)String.format("%sx%s", Math.max(metrics.widthPixels, metrics.heightPixels), Math.min(metrics.widthPixels, metrics.heightPixels)));
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error reading device context", (Throwable)e);
        }
        return device;
    }

    private static JSONObject osContext() {
        JSONObject os = new JSONObject();
        try {
            os.put("type", (Object)"os");
            os.put("name", (Object)"Android");
            os.put("version", (Object)Build.VERSION.RELEASE);
            if (Build.VERSION.SDK_INT < 4) {
                os.put("build", (Object)Build.VERSION.SDK);
            } else {
                os.put("build", (Object)Integer.toString(Build.VERSION.SDK_INT));
            }
            String kernelVersion = System.getProperty("os.version");
            if (Sentry.Present(kernelVersion)) {
                os.put("kernel_version", (Object)kernelVersion);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error reading OS context", (Throwable)e);
        }
        return os;
    }

    private static JSONObject packageContext(AppInfo appInfo) {
        JSONObject pack = new JSONObject();
        try {
            pack.put("type", (Object)"package");
            pack.put("name", (Object)appInfo.name);
            pack.put("version_name", (Object)appInfo.versionName);
            pack.put("version_code", (Object)Integer.toString(appInfo.versionCode));
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error reading package context", (Throwable)e);
        }
        return pack;
    }

    private static boolean Present(String s) {
        return s != null && s.length() > 0;
    }

    private static final class AppInfo {
        static final AppInfo Empty = new AppInfo("", "", 0);
        final String name;
        final String versionName;
        final int versionCode;

        AppInfo(String name, String versionName, int versionCode) {
            this.name = name;
            this.versionName = versionName;
            this.versionCode = versionCode;
        }

        static AppInfo Read(Context context) {
            try {
                PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                return new AppInfo(info.packageName, info.versionName, info.versionCode);
            }
            catch (Exception e) {
                Log.e((String)Sentry.TAG, (String)"Error reading package context", (Throwable)e);
                return Empty;
            }
        }
    }

    public static class SentryEventBuilder
    implements Serializable {
        private static final long serialVersionUID = -8589756678369463988L;
        static final String isInternalPackage = "^(java|android|com\\.android|com\\.google\\.android|dalvik\\.system)\\..*";
        private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        private final Map<String, Object> event = new HashMap<String, Object>();

        public JSONObject toJSON() {
            return new JSONObject(this.event);
        }

        public SentryEventBuilder() {
            this.event.put("event_id", UUID.randomUUID().toString().replace("-", ""));
            this.event.put("platform", "java");
            this.setTimestamp(System.currentTimeMillis());
        }

        public SentryEventBuilder(Throwable t, SentryEventLevel level) {
            this();
            String culprit = Sentry.getCause(t, t.getMessage());
            this.setMessage(t.getMessage()).setCulprit(culprit).setLevel(level).setException(t);
        }

        public SentryEventBuilder setMessage(String message) {
            this.event.put("message", message);
            return this;
        }

        public SentryEventBuilder setTimestamp(long timestamp) {
            this.event.put("timestamp", sdf.format(new Date(timestamp)));
            return this;
        }

        public SentryEventBuilder setLevel(SentryEventLevel level) {
            this.event.put("level", level.value);
            return this;
        }

        public SentryEventBuilder setLogger(String logger) {
            this.event.put("logger", logger);
            return this;
        }

        public SentryEventBuilder setCulprit(String culprit) {
            this.event.put("culprit", culprit);
            return this;
        }

        public SentryEventBuilder setUser(Map<String, String> user) {
            this.setUser(new JSONObject(user));
            return this;
        }

        public SentryEventBuilder setUser(JSONObject user) {
            this.event.put("user", user);
            return this;
        }

        public JSONObject getUser() {
            if (!this.event.containsKey("user")) {
                this.setTags(new HashMap<String, String>());
            }
            return (JSONObject)this.event.get("user");
        }

        public SentryEventBuilder setTags(Map<String, String> tags) {
            this.setTags(new JSONObject(tags));
            return this;
        }

        public SentryEventBuilder setTags(JSONObject tags) {
            this.event.put("tags", tags);
            return this;
        }

        public SentryEventBuilder addTag(String key, String value) {
            try {
                this.getTags().put(key, (Object)value);
            }
            catch (JSONException e) {
                Log.e((String)Sentry.TAG, (String)"Error adding tag in SentryEventBuilder");
            }
            return this;
        }

        public JSONObject getTags() {
            if (!this.event.containsKey("tags")) {
                this.setTags(new HashMap<String, String>());
            }
            return (JSONObject)this.event.get("tags");
        }

        public SentryEventBuilder setServerName(String serverName) {
            this.event.put("server_name", serverName);
            return this;
        }

        public SentryEventBuilder setRelease(String release) {
            this.event.put("release", release);
            return this;
        }

        public SentryEventBuilder addModule(String name, String version) {
            JSONArray modules;
            if (!this.event.containsKey("modules")) {
                modules = new JSONArray();
                this.event.put("modules", modules);
            } else {
                modules = (JSONArray)this.event.get("modules");
            }
            if (name != null && version != null) {
                String[] module = new String[]{name, version};
                modules.put((Object)new JSONArray(Arrays.asList(module)));
            }
            return this;
        }

        public SentryEventBuilder setExtra(Map<String, String> extra) {
            this.setExtra(new JSONObject(extra));
            return this;
        }

        public SentryEventBuilder setExtra(JSONObject extra) {
            this.event.put("extra", extra);
            return this;
        }

        public SentryEventBuilder addExtra(String key, String value) {
            try {
                this.getExtra().put(key, (Object)value);
            }
            catch (JSONException e) {
                Log.e((String)Sentry.TAG, (String)"Error adding extra in SentryEventBuilder");
            }
            return this;
        }

        public JSONObject getExtra() {
            if (!this.event.containsKey("extra")) {
                this.setExtra(new HashMap<String, String>());
            }
            return (JSONObject)this.event.get("extra");
        }

        public SentryEventBuilder setException(Throwable t) {
            JSONArray values = new JSONArray();
            while (t != null) {
                JSONObject exception = new JSONObject();
                try {
                    exception.put("type", (Object)t.getClass().getSimpleName());
                    exception.put("value", (Object)t.getMessage());
                    exception.put("module", (Object)t.getClass().getPackage().getName());
                    exception.put("stacktrace", (Object)SentryEventBuilder.getStackTrace(t.getStackTrace()));
                    values.put((Object)exception);
                }
                catch (JSONException e) {
                    Log.e((String)Sentry.TAG, (String)("Failed to build sentry report for " + t), (Throwable)e);
                }
                t = t.getCause();
            }
            JSONObject exceptionReport = new JSONObject();
            try {
                exceptionReport.put("values", (Object)values);
                this.event.put("exception", exceptionReport);
            }
            catch (JSONException e) {
                Log.e((String)Sentry.TAG, (String)("Unable to attach exception to event " + values), (Throwable)e);
            }
            return this;
        }

        private static JSONObject getStackTrace(StackTraceElement[] stackFrames) {
            JSONObject stacktrace = new JSONObject();
            try {
                JSONArray frameList = new JSONArray();
                for (StackTraceElement frame : stackFrames) {
                    frameList.put((Object)SentryEventBuilder.frameJson(frame));
                }
                stacktrace.put("frames", (Object)frameList);
            }
            catch (JSONException e) {
                Log.e((String)Sentry.TAG, (String)"Error serializing stack frames", (Throwable)e);
            }
            return stacktrace;
        }

        public SentryEventBuilder setStackTrace(StackTraceElement[] stackTrace) {
            this.event.put("stacktrace", SentryEventBuilder.getStackTrace(stackTrace));
            return this;
        }

        static JSONObject frameJson(StackTraceElement ste) throws JSONException {
            String fileName;
            JSONObject frame = new JSONObject();
            String method = ste.getMethodName();
            if (Sentry.Present(method)) {
                frame.put("function", (Object)method);
            }
            if (Sentry.Present(fileName = ste.getFileName())) {
                frame.put("filename", (Object)fileName);
            }
            int lineno = ste.getLineNumber();
            if (!ste.isNativeMethod() && lineno >= 0) {
                frame.put("lineno", lineno);
            }
            String className = ste.getClassName();
            frame.put("module", (Object)className);
            frame.put("in_app", !className.matches(isInternalPackage));
            return frame;
        }

        static {
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    public static class SentryEventRequest
    implements Serializable {
        private final String requestData;
        private final UUID uuid;

        public SentryEventRequest(SentryEventBuilder builder) {
            this.requestData = new JSONObject(builder.event).toString();
            this.uuid = UUID.randomUUID();
        }

        public String getRequestData() {
            return this.requestData;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public boolean equals(Object other) {
            SentryEventRequest otherRequest = (SentryEventRequest)other;
            if (this.uuid != null && otherRequest.uuid != null) {
                return this.uuid.equals(otherRequest.uuid);
            }
            return false;
        }
    }

    private static final class Breadcrumb {
        final long timestamp;
        final Type type;
        final String message;
        final String category;
        final SentryEventLevel level;
        final Map<String, String> data = new HashMap<String, String>();

        Breadcrumb(long timestamp, Type type, String message, String category, SentryEventLevel level) {
            this.timestamp = timestamp;
            this.type = type;
            this.message = message;
            this.category = category;
            this.level = level;
        }

        static enum Type {
            Default("default"),
            HTTP("http"),
            Navigation("navigation");

            private final String value;

            private Type(String value) {
                this.value = value;
            }
        }
    }

    public static interface SentryEventCaptureListener {
        public SentryEventBuilder beforeCapture(SentryEventBuilder var1);
    }

    private static class InternalStorage {
        private static final String FILE_NAME = "unsent_requests";
        private final List<SentryEventRequest> unsentRequests;

        private static InternalStorage getInstance() {
            return LazyHolder.instance;
        }

        private InternalStorage() {
            Context context = Sentry.getInstance().context;
            try {
                File unsetRequestsFile = new File(context.getFilesDir(), FILE_NAME);
                if (!unsetRequestsFile.exists()) {
                    this.writeObject(context, new ArrayList<SentryEventRequest>());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.unsentRequests = this.readObject(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SentryEventRequest> getUnsentRequests() {
            ArrayList<SentryEventRequest> copy = new ArrayList<SentryEventRequest>();
            InternalStorage internalStorage = this;
            synchronized (internalStorage) {
                copy.addAll(this.unsentRequests);
            }
            return copy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRequest(SentryEventRequest request) {
            InternalStorage internalStorage = this;
            synchronized (internalStorage) {
                Sentry.log("Adding request - " + request.uuid);
                if (!this.unsentRequests.contains(request)) {
                    this.unsentRequests.add(request);
                    this.writeObject(Sentry.getInstance().context, this.unsentRequests);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeBuilder(SentryEventRequest request) {
            InternalStorage internalStorage = this;
            synchronized (internalStorage) {
                Sentry.log("Removing request - " + request.uuid);
                this.unsentRequests.remove(request);
                this.writeObject(Sentry.getInstance().context, this.unsentRequests);
            }
        }

        private void writeObject(Context context, List<SentryEventRequest> requests) {
            try {
                FileOutputStream fos = context.openFileOutput(FILE_NAME, 0);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(requests);
                oos.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private List<SentryEventRequest> readObject(Context context) {
            try {
                FileInputStream fis = context.openFileInput(FILE_NAME);
                ObjectInputStream ois = new ObjectInputStream(fis);
                ArrayList requests = (ArrayList)ois.readObject();
                ois.close();
                fis.close();
                return requests;
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                return new ArrayList<SentryEventRequest>();
            }
        }

        private static class LazyHolder {
            private static final InternalStorage instance = new InternalStorage();

            private LazyHolder() {
            }
        }
    }

    private class SentryUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler defaultExceptionHandler;

        public SentryUncaughtExceptionHandler(Thread.UncaughtExceptionHandler pDefaultExceptionHandler) {
            this.defaultExceptionHandler = pDefaultExceptionHandler;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable e) {
            Sentry sentry = Sentry.getInstance();
            SentryEventBuilder builder = new SentryEventBuilder(e, SentryEventLevel.FATAL);
            builder.setRelease(Integer.toString(((Sentry)sentry).appInfo.versionCode));
            if (sentry.captureListener != null) {
                builder = sentry.captureListener.beforeCapture(builder);
            }
            if (builder != null) {
                builder.event.put("contexts", sentry.contexts);
                InternalStorage.getInstance().addRequest(new SentryEventRequest(builder));
            } else {
                Log.e((String)Sentry.TAG, (String)"SentryEventBuilder in uncaughtException is null");
            }
            this.defaultExceptionHandler.uncaughtException(thread, e);
        }
    }

    private static class ExSSLSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext = SSLContext.getInstance("TLS");

        ExSSLSocketFactory(SSLContext context) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
            super(null);
            this.sslContext = context;
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }

    private static class LazyHolder {
        private static final Sentry instance = new Sentry();

        private LazyHolder() {
        }
    }

    public static enum SentryEventLevel {
        FATAL("fatal"),
        ERROR("error"),
        WARNING("warning"),
        INFO("info"),
        DEBUG("debug");

        private final String value;

        private SentryEventLevel(String value) {
            this.value = value;
        }
    }
}

