/*
 * Decompiled with CFR 0.152.
 */
package com.joshdholtz.sentry;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StringWriter;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Sentry {
    private static final String VERSION = "0.2.0";
    private Context context;
    public static String sentryVersion = "7";
    public static boolean debug = false;
    private String baseUrl;
    private String dsn;
    private String packageName;
    private int verifySsl;
    private SentryEventCaptureListener captureListener;
    private static final String TAG = "Sentry";
    private static final String DEFAULT_BASE_URL = "https://app.getsentry.com";

    private Sentry() {
    }

    private static void log(String text) {
        if (debug) {
            Log.d((String)TAG, (String)text);
        }
    }

    private static Sentry getInstance() {
        return LazyHolder.instance;
    }

    public static void init(Context context, String dsn) {
        Sentry.init(context, dsn, true);
    }

    public static void init(Context context, String dsn, boolean setupUncaughtExceptionHandler) {
        Sentry.getInstance().context = context.getApplicationContext();
        Uri uri = Uri.parse((String)dsn);
        String port = "";
        if (uri.getPort() >= 0) {
            port = ":" + uri.getPort();
        }
        Sentry.getInstance().baseUrl = uri.getScheme() + "://" + uri.getHost() + port;
        Sentry.getInstance().dsn = dsn;
        Sentry.getInstance().packageName = context.getPackageName();
        Sentry.getInstance().verifySsl = Sentry.getVerifySsl(dsn);
        if (setupUncaughtExceptionHandler) {
            Sentry.getInstance().setupUncaughtExceptionHandler();
        }
    }

    private static int getVerifySsl(String dsn) {
        int verifySsl = 1;
        List<NameValuePair> params = Sentry.getAllGetParams(dsn);
        for (NameValuePair param : params) {
            if (!param.getName().equals("verify_ssl")) continue;
            return Integer.parseInt(param.getValue());
        }
        return verifySsl;
    }

    private static List<NameValuePair> getAllGetParams(String dsn) {
        List params = null;
        try {
            params = URLEncodedUtils.parse((URI)new URI(dsn), (String)"UTF-8");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return params;
    }

    private void setupUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler != null) {
            Sentry.log("current handler class=" + currentHandler.getClass().getName());
        }
        if (!(currentHandler instanceof SentryUncaughtExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new SentryUncaughtExceptionHandler(currentHandler, this.context));
        }
        Sentry.sendAllCachedCapturedEvents();
    }

    private static String createXSentryAuthHeader() {
        String header = "";
        Uri uri = Uri.parse((String)Sentry.getInstance().dsn);
        String authority = uri.getAuthority().replace("@" + uri.getHost(), "");
        String[] authorityParts = authority.split(":");
        String publicKey = authorityParts[0];
        String secretKey = authorityParts[1];
        header = header + "Sentry sentry_version=" + sentryVersion + ",";
        header = header + "sentry_client=sentry-android/0.2.0,";
        header = header + "sentry_timestamp=" + System.currentTimeMillis() + ",";
        header = header + "sentry_key=" + publicKey + ",";
        header = header + "sentry_secret=" + secretKey;
        return header;
    }

    private static String getProjectId() {
        Uri uri = Uri.parse((String)Sentry.getInstance().dsn);
        String path = uri.getPath();
        String projectId = path.substring(path.lastIndexOf("/") + 1);
        return projectId;
    }

    public static void sendAllCachedCapturedEvents() {
        List<SentryEventRequest> unsentRequests = InternalStorage.getInstance().getUnsentRequests();
        Sentry.log("Sending up " + unsentRequests.size() + " cached response(s)");
        for (SentryEventRequest request : unsentRequests) {
            Sentry.doCaptureEventPost(request);
        }
    }

    public static void setCaptureListener(SentryEventCaptureListener captureListener) {
        Sentry.getInstance().captureListener = captureListener;
    }

    public static void captureMessage(String message) {
        Sentry.captureMessage(message, SentryEventBuilder.SentryEventLevel.INFO);
    }

    public static void captureMessage(String message, SentryEventBuilder.SentryEventLevel level) {
        Sentry.captureEvent(new SentryEventBuilder().setMessage(message).setLevel(level));
    }

    public static void captureException(Throwable t) {
        Sentry.captureException(t, SentryEventBuilder.SentryEventLevel.ERROR);
    }

    public static void captureException(Throwable t, SentryEventBuilder.SentryEventLevel level) {
        String culprit = Sentry.getCause(t, t.getMessage());
        Sentry.captureEvent(new SentryEventBuilder().setMessage(t.getMessage()).setCulprit(culprit).setLevel(level).setException(t));
    }

    public static void captureUncaughtException(Context context, Throwable t) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        t.printStackTrace(printWriter);
        try {
            long random = System.currentTimeMillis();
            File stacktrace = new File(Sentry.getStacktraceLocation(context), "raven-" + String.valueOf(random) + ".stacktrace");
            Sentry.log("Writing unhandled exception to: " + stacktrace.getAbsolutePath());
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(stacktrace));
            oos.writeObject(t);
            oos.flush();
            oos.close();
        }
        catch (Exception ebos) {
            ebos.printStackTrace();
        }
        Sentry.log(((Object)result).toString());
    }

    private static String getCause(Throwable t, String culprit) {
        for (StackTraceElement stackTrace : t.getStackTrace()) {
            if (!stackTrace.toString().contains(Sentry.getInstance().packageName)) continue;
            culprit = stackTrace.toString();
            break;
        }
        return culprit;
    }

    private static File getStacktraceLocation(Context context) {
        return new File(context.getCacheDir(), "crashes");
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static void captureEvent(SentryEventBuilder builder) {
        SentryEventRequest request;
        if (Sentry.getInstance().captureListener != null) {
            if ((builder = Sentry.getInstance().captureListener.beforeCapture(builder)) == null) {
                Log.e((String)TAG, (String)"SentryEventBuilder in captureEvent is null");
                return;
            }
            request = new SentryEventRequest(builder);
        } else {
            request = new SentryEventRequest(builder);
        }
        Sentry.log("Request - " + request.getRequestData());
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Sentry.doCaptureEventPost(request);
        } else if (Sentry.getInstance().context != null) {
            HandlerThread thread = new HandlerThread("SentryThread"){};
            thread.start();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Sentry.doCaptureEventPost(request);
                }
            };
            Handler h = new Handler(thread.getLooper());
            h.post(runnable);
        }
    }

    private static boolean shouldAttemptPost() {
        PackageManager pm = Sentry.getInstance().context.getPackageManager();
        int hasPerm = pm.checkPermission("android.permission.ACCESS_NETWORK_STATE", Sentry.getInstance().context.getPackageName());
        if (hasPerm == -1) {
            return true;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)Sentry.getInstance().context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static HttpClient getHttpsClient(HttpClient client) {
        try {
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
            ExSSLSocketFactory sslSocketFactory = new ExSSLSocketFactory(sslContext);
            sslSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager clientConnectionManager = client.getConnectionManager();
            SchemeRegistry schemeRegistry = clientConnectionManager.getSchemeRegistry();
            schemeRegistry.register(new Scheme("https", (SocketFactory)sslSocketFactory, 443));
            return new DefaultHttpClient(clientConnectionManager, client.getParams());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void doCaptureEventPost(final SentryEventRequest request) {
        if (!Sentry.shouldAttemptPost()) {
            InternalStorage.getInstance().addRequest(request);
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                DefaultHttpClient httpClient;
                int projectId = Integer.parseInt(Sentry.getProjectId());
                String url = Sentry.getInstance().baseUrl + "/api/" + projectId + "/store/";
                Sentry.log("Sending to URL - " + url);
                if (Sentry.getInstance().verifySsl != 0) {
                    Sentry.log("Using http client");
                    httpClient = new DefaultHttpClient();
                } else {
                    Sentry.log("Using https client");
                    httpClient = Sentry.getHttpsClient((HttpClient)new DefaultHttpClient());
                }
                HttpPost httpPost = new HttpPost(url);
                int TIMEOUT_MILLISEC = 10000;
                HttpParams httpParams = httpPost.getParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)TIMEOUT_MILLISEC);
                HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)TIMEOUT_MILLISEC);
                HttpProtocolParams.setContentCharset((HttpParams)httpParams, (String)"UTF-8");
                HttpProtocolParams.setHttpElementCharset((HttpParams)httpParams, (String)"UTF-8");
                boolean success = false;
                try {
                    httpPost.setHeader("X-Sentry-Auth", Sentry.createXSentryAuthHeader());
                    httpPost.setHeader("User-Agent", "sentry-android/0.2.0");
                    httpPost.setHeader("Content-Type", "application/json; charset=utf-8");
                    httpPost.setEntity((HttpEntity)new StringEntity(request.getRequestData(), "UTF-8"));
                    HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                    int status = httpResponse.getStatusLine().getStatusCode();
                    byte[] byteResp = null;
                    if (httpResponse.getEntity() != null) {
                        try {
                            InputStream in = httpResponse.getEntity().getContent();
                            byteResp = this.readBytes(in);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    String stringResponse = null;
                    Charset charsetInput = Charset.forName("UTF-8");
                    CharsetDecoder decoder = charsetInput.newDecoder();
                    CharBuffer cbuf = null;
                    try {
                        cbuf = decoder.decode(ByteBuffer.wrap(byteResp));
                        stringResponse = cbuf.toString();
                    }
                    catch (CharacterCodingException e) {
                        e.printStackTrace();
                    }
                    success = status == 200;
                    Sentry.log("SendEvent - " + status + " " + stringResponse);
                }
                catch (ClientProtocolException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (success) {
                    InternalStorage.getInstance().removeBuilder(request);
                } else {
                    InternalStorage.getInstance().addRequest(request);
                }
                return null;
            }

            private byte[] readBytes(InputStream inputStream) throws IOException {
                ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
                int bufferSize = 1024;
                byte[] buffer = new byte[bufferSize];
                int len = 0;
                while ((len = inputStream.read(buffer)) != -1) {
                    byteBuffer.write(buffer, 0, len);
                }
                return byteBuffer.toByteArray();
            }
        }.execute((Object[])new Void[0]);
    }

    public static class SentryEventBuilder
    implements Serializable {
        private static final long serialVersionUID = -8589756678369463988L;
        private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        private Map<String, Object> event = new HashMap<String, Object>();

        public SentryEventBuilder() {
            this.event.put("event_id", UUID.randomUUID().toString().replace("-", ""));
            this.event.put("platform", "java");
            this.setTimestamp(System.currentTimeMillis());
        }

        public SentryEventBuilder(Throwable t, SentryEventLevel level) {
            this();
            String culprit = Sentry.getCause(t, t.getMessage());
            this.setMessage(t.getMessage()).setCulprit(culprit).setLevel(level).setException(t);
        }

        public SentryEventBuilder setMessage(String message) {
            this.event.put("message", message);
            return this;
        }

        public SentryEventBuilder setTimestamp(long timestamp) {
            this.event.put("timestamp", sdf.format(new Date(timestamp)));
            return this;
        }

        public SentryEventBuilder setLevel(SentryEventLevel level) {
            this.event.put("level", level.value);
            return this;
        }

        public SentryEventBuilder setLogger(String logger) {
            this.event.put("logger", logger);
            return this;
        }

        public SentryEventBuilder setCulprit(String culprit) {
            this.event.put("culprit", culprit);
            return this;
        }

        public SentryEventBuilder setUser(Map<String, String> user) {
            this.setUser(new JSONObject(user));
            return this;
        }

        public SentryEventBuilder setUser(JSONObject user) {
            this.event.put("user", user);
            return this;
        }

        public JSONObject getUser() {
            if (!this.event.containsKey("user")) {
                this.setTags(new HashMap<String, String>());
            }
            return (JSONObject)this.event.get("user");
        }

        public SentryEventBuilder setTags(Map<String, String> tags) {
            this.setTags(new JSONObject(tags));
            return this;
        }

        public SentryEventBuilder setTags(JSONObject tags) {
            this.event.put("tags", tags);
            return this;
        }

        public JSONObject getTags() {
            if (!this.event.containsKey("tags")) {
                this.setTags(new HashMap<String, String>());
            }
            return (JSONObject)this.event.get("tags");
        }

        public SentryEventBuilder setServerName(String serverName) {
            this.event.put("server_name", serverName);
            return this;
        }

        public SentryEventBuilder setRelease(String release) {
            this.event.put("release", release);
            return this;
        }

        public SentryEventBuilder addModule(String name, String version) {
            JSONArray modules;
            if (!this.event.containsKey("modules")) {
                modules = new JSONArray();
                this.event.put("modules", modules);
            } else {
                modules = (JSONArray)this.event.get("modules");
            }
            if (name != null && version != null) {
                String[] module = new String[]{name, version};
                modules.put((Object)new JSONArray(Arrays.asList(module)));
            }
            return this;
        }

        public SentryEventBuilder setExtra(Map<String, String> extra) {
            this.setExtra(new JSONObject(extra));
            return this;
        }

        public SentryEventBuilder setExtra(JSONObject extra) {
            this.event.put("extra", extra);
            return this;
        }

        public JSONObject getExtra() {
            if (!this.event.containsKey("extra")) {
                this.setExtra(new HashMap<String, String>());
            }
            return (JSONObject)this.event.get("extra");
        }

        public SentryEventBuilder setException(Throwable t) {
            JSONArray values = new JSONArray();
            while (t != null) {
                JSONObject exception = new JSONObject();
                try {
                    exception.put("type", (Object)t.getClass().getSimpleName());
                    exception.put("value", (Object)t.getMessage());
                    exception.put("module", (Object)t.getClass().getPackage().getName());
                    exception.put("stacktrace", (Object)SentryEventBuilder.getStackTrace(t));
                    values.put((Object)exception);
                }
                catch (JSONException e) {
                    Log.e((String)Sentry.TAG, (String)("Failed to build sentry report for " + t), (Throwable)e);
                }
                t = t.getCause();
            }
            JSONObject exceptionReport = new JSONObject();
            try {
                exceptionReport.put("values", (Object)values);
                this.event.put("exception", exceptionReport);
            }
            catch (JSONException e) {
                Log.e((String)Sentry.TAG, (String)("Unable to attach exception to event " + values), (Throwable)e);
            }
            return this;
        }

        public static JSONObject getStackTrace(Throwable t) throws JSONException {
            JSONArray frameList = new JSONArray();
            for (StackTraceElement ste : t.getStackTrace()) {
                JSONObject frame = new JSONObject();
                String method = ste.getMethodName();
                if (method.length() != 0) {
                    frame.put("function", (Object)method);
                }
                int lineno = ste.getLineNumber();
                if (!ste.isNativeMethod() && lineno >= 0) {
                    frame.put("lineno", lineno);
                }
                boolean inApp = true;
                String className = ste.getClassName();
                frame.put("module", (Object)className);
                if (className.startsWith("android.") || className.startsWith("java.") || className.startsWith("dalvik.") || className.startsWith("com.android.")) {
                    inApp = false;
                }
                frame.put("in_app", inApp);
                frameList.put((Object)frame);
            }
            JSONObject frameHash = new JSONObject();
            frameHash.put("frames", (Object)frameList);
            return frameHash;
        }

        static {
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        public static enum SentryEventLevel {
            FATAL("fatal"),
            ERROR("error"),
            WARNING("warning"),
            INFO("info"),
            DEBUG("debug");

            private String value;

            private SentryEventLevel(String value) {
                this.value = value;
            }
        }
    }

    public static class SentryEventRequest
    implements Serializable {
        private String requestData;
        private UUID uuid;

        public SentryEventRequest(SentryEventBuilder builder) {
            this.requestData = new JSONObject(builder.event).toString();
            this.uuid = UUID.randomUUID();
        }

        public String getRequestData() {
            return this.requestData;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public boolean equals(Object other) {
            SentryEventRequest otherRequest = (SentryEventRequest)other;
            if (this.uuid != null && otherRequest.uuid != null) {
                return this.uuid.equals(otherRequest.uuid);
            }
            return false;
        }
    }

    public static abstract class SentryEventCaptureListener {
        public abstract SentryEventBuilder beforeCapture(SentryEventBuilder var1);
    }

    private static class InternalStorage {
        private static final String FILE_NAME = "unsent_requests";
        private List<SentryEventRequest> unsentRequests;

        private static InternalStorage getInstance() {
            return LazyHolder.instance;
        }

        private InternalStorage() {
            Context context = Sentry.getInstance().context;
            try {
                File unsetRequestsFile = new File(context.getFilesDir(), FILE_NAME);
                if (!unsetRequestsFile.exists()) {
                    this.writeObject(context, new ArrayList<SentryEventRequest>());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.unsentRequests = this.readObject(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SentryEventRequest> getUnsentRequests() {
            ArrayList<SentryEventRequest> copy = new ArrayList<SentryEventRequest>();
            InternalStorage internalStorage = this;
            synchronized (internalStorage) {
                copy.addAll(this.unsentRequests);
            }
            return copy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRequest(SentryEventRequest request) {
            InternalStorage internalStorage = this;
            synchronized (internalStorage) {
                Sentry.log("Adding request - " + request.uuid);
                if (!this.unsentRequests.contains(request)) {
                    this.unsentRequests.add(request);
                    this.writeObject(Sentry.getInstance().context, this.unsentRequests);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeBuilder(SentryEventRequest request) {
            InternalStorage internalStorage = this;
            synchronized (internalStorage) {
                Sentry.log("Removing request - " + request.uuid);
                this.unsentRequests.remove(request);
                this.writeObject(Sentry.getInstance().context, this.unsentRequests);
            }
        }

        private void writeObject(Context context, List<SentryEventRequest> requests) {
            try {
                FileOutputStream fos = context.openFileOutput(FILE_NAME, 0);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(requests);
                oos.close();
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private List<SentryEventRequest> readObject(Context context) {
            try {
                FileInputStream fis = context.openFileInput(FILE_NAME);
                ObjectInputStream ois = new ObjectInputStream(fis);
                ArrayList requests = (ArrayList)ois.readObject();
                ois.close();
                fis.close();
                return requests;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (StreamCorruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return new ArrayList<SentryEventRequest>();
        }

        private static class LazyHolder {
            private static InternalStorage instance = new InternalStorage();

            private LazyHolder() {
            }
        }
    }

    private class SentryUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private Thread.UncaughtExceptionHandler defaultExceptionHandler;
        private Context context;

        public SentryUncaughtExceptionHandler(Thread.UncaughtExceptionHandler pDefaultExceptionHandler, Context context) {
            this.defaultExceptionHandler = pDefaultExceptionHandler;
            this.context = context;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable e) {
            SentryEventBuilder builder = new SentryEventBuilder(e, SentryEventBuilder.SentryEventLevel.FATAL);
            if (Sentry.getInstance().captureListener != null) {
                builder = Sentry.getInstance().captureListener.beforeCapture(builder);
            }
            if (builder != null) {
                InternalStorage.getInstance().addRequest(new SentryEventRequest(builder));
            } else {
                Log.e((String)Sentry.TAG, (String)"SentryEventBuilder in uncaughtException is null");
            }
            this.defaultExceptionHandler.uncaughtException(thread, e);
        }
    }

    public static class ExSSLSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext = SSLContext.getInstance("TLS");

        public ExSSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            this.sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
        }

        public ExSSLSocketFactory(SSLContext context) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
            super(null);
            this.sslContext = context;
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }

    private static class LazyHolder {
        private static Sentry instance = new Sentry();

        private LazyHolder() {
        }
    }
}

