/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.xml.consulta.sql;

import com.joseflavio.xml.Tipo;
import com.joseflavio.xml.TipoFormatacao;
import com.joseflavio.xml.consulta.Consulta;
import com.joseflavio.xml.consulta.Consultas;
import com.joseflavio.xml.consulta.Parametro;
import com.joseflavio.xml.consulta.Traducao;
import com.joseflavio.xml.consulta.Valor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ConsultaSQL {
    public static Map<String, String[][]> realizar(Consultas consultas) throws ClassNotFoundException, SQLException {
        Map<String, Parametro> parametrosGlobais = consultas.getParametro();
        String jdbc = parametrosGlobais.get("jdbc").getValor();
        String url = parametrosGlobais.get("url").getValor();
        String usuario = parametrosGlobais.get("usuario").getValor();
        String senha = parametrosGlobais.get("senha").getValor();
        if (jdbc == null || url == null || usuario == null || senha == null) {
            throw new IllegalArgumentException();
        }
        Class.forName(jdbc);
        Connection conexao = DriverManager.getConnection(url, usuario, senha);
        HashMap<String, String[][]> resultado = new HashMap<String, String[][]>();
        ArrayList<String> valor = new ArrayList<String>(4096);
        TipoFormatacao tipoForm = new TipoFormatacao();
        for (Consulta consulta : consultas.getConsulta().values()) {
            int coluna;
            if (consultas.getDesconsiderar().contains(consulta)) continue;
            Map<String, Parametro> parametrosLocais = consulta.getParametro();
            String sql = consulta.getQuestionamento().trim();
            if (!sql.toUpperCase().startsWith("SELECT")) {
                throw new IllegalArgumentException("Aceita-se apenas instru\u00e7\u00f5es do tipo SELECT.");
            }
            PreparedStatement ps = conexao.prepareStatement(sql.replaceAll("::.*?::", "?"));
            int pi = 0;
            int pf = 0;
            int pindice = 1;
            while ((pi = sql.indexOf("::", pf)) > -1 && (pf = sql.indexOf("::", pi + 3)) != -1) {
                String sqlParamNome = sql.substring(pi + 2, pf);
                Parametro sqlParam = parametrosLocais.get(sqlParamNome);
                if (sqlParam == null) {
                    sqlParam = parametrosGlobais.get(sqlParamNome);
                }
                if (sqlParam != null) {
                    String sqlParamValor = sqlParam.getValor();
                    Tipo sqlParamTipo = sqlParam.getTipo();
                    if (sqlParamTipo == null) {
                        sqlParamTipo = tipoForm.reconhecerTipo(sqlParamValor);
                    }
                    if (sqlParamTipo != null) {
                        ps.setObject(pindice++, tipoForm.transformar(sqlParamValor, sqlParamTipo), ConsultaSQL.converter(sqlParamTipo));
                    } else {
                        ps.setObject(pindice++, tipoForm.transformar(sqlParamValor, sqlParamTipo));
                    }
                } else {
                    throw new IllegalArgumentException("Par\u00e2metro indeterminado: " + sqlParamNome);
                }
                pf += 2;
            }
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData rsmeta = rs.getMetaData();
            int totalColunas = rsmeta.getColumnCount();
            Traducao.Instancia[] traducao = new Traducao.Instancia[totalColunas];
            valor.clear();
            for (coluna = 1; coluna <= totalColunas; ++coluna) {
                String nome = rsmeta.getColumnLabel(coluna);
                valor.add(nome);
                traducao[coluna - 1] = consulta.getTraducao().get(nome);
            }
            while (rs.next()) {
                for (coluna = 1; coluna <= totalColunas; ++coluna) {
                    Object o = rs.getObject(coluna);
                    String v = null;
                    if (o != null) {
                        switch (rsmeta.getColumnType(coluna)) {
                            case 6: 
                            case 7: 
                            case 8: {
                                v = tipoForm.transcrever(rs.getDouble(coluna), Tipo.REAL);
                                break;
                            }
                            case 91: {
                                v = tipoForm.transcrever(rs.getDate(coluna), Tipo.DATA);
                                break;
                            }
                            case 92: {
                                v = tipoForm.transcrever(rs.getTime(coluna), Tipo.HORA);
                                break;
                            }
                            case 93: {
                                v = tipoForm.transcrever(rs.getTimestamp(coluna), Tipo.DATA_HORA);
                                break;
                            }
                            default: {
                                v = rs.getString(coluna);
                                break;
                            }
                        }
                    } else {
                        v = "";
                    }
                    if (traducao[coluna - 1] != null) {
                        Valor t = traducao[coluna - 1].getTipo().getValor().get(v);
                        valor.add(t != null ? t.getTraducao() : v);
                        continue;
                    }
                    valor.add(v);
                }
            }
            int origem = 0;
            int totalLinhas = valor.size() / totalColunas;
            String[][] tabela = new String[totalLinhas][totalColunas];
            for (int i = 0; i < totalLinhas; ++i) {
                for (int j = 0; j < totalColunas; ++j) {
                    tabela[i][j] = (String)valor.get(origem++);
                }
            }
            resultado.put(consulta.getNome(), tabela);
        }
        return resultado;
    }

    private static int converter(Tipo tipo) {
        switch (tipo) {
            case LOGICO: {
                return 16;
            }
            case LETRA: {
                return 1;
            }
            case INTEIRO: {
                return 4;
            }
            case REAL: {
                return 7;
            }
            case DATA: {
                return 91;
            }
            case HORA: {
                return 92;
            }
            case DATA_HORA: {
                return 93;
            }
        }
        return 12;
    }
}

