/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.xml.consulta;

import com.joseflavio.xml.Tipo;
import com.joseflavio.xml.consulta.Consulta;
import com.joseflavio.xml.consulta.Parametro;
import com.joseflavio.xml.consulta.Traducao;
import com.joseflavio.xml.consulta.Valor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Consultas {
    private String descricao;
    private String documentacao;
    private Map<String, Parametro> parametro = new HashMap<String, Parametro>();
    private Map<String, Consulta> consulta = new HashMap<String, Consulta>();
    private Map<String, Traducao> traducao = new HashMap<String, Traducao>();
    private Set<Consulta> desconsiderar = new HashSet<Consulta>();

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getDocumentacao() {
        return this.documentacao;
    }

    public void setDocumentacao(String documentacao) {
        this.documentacao = documentacao;
    }

    public Map<String, Parametro> getParametro() {
        return this.parametro;
    }

    public void setParametro(Map<String, Parametro> parametro) {
        this.parametro = parametro;
    }

    public Map<String, Consulta> getConsulta() {
        return this.consulta;
    }

    public void setConsulta(Map<String, Consulta> consulta) {
        this.consulta = consulta;
    }

    public Map<String, Traducao> getTraducao() {
        return this.traducao;
    }

    public void setTraducao(Map<String, Traducao> traducao) {
        this.traducao = traducao;
    }

    public Set<Consulta> getDesconsiderar() {
        return this.desconsiderar;
    }

    public void setDesconsiderar(Set<Consulta> desconsiderar) {
        this.desconsiderar = desconsiderar;
    }

    public static Consultas carregar(InputStream xml, Schema schema) throws IOException {
        try {
            block5: {
                try {
                    URL url = new URL("http://www.joseflavio.com/xml/Consulta.xsd");
                    URLConnection conexao = url.openConnection();
                    conexao.connect();
                    schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(conexao.getInputStream()));
                }
                catch (Exception e) {
                    if (schema != null) break block5;
                    throw new IOException(e);
                }
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setSchema(schema);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            return Consultas.carregar(db.parse(xml));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Consultas carregar(File xml, Schema schema) throws IOException {
        return Consultas.carregar(new FileInputStream(xml), schema);
    }

    public static Consultas carregar(URL xml, Schema schema) throws IOException {
        return Consultas.carregar(xml.openConnection().getInputStream(), schema);
    }

    private static Consultas carregar(Document xml) throws IOException {
        Node n = xml.getFirstChild();
        NodeList nl = n.getChildNodes();
        NamedNodeMap a = n.getAttributes();
        Consultas consultas = new Consultas();
        consultas.setDescricao(a.getNamedItem("descricao").getNodeValue());
        int total = nl.getLength();
        for (int i = 0; i < total; ++i) {
            n = nl.item(i);
            String nome = n.getNodeName();
            if (nome.equals("parametro")) {
                Consultas.xml_parametro(n, consultas.getParametro());
                continue;
            }
            if (nome.equals("consulta")) {
                Consultas.xml_consultas_consulta(n, consultas);
                continue;
            }
            if (nome.equals("traducao")) {
                Consultas.xml_consultas_traducao(n, consultas);
                continue;
            }
            if (nome.equals("desconsiderar")) {
                Consultas.xml_consultas_desconsiderar(n, consultas);
                continue;
            }
            if (!nome.equals("documentacao")) continue;
            consultas.setDocumentacao(n.getTextContent());
        }
        return consultas;
    }

    private static void xml_parametro(Node n, Map<String, Parametro> destino) throws IOException {
        NamedNodeMap a = n.getAttributes();
        String nome = a.getNamedItem("nome").getNodeValue();
        String valor = a.getNamedItem("valor").getNodeValue();
        String tipoStr = a.getNamedItem("tipo") != null ? a.getNamedItem("tipo").getNodeValue() : null;
        Tipo tipo = null;
        if (tipoStr == null || tipoStr.length() == 0) {
            tipo = null;
        } else if (tipoStr.equals("Logico")) {
            tipo = Tipo.LOGICO;
        } else if (tipoStr.equals("Letra")) {
            tipo = Tipo.LETRA;
        } else if (tipoStr.equals("Texto")) {
            tipo = Tipo.TEXTO;
        } else if (tipoStr.equals("TextoMultilinha")) {
            tipo = Tipo.TEXTO_MULTILINHA;
        } else if (tipoStr.equals("Inteiro")) {
            tipo = Tipo.INTEIRO;
        } else if (tipoStr.equals("Real")) {
            tipo = Tipo.REAL;
        } else if (tipoStr.equals("Data")) {
            tipo = Tipo.DATA;
        } else if (tipoStr.equals("Hora")) {
            tipo = Tipo.HORA;
        } else if (tipoStr.equals("DataHora")) {
            tipo = Tipo.DATA_HORA;
        }
        boolean alteravel = a.getNamedItem("alteravel") != null ? a.getNamedItem("alteravel").getNodeValue().equals("S") : false;
        Parametro parametro = new Parametro(nome, valor);
        parametro.setTipo(tipo);
        parametro.setAlteravel(alteravel);
        destino.put(nome, parametro);
    }

    private static void xml_consultas_consulta(Node n, Consultas consultas) throws IOException {
        NodeList nl = n.getChildNodes();
        NamedNodeMap a = n.getAttributes();
        Consulta consulta = new Consulta(a.getNamedItem("nome").getNodeValue());
        consulta.setDescricao(a.getNamedItem("descricao").getNodeValue());
        int total = nl.getLength();
        for (int i = 0; i < total; ++i) {
            n = nl.item(i);
            String nome = n.getNodeName();
            if (nome.equals("parametro")) {
                Consultas.xml_parametro(n, consulta.getParametro());
                continue;
            }
            if (nome.equals("questionamento")) {
                consulta.setQuestionamento(n.getTextContent().trim());
                continue;
            }
            if (nome.equals("traducao")) {
                Consultas.xml_consultas_consulta_traducao(n, consultas, consulta);
                continue;
            }
            if (!nome.equals("documentacao")) continue;
            consulta.setDocumentacao(n.getTextContent());
        }
        consultas.getConsulta().put(consulta.getNome(), consulta);
    }

    private static void xml_consultas_traducao(Node n, Consultas consultas) throws IOException {
        NodeList nl = n.getChildNodes();
        NamedNodeMap a = n.getAttributes();
        String nome = a.getNamedItem("nome").getNodeValue();
        Traducao traducao = consultas.getTraducao().get(nome);
        if (traducao == null) {
            traducao = new Traducao(nome);
            consultas.getTraducao().put(nome, traducao);
        }
        int total = nl.getLength();
        for (int i = 0; i < total; ++i) {
            n = nl.item(i);
            nome = n.getNodeName();
            if (!nome.equals("valor")) continue;
            Consultas.xml_consultas_traducao_valor(n, traducao);
        }
    }

    private static void xml_consultas_traducao_valor(Node n, Traducao traducao) throws IOException {
        NamedNodeMap a = n.getAttributes();
        String original = a.getNamedItem("original").getNodeValue();
        traducao.getValor().put(original, new Valor(original, a.getNamedItem("traducao").getNodeValue()));
    }

    private static void xml_consultas_consulta_traducao(Node n, Consultas consultas, Consulta consulta) throws IOException {
        NamedNodeMap a = n.getAttributes();
        String campo = a.getNamedItem("campo").getNodeValue();
        String tipo = a.getNamedItem("tipo").getNodeValue();
        Traducao traducao = consultas.getTraducao().get(tipo);
        if (traducao == null) {
            traducao = new Traducao(tipo);
            consultas.getTraducao().put(tipo, traducao);
        }
        consulta.getTraducao().put(campo, new Traducao.Instancia(campo, traducao));
    }

    private static void xml_consultas_desconsiderar(Node n, Consultas consultas) throws IOException {
        NodeList nl = n.getChildNodes();
        int total = nl.getLength();
        for (int i = 0; i < total; ++i) {
            n = nl.item(i);
            String nome = n.getNodeName();
            if (!nome.equals("consulta")) continue;
            consultas.getDesconsiderar().add(consultas.getConsulta().get(n.getTextContent().trim()));
        }
    }
}

