/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.xml;

import com.joseflavio.xml.Tipo;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class TipoFormatacao {
    private NumberFormat formatoReal = NumberFormat.getInstance(new Locale("pt", "BR"));
    private SimpleDateFormat formatoData;
    private SimpleDateFormat formatoHora1;
    private SimpleDateFormat formatoHora2;
    private SimpleDateFormat formatoDataHora1;
    private SimpleDateFormat formatoDataHora2;
    private Pattern padraoInteiro;
    private Pattern padraoReal;
    private Pattern padraoData;
    private Pattern padraoHora;
    private Pattern padraoDataHora;

    public TipoFormatacao() {
        this.formatoReal.setGroupingUsed(false);
        this.formatoReal.setMinimumIntegerDigits(1);
        this.formatoReal.setMinimumFractionDigits(1);
        this.formatoData = new SimpleDateFormat("dd/MM/yyyy");
        this.formatoHora1 = new SimpleDateFormat("HH:mm:ss");
        this.formatoHora2 = new SimpleDateFormat("HH:mm:ss:SSS");
        this.formatoDataHora1 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        this.formatoDataHora2 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
        this.padraoInteiro = Pattern.compile("[+|-]?[0-9]+");
        this.padraoReal = Pattern.compile("[+|-]?[0-9]+,[0-9]+");
        this.padraoData = Pattern.compile("\\d{2}/\\d{2}/\\d{4}");
        this.padraoHora = Pattern.compile("\\d{2}:\\d{2}:\\d{2}(:\\d{3})?");
        this.padraoDataHora = Pattern.compile("\\d{2}/\\d{2}/\\d{4} \\d{2}:\\d{2}:\\d{2}(:\\d{3})?");
    }

    public synchronized String transcrever(Object objeto, Tipo tipo) {
        if (objeto == null) {
            return "";
        }
        if (objeto instanceof String) {
            if (tipo == null) {
                tipo = Tipo.TEXTO;
            }
            switch (tipo) {
                case TEXTO: 
                case TEXTO_MULTILINHA: {
                    return objeto.toString();
                }
            }
            throw new IllegalArgumentException("Tipo deve ser " + Tipo.TEXTO.toString() + " ou " + Tipo.TEXTO_MULTILINHA.toString());
        }
        if (objeto instanceof Number) {
            if (tipo == null) {
                tipo = Tipo.REAL;
            }
            switch (tipo) {
                case INTEIRO: {
                    return "" + ((Number)objeto).longValue();
                }
                case REAL: {
                    return this.formatoReal.format(((Number)objeto).doubleValue());
                }
            }
            throw new IllegalArgumentException("Tipo deve ser " + Tipo.INTEIRO.toString() + " ou " + Tipo.REAL.toString());
        }
        if (objeto instanceof Character) {
            if (tipo == null) {
                tipo = Tipo.LETRA;
            }
            if (tipo != Tipo.LETRA) {
                throw new IllegalArgumentException("Tipo deve ser " + Tipo.LETRA.toString());
            }
            return objeto.toString();
        }
        if (objeto instanceof Boolean) {
            if (tipo == null) {
                tipo = Tipo.LOGICO;
            }
            if (tipo != Tipo.LOGICO) {
                throw new IllegalArgumentException("Tipo deve ser " + Tipo.LOGICO.toString());
            }
            return (Boolean)objeto != false ? "S" : "N";
        }
        if (objeto instanceof Date) {
            if (tipo == null) {
                tipo = Tipo.DATA_HORA;
            }
            switch (tipo) {
                case DATA: {
                    return this.formatoData.format((Date)objeto);
                }
                case HORA: {
                    return this.formatoHora2.format((Date)objeto);
                }
                case DATA_HORA: {
                    return this.formatoDataHora2.format((Date)objeto);
                }
            }
            throw new IllegalArgumentException("Tipo deve ser " + Tipo.DATA.toString() + ", " + Tipo.HORA.toString() + " ou " + Tipo.DATA_HORA.toString());
        }
        throw new IllegalArgumentException("Objeto incompat\u00edvel.");
    }

    public synchronized Object transformar(String texto, Tipo tipo) {
        if (texto == null) {
            return null;
        }
        if (tipo == null) {
            tipo = this.reconhecerTipo(texto);
        }
        if (texto.length() == 0 && tipo != Tipo.TEXTO && tipo != Tipo.TEXTO_MULTILINHA) {
            return null;
        }
        switch (tipo) {
            case LOGICO: {
                return new Boolean(texto.equals("S"));
            }
            case LETRA: {
                return new Character(texto.charAt(0));
            }
            case INTEIRO: {
                return new Long(texto);
            }
            case REAL: {
                try {
                    return this.formatoReal.parse(texto);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            case DATA: {
                try {
                    return this.formatoData.parse(texto.substring(0, 10));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            case HORA: {
                try {
                    return texto.length() == 8 ? this.formatoHora1.parse(texto) : this.formatoHora2.parse(texto);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            case DATA_HORA: {
                try {
                    return texto.length() == 19 ? this.formatoDataHora1.parse(texto) : this.formatoDataHora2.parse(texto);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return texto;
    }

    public synchronized Tipo reconhecerTipo(String valor) {
        if (valor == null || valor.length() == 0) {
            return null;
        }
        if (this.padraoInteiro.matcher(valor).matches()) {
            return Tipo.INTEIRO;
        }
        if (this.padraoReal.matcher(valor).matches()) {
            return Tipo.REAL;
        }
        if (this.padraoData.matcher(valor).matches()) {
            return Tipo.DATA;
        }
        if (this.padraoHora.matcher(valor).matches()) {
            return Tipo.HORA;
        }
        if (this.padraoDataHora.matcher(valor).matches()) {
            return Tipo.DATA_HORA;
        }
        if (valor.length() == 1) {
            return Tipo.LETRA;
        }
        return Tipo.TEXTO;
    }
}

