/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.validacao;

public class ValidacaoException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int INFORMACAO = 1;
    public static final int ATENCAO = 2;
    public static final int ERRO = 3;
    private String nome;
    private int tipo;
    private Object objetoInvalido;

    public ValidacaoException(String nome, int tipo, Object objetoInvalido, String mensagem) {
        super(mensagem);
        this.nome = nome;
        this.tipo = tipo;
        this.objetoInvalido = objetoInvalido;
    }

    public static ValidacaoException novaInformacao(String nome, Object objetoInvalido, String mensagem) {
        return new ValidacaoException(nome, 1, objetoInvalido, mensagem);
    }

    public static ValidacaoException novaAtencao(String nome, Object objetoInvalido, String mensagem) {
        return new ValidacaoException(nome, 2, objetoInvalido, mensagem);
    }

    public static ValidacaoException novoErro(String nome, Object objetoInvalido, String mensagem) {
        return new ValidacaoException(nome, 3, objetoInvalido, mensagem);
    }

    public static ValidacaoException novaInformacao(String mensagem) {
        return new ValidacaoException(null, 1, null, mensagem);
    }

    public static ValidacaoException novaAtencao(String mensagem) {
        return new ValidacaoException(null, 2, null, mensagem);
    }

    public static ValidacaoException novoErro(String mensagem) {
        return new ValidacaoException(null, 3, null, mensagem);
    }

    public String getNome() {
        return this.nome;
    }

    public int getTipo() {
        return this.tipo;
    }

    public Object getObjetoInvalido() {
        return this.objetoInvalido;
    }

    public String getMensagem() {
        return this.getMessage();
    }
}

