/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.validacao;

import com.joseflavio.validacao.Validacao;
import com.joseflavio.validacao.ValidacaoException;

public class RealLimiteValidacao
extends Validacao {
    private String nome;
    private int tipo;
    private String mensagem;
    private double min;
    private double max;

    public RealLimiteValidacao(String nome, double min, double max, int tipo, String mensagem) {
        this.nome = nome;
        this.tipo = tipo;
        this.mensagem = mensagem;
        this.min = min;
        this.max = max;
    }

    public RealLimiteValidacao(double min, double max, String mensagem) {
        this(null, min, max, 3, mensagem);
    }

    @Override
    public void validar(Object objeto) throws ValidacaoException {
        if (objeto == null) {
            return;
        }
        double n = Double.MAX_VALUE;
        if (objeto instanceof Double) {
            n = (Double)objeto;
        } else if (objeto instanceof Float) {
            n = ((Float)objeto).doubleValue();
        } else if (objeto instanceof Integer) {
            n = ((Integer)objeto).doubleValue();
        } else if (objeto instanceof Long) {
            n = ((Long)objeto).doubleValue();
        } else if (objeto instanceof Short) {
            n = ((Short)objeto).doubleValue();
        } else if (objeto instanceof Byte) {
            n = ((Byte)objeto).doubleValue();
        }
        if (n < this.min || n > this.max) {
            throw new ValidacaoException(this.nome, this.tipo, objeto, this.mensagem);
        }
    }
}

