/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.validacao;

import com.joseflavio.validacao.Validacao;
import com.joseflavio.validacao.ValidacaoException;

public class InteiroLimiteValidacao
extends Validacao {
    private String nome;
    private int tipo;
    private String mensagem;
    private long min;
    private long max;

    public InteiroLimiteValidacao(String nome, long min, long max, int tipo, String mensagem) {
        this.nome = nome;
        this.tipo = tipo;
        this.mensagem = mensagem;
        this.min = min;
        this.max = max;
    }

    public InteiroLimiteValidacao(long min, long max, String mensagem) {
        this(null, min, max, 3, mensagem);
    }

    @Override
    public void validar(Object objeto) throws ValidacaoException {
        if (objeto == null) {
            return;
        }
        long n = Long.MAX_VALUE;
        if (objeto instanceof Integer) {
            n = ((Integer)objeto).longValue();
        } else if (objeto instanceof Long) {
            n = (Long)objeto;
        } else if (objeto instanceof Short) {
            n = ((Short)objeto).longValue();
        } else if (objeto instanceof Byte) {
            n = ((Byte)objeto).longValue();
        } else if (objeto instanceof Double) {
            n = ((Double)objeto).longValue();
        } else if (objeto instanceof Float) {
            n = ((Float)objeto).longValue();
        }
        if (n < this.min || n > this.max) {
            throw new ValidacaoException(this.nome, this.tipo, objeto, this.mensagem);
        }
    }
}

