/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.util;

import java.util.ArrayList;
import java.util.List;

public class TextoUtil {
    public static String limitarComprimento(String texto, int comprimentoMaximo, boolean usarReticencias) {
        if (texto == null) {
            return "";
        }
        if (comprimentoMaximo <= 0) {
            return texto;
        }
        int len = texto.length();
        if (len > comprimentoMaximo) {
            if (usarReticencias && comprimentoMaximo >= 4) {
                return texto.substring(0, comprimentoMaximo - 3) + "...";
            }
            return texto.substring(0, comprimentoMaximo);
        }
        return texto;
    }

    public static String fixarComprimento(String texto, int comprimento, boolean usarReticencias) {
        if (texto == null) {
            return "";
        }
        int len = texto.length();
        if (len < comprimento) {
            StringBuilder sb = new StringBuilder(comprimento);
            sb.append(texto);
            len = comprimento - len;
            for (int i = 0; i < len; ++i) {
                sb.append(' ');
            }
            return sb.toString();
        }
        return TextoUtil.limitarComprimento(texto, comprimento, usarReticencias);
    }

    public static String toString(Object objeto) {
        return TextoUtil.toString(objeto, false);
    }

    public static String toString(Object objeto, boolean retornarNulo) {
        return objeto != null ? objeto.toString() : (retornarNulo ? null : "");
    }

    public static List<String> toString(List<?> objetos) {
        return TextoUtil.toString(objetos, false);
    }

    public static String[] toString(Object[] objetos) {
        return TextoUtil.toString(objetos, false);
    }

    public static List<String> toString(List<?> objetos, boolean retornarNulo) {
        if (objetos == null) {
            return retornarNulo ? null : new ArrayList();
        }
        ArrayList<String> lista = new ArrayList<String>(objetos.size());
        for (Object o : objetos) {
            lista.add((String)(o != null ? o.toString() : (retornarNulo ? null : "")));
        }
        return lista;
    }

    public static String[] toString(Object[] objetos, boolean retornarNulo) {
        if (objetos == null) {
            return retornarNulo ? null : new String[]{};
        }
        int total = objetos.length;
        String[] lista = new String[total];
        for (int i = 0; i < total; ++i) {
            Object o = objetos[i];
            lista[i] = o != null ? o.toString() : (retornarNulo ? null : "");
        }
        return lista;
    }
}

