/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.util;

public final class SeparadorTextual {
    private String texto;
    private String[] sepStr;
    private char[] sepChar;
    private String[] partes;
    private int totalPartes = 0;

    private SeparadorTextual(String[] sepStr, char[] sepChar) {
        this.sepStr = sepStr;
        this.sepChar = sepChar;
        this.partes = new String[(sepStr != null ? sepStr.length : sepChar.length) + 1];
    }

    public SeparadorTextual(String[] separadores) {
        this(separadores, null);
    }

    public SeparadorTextual(char[] separadores) {
        this(null, separadores);
    }

    public SeparadorTextual(String separador) {
        this(new String[]{separador});
    }

    public SeparadorTextual(char separador) {
        this(new char[]{separador});
    }

    public void executar(String texto) {
        this.texto = texto;
        for (int i = 0; i < this.totalPartes; ++i) {
            this.partes[i] = null;
        }
        if (this.sepStr != null) {
            this.executarSepStr();
        } else {
            this.executarSepChar();
        }
    }

    private void executarSepStr() {
        int letras = this.texto.length();
        int pos = 0;
        int totalSep = this.sepStr.length;
        int sep = 0;
        int parte = 0;
        while (pos < letras) {
            String separador;
            int posAux;
            if (sep == totalSep) {
                this.partes[parte++] = this.texto.substring(pos, letras);
                break;
            }
            if ((posAux = this.texto.indexOf(separador = this.sepStr[sep++], pos)) == -1) {
                posAux = letras;
            }
            this.partes[parte++] = this.texto.substring(pos, posAux);
            pos = posAux + separador.length();
        }
        this.totalPartes = parte;
    }

    private void executarSepChar() {
        int letras = this.texto.length();
        int pos = 0;
        int totalSep = this.sepChar.length;
        int sep = 0;
        int parte = 0;
        while (pos < letras) {
            char separador;
            int posAux;
            if (sep == totalSep) {
                this.partes[parte++] = this.texto.substring(pos, letras);
                break;
            }
            if ((posAux = this.texto.indexOf(separador = this.sepChar[sep++], pos)) == -1) {
                posAux = letras;
            }
            this.partes[parte++] = this.texto.substring(pos, posAux);
            pos = posAux + 1;
        }
        this.totalPartes = parte;
    }

    public String getTexto() {
        return this.texto;
    }

    public int getTotalPartes() {
        return this.totalPartes;
    }

    public String getParte(int indice) {
        if (indice >= this.totalPartes) {
            throw new IndexOutOfBoundsException("" + indice);
        }
        return this.partes[indice];
    }
}

