/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.util;

import java.util.ArrayList;
import java.util.Collection;

public class Lista<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;

    public Lista() {
    }

    public Lista(Collection<T> c) {
        super(c);
    }

    public Lista(T cabeca, T ... cauda) {
        super(1 + cauda.length);
        this.add(cabeca);
        for (T t : cauda) {
            this.add(t);
        }
    }

    public Lista(T cabeca, Collection<T> cauda) {
        super(1 + cauda.size());
        this.add(cabeca);
        for (T t : cauda) {
            this.add(t);
        }
    }

    public Lista(int capacidade) {
        super(capacidade);
    }

    public Lista(T[] lista) {
        super(lista != null ? lista.length : 10);
        if (lista != null) {
            for (T t : lista) {
                this.add(t);
            }
        }
    }

    public Lista<T> mais(T obj) {
        this.add(obj);
        return this;
    }

    public Lista<T> mais(int indice, T obj) {
        this.add(indice, obj);
        return this;
    }

    public T menosUltimo() {
        int total = this.size();
        return total > 0 ? (T)this.remove(total - 1) : null;
    }

    public T getUltimo() {
        int total = this.size();
        return total > 0 ? (T)this.get(total - 1) : null;
    }
}

