/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.util;

import com.joseflavio.util.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class Instanciador<T> {
    private Constructor<?> construtor;
    private Object[] parametros;

    public Instanciador(Class<? extends T> classe, Object ... parametros) {
        this.construtor = Instanciador.getConstrutor(classe, parametros);
        this.parametros = parametros;
    }

    public static Constructor<?> getConstrutor(Class<?> classe, Object ... parametros) throws IllegalArgumentException {
        Class[] a = new Class[parametros.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = parametros[i] != null ? parametros[i].getClass() : null;
        }
        for (Constructor<?> c : classe.getDeclaredConstructors()) {
            Class<?>[] b = c.getParameterTypes();
            if (a.length != b.length) continue;
            boolean ok = true;
            for (int i = 0; i < b.length; ++i) {
                Class x = a[i];
                Class<?> y = b[i];
                if ((x == null || ClassUtil.getInvolucro(y).isAssignableFrom(x)) && (x != null || !y.isPrimitive())) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return c;
        }
        throw new IllegalArgumentException();
    }

    public static <T> T instanciar(Class<? extends T> classe, Object ... parametros) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return Instanciador.getConstrutor(classe, parametros).newInstance(parametros);
    }

    public T instanciar() throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return (T)this.construtor.newInstance(this.parametros);
    }
}

