/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.util;

import java.util.Date;
import java.util.TimeZone;

public class DataSimples {
    private static final long ANO_365_MS = 31536000000L;
    private static final long ANO_366_MS = 31622400000L;
    private static final long MES_28_MS = 2419200000L;
    private static final long MES_29_MS = 2505600000L;
    private static final long MES_30_MS = 2592000000L;
    private static final long MES_31_MS = 2678400000L;
    private static final long[] MES_MS = new long[]{2678400000L, 0L, 2678400000L, 2592000000L, 2678400000L, 2592000000L, 2678400000L, 2678400000L, 2592000000L, 2678400000L, 2592000000L, 2678400000L};
    private static final long DIA_MS = 86400000L;
    private static final long HORA_MS = 3600000L;
    private static final long MINUTO_MS = 60000L;
    private long timestamp;
    private TimeZone tz;
    private int dia;
    private int mes;
    private int ano;
    private int h;
    private int m;
    private int s;
    private int ms;
    private Date date;

    public DataSimples(long timestamp, TimeZone tz) {
        this.tz = tz;
        this.setTimestamp(timestamp);
    }

    public DataSimples(long timestamp) {
        this(timestamp, TimeZone.getDefault());
    }

    public DataSimples() {
        this(System.currentTimeMillis(), TimeZone.getDefault());
    }

    public DataSimples setTimestamp(long timestamp) {
        long dif = timestamp - this.timestamp;
        if (dif == 0L) {
            return this;
        }
        this.timestamp = timestamp;
        this.date = null;
        if (dif > 0L) {
            if ((long)this.ms + dif < 1000L) {
                this.ms = (int)((long)this.ms + dif);
                return this;
            }
            long hoje = (long)this.s * 1000L + (long)this.ms;
            if (hoje + dif < 60000L) {
                this.s = (int)((dif += hoje) / 1000L);
                this.ms = (int)(dif -= (long)this.s * 1000L);
                return this;
            }
            if ((hoje += (long)this.h * 3600000L + (long)this.m * 60000L) + dif < 86400000L) {
                this.h = (int)((dif += hoje) / 3600000L);
                this.m = (int)((dif -= (long)this.h * 3600000L) / 60000L);
                this.s = (int)((dif -= (long)this.m * 60000L) / 1000L);
                this.ms = (int)(dif -= (long)this.s * 1000L);
                return this;
            }
        }
        this.mes = 0;
        this.ano = 1970;
        timestamp += (long)this.tz.getRawOffset();
        while (timestamp >= 31536000000L) {
            ++this.ano;
            timestamp -= this.ano % 400 == 0 ? 31622400000L : (this.ano % 100 == 0 ? 31536000000L : (this.ano % 4 == 0 ? 31622400000L : 31536000000L));
        }
        DataSimples.MES_MS[1] = this.ano % 400 == 0 ? 2505600000L : (this.ano % 100 == 0 ? 2419200000L : (this.ano % 4 == 0 ? 2505600000L : 2419200000L));
        for (int i = 0; i < 12; ++i) {
            ++this.mes;
            long tstmp = MES_MS[i];
            if (timestamp < tstmp) break;
            timestamp -= tstmp;
        }
        this.dia = (int)(timestamp / 86400000L);
        ++this.dia;
        this.h = (int)((timestamp -= (long)this.dia * 86400000L) / 3600000L);
        this.m = (int)((timestamp -= (long)this.h * 3600000L) / 60000L);
        this.s = (int)((timestamp -= (long)this.m * 60000L) / 1000L);
        this.ms = (int)(timestamp -= (long)this.s * 1000L);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(22);
        sb.append(this.dia < 10 ? "0" + this.dia : Integer.valueOf(this.dia));
        sb.append('/');
        sb.append(this.mes < 10 ? "0" + this.mes : Integer.valueOf(this.mes));
        sb.append('/');
        sb.append(this.ano < 10 ? "0" + this.ano : Integer.valueOf(this.ano));
        sb.append(' ');
        sb.append(this.h < 10 ? "0" + this.h : Integer.valueOf(this.h));
        sb.append(':');
        sb.append(this.m < 10 ? "0" + this.m : Integer.valueOf(this.m));
        sb.append(':');
        sb.append(this.s < 10 ? "0" + this.s : Integer.valueOf(this.s));
        sb.append(':');
        sb.append(this.ms < 10 ? "0" + this.ms : Integer.valueOf(this.ms));
        return sb.toString();
    }

    public Date getDate() {
        if (this.date == null) {
            this.date = new Date(this.timestamp);
        }
        return this.date;
    }

    public int getDia() {
        return this.dia;
    }

    public int getMes() {
        return this.mes;
    }

    public int getAno() {
        return this.ano;
    }

    public int getHora() {
        return this.h;
    }

    public int getMinuto() {
        return this.m;
    }

    public int getSegundo() {
        return this.s;
    }

    public int getMilissegundo() {
        return this.ms;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }
}

