/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.util;

import com.joseflavio.modelo.AssistenteDeAtributo;
import java.util.HashMap;
import java.util.Map;

public class Conversor<MAPA, ATRIBUTO_A, ATRIBUTO_B> {
    private Map<ATRIBUTO_A, Ida> ida;
    private Map<ATRIBUTO_B, Volta> volta;

    public Conversor(MAPA[] lista, String original, String convertido) {
        if (lista == null || lista.length == 0) {
            throw new IllegalArgumentException("Lista vazia.");
        }
        this.ida = new HashMap<ATRIBUTO_A, Ida>(lista.length);
        this.volta = new HashMap<ATRIBUTO_B, Volta>(lista.length);
        try {
            AssistenteDeAtributo aaOriginal = new AssistenteDeAtributo(lista[0].getClass(), original);
            AssistenteDeAtributo aaConvertido = new AssistenteDeAtributo(lista[0].getClass(), convertido);
            for (MAPA m : lista) {
                Object a = aaOriginal.getMetodoGet().invoke(m, new Object[0]);
                Object b = aaConvertido.getMetodoGet().invoke(m, new Object[0]);
                this.ida.put(a, new Ida(m, b));
                this.volta.put(b, new Volta(m, a));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ATRIBUTO_B converter(ATRIBUTO_A original) {
        return (ATRIBUTO_B)this.ida.get(original).atributoB;
    }

    public ATRIBUTO_A reverter(ATRIBUTO_B convertido) {
        return (ATRIBUTO_A)this.volta.get(convertido).atributoA;
    }

    public MAPA obterMapaPeloOriginal(ATRIBUTO_A original) {
        return (MAPA)this.ida.get(original).mapa;
    }

    public MAPA obterMapaPeloConvertido(ATRIBUTO_B convertido) {
        return (MAPA)this.volta.get(convertido).mapa;
    }

    private class Volta {
        private MAPA mapa;
        private ATRIBUTO_A atributoA;

        private Volta(MAPA mapa, ATRIBUTO_A atributoA) {
            this.mapa = mapa;
            this.atributoA = atributoA;
        }
    }

    private class Ida {
        private MAPA mapa;
        private ATRIBUTO_B atributoB;

        private Ida(MAPA mapa, ATRIBUTO_B atributoB) {
            this.mapa = mapa;
            this.atributoB = atributoB;
        }
    }
}

