/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.util;

import java.util.concurrent.locks.ReentrantLock;

public class Contador {
    private long conta;
    private long limiteInferior;
    private long limiteSuperior;
    private boolean ciclico;
    private ReentrantLock trava;

    public Contador() {
        this(0L, Long.MIN_VALUE, Long.MAX_VALUE, false, false);
    }

    public Contador(long contaInicial) {
        this(contaInicial, Long.MIN_VALUE, Long.MAX_VALUE, false, false);
    }

    public Contador(long contaInicial, boolean sincronizado) {
        this(contaInicial, Long.MIN_VALUE, Long.MAX_VALUE, false, sincronizado);
    }

    public Contador(long contaInicial, boolean ciclico, boolean sincronizado) {
        this(contaInicial, Long.MIN_VALUE, Long.MAX_VALUE, ciclico, sincronizado);
    }

    public Contador(long contaInicial, long limiteInferior, long limiteSuperior, boolean ciclico, boolean sincronizado) {
        if (limiteInferior > limiteSuperior) {
            throw new IllegalArgumentException("Limite inferior maior que o superior.");
        }
        if (contaInicial < limiteInferior || contaInicial > limiteSuperior) {
            throw new IllegalArgumentException("Conta inicial fora do limite.");
        }
        this.conta = contaInicial;
        this.limiteInferior = limiteInferior;
        this.limiteSuperior = limiteSuperior;
        this.ciclico = ciclico;
        this.trava = sincronizado ? new ReentrantLock() : null;
    }

    public long incrementar() {
        if (this.trava != null) {
            this.trava.lock();
        }
        try {
            if (this.conta == this.limiteSuperior) {
                long l = this.ciclico ? (this.conta = this.limiteInferior) : this.conta;
                return l;
            }
            long l = ++this.conta;
            return l;
        }
        finally {
            if (this.trava != null) {
                this.trava.unlock();
            }
        }
    }

    public long decrementar() {
        if (this.trava != null) {
            this.trava.lock();
        }
        try {
            if (this.conta == this.limiteInferior) {
                long l = this.ciclico ? (this.conta = this.limiteSuperior) : this.conta;
                return l;
            }
            long l = --this.conta;
            return l;
        }
        finally {
            if (this.trava != null) {
                this.trava.unlock();
            }
        }
    }

    public long getConta() {
        return this.conta;
    }

    public void setConta(long conta) {
        if (this.trava != null) {
            this.trava.lock();
        }
        try {
            if (conta < this.limiteInferior || conta > this.limiteSuperior) {
                throw new IllegalArgumentException("Conta fora do limite.");
            }
            this.conta = conta;
        }
        finally {
            if (this.trava != null) {
                this.trava.unlock();
            }
        }
    }

    public long getLimiteInferior() {
        return this.limiteInferior;
    }

    public long getLimiteSuperior() {
        return this.limiteSuperior;
    }
}

