/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ClassUtil {
    public static Class<?> getInvolucro(Class<?> primitiva) {
        if (primitiva == null) {
            throw new IllegalArgumentException();
        }
        if (!primitiva.isPrimitive()) {
            return primitiva;
        }
        if (primitiva == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiva == Short.TYPE) {
            return Short.class;
        }
        if (primitiva == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiva == Long.TYPE) {
            return Long.class;
        }
        if (primitiva == Float.TYPE) {
            return Float.class;
        }
        if (primitiva == Double.TYPE) {
            return Double.class;
        }
        if (primitiva == Character.TYPE) {
            return Character.class;
        }
        if (primitiva == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new IllegalArgumentException();
    }

    public static List<Method> listarMetodos(Class<? extends Object> classe) {
        ArrayList<Method> metodos = new ArrayList<Method>();
        for (Class<? extends Object> c = classe; c != null; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                metodos.add(m);
            }
        }
        return metodos;
    }

    public static boolean isAtomica(Class<?> classe) {
        if (classe == Integer.TYPE || classe == Integer.class) {
            return true;
        }
        if (classe == Long.TYPE || classe == Long.class) {
            return true;
        }
        if (classe == Byte.TYPE || classe == Byte.class) {
            return true;
        }
        if (classe == Short.TYPE || classe == Short.class) {
            return true;
        }
        if (classe == Float.TYPE || classe == Float.class) {
            return true;
        }
        if (classe == Double.TYPE || classe == Double.class) {
            return true;
        }
        if (classe == Boolean.TYPE || classe == Boolean.class) {
            return true;
        }
        if (classe == Character.TYPE || classe == Character.class) {
            return true;
        }
        if (classe.isEnum()) {
            return true;
        }
        if (classe == String.class) {
            return true;
        }
        if (classe == Date.class) {
            return true;
        }
        return classe == Class.class;
    }
}

