/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.util;

import com.joseflavio.cultura.Cultura;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class Calendario {
    private Calendar cal;

    public Calendario(Cultura cultura) {
        Locale locale = null;
        if (cultura.equals(Cultura.NORTE_AMERICANA)) {
            locale = Locale.US;
        }
        this.cal = Calendar.getInstance(locale != null ? locale : new Locale("pt", "BR"));
    }

    public Calendario() {
        this(Cultura.getPadrao());
    }

    public Calendario setData(Date data) {
        this.cal.setTime(data);
        return this;
    }

    public Calendario setTimestamp(long ms) {
        this.cal.setTimeInMillis(ms);
        return this;
    }

    public Date getData() {
        return this.cal.getTime();
    }

    public long getTimestamp() {
        return this.cal.getTimeInMillis();
    }

    public int getDia() {
        return this.cal.get(5);
    }

    public int getMes() {
        return this.cal.get(2);
    }

    public int getMesReal() {
        return this.cal.get(2) + 1;
    }

    public int getAno() {
        return this.cal.get(1);
    }

    public int getHora() {
        return this.cal.get(11);
    }

    public int getMinuto() {
        return this.cal.get(12);
    }

    public int getSegundo() {
        return this.cal.get(13);
    }

    public Calendario setDia(int v) {
        this.cal.set(5, v);
        return this;
    }

    public Calendario setMes(int v) {
        this.cal.set(2, v);
        return this;
    }

    public Calendario setMesReal(int v) {
        this.cal.set(2, v - 1);
        return this;
    }

    public Calendario setAno(int v) {
        this.cal.set(1, v);
        return this;
    }

    public Calendario setHora(int v) {
        this.cal.set(11, v);
        return this;
    }

    public Calendario setMinuto(int v) {
        this.cal.set(12, v);
        return this;
    }

    public Calendario setSegundo(int v) {
        this.cal.set(13, v);
        return this;
    }

    public Calendario setMilissegundo(int v) {
        this.cal.set(14, v);
        return this;
    }

    public Calendario limparHorario() {
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        return this;
    }

    public Calendario maisUmMes() {
        int mes = this.getMes() + 1;
        int ano = this.getAno();
        if (mes == 12) {
            mes = 0;
            ++ano;
        }
        this.setMes(mes);
        this.setAno(ano);
        return this;
    }

    public Calendario menosUmMes() {
        int mes = this.getMes() - 1;
        int ano = this.getAno();
        if (mes == -1) {
            mes = 11;
            --ano;
        }
        this.setMes(mes);
        this.setAno(ano);
        return this;
    }

    public Calendario limpar() {
        this.cal.clear();
        return this;
    }
}

