/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.teste;

import com.joseflavio.tqc.Alerta;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Menu;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.anotacao.TQCComando;
import com.joseflavio.tqc.aplicacao.BaseInformacao;
import com.joseflavio.tqc.aplicacao.ComandoVoltar;
import com.joseflavio.tqc.aplicacao.Formulario;
import com.joseflavio.tqc.dado.Comando;
import com.joseflavio.tqc.dado.Imagem;
import com.joseflavio.tqc.dado.Texto;
import com.joseflavio.tqc.teste.TesteTQC;
import com.joseflavio.tqc.teste.TesteTQCEntidade;
import com.joseflavio.validacao.ValidacaoException;
import java.io.File;
import java.util.Date;

public class TesteTQCFormulario
extends Formulario<TesteTQC> {
    private boolean editavel = true;
    private boolean personalizado = false;

    public TesteTQCFormulario(TesteTQC teste) throws TomaraQueCaiaException {
        super(teste, teste.getTitulo(), (String)null, "Teste de Formul\u00e1rio");
        this.setPersonalizada(this.personalizado);
        ((TesteTQC)this.aplicacao).getViagemAtiva().mostrar(Alerta.novaAtencao("Aten\u00e7\u00e3o", "Favor preencher todos os campos."));
        this.construir();
    }

    @Override
    protected void antesDeMostrar(Viagem viagem) throws TomaraQueCaiaException {
        this.getComando("editavel").setRotulo(this.editavel ? "N\u00e3o Edit\u00e1vel" : "Edit\u00e1vel");
        this.getComando("personalizado").setRotulo(this.personalizado ? "N\u00e3o Personalizado" : "Personalizado");
    }

    @Override
    protected void menu() throws TomaraQueCaiaException {
        this.maisOpcaoDeMenu(this.getComando("personalizado"));
        this.maisOpcaoDeMenu(this.getComando("alerta"));
        this.maisOpcaoDeMenu(this.getComando("espera"));
        Menu a = new Menu("Aaaaaaaaaaa");
        Menu b = new Menu("Bbbbbbbbbbb");
        Menu c = new Menu("Ccccccccccc");
        a.mais(b);
        b.mais(c);
        c.mais(this.getComando("editavel"));
        this.maisOpcaoDeMenu(a);
    }

    @Override
    protected void campos() throws TomaraQueCaiaException {
        this.maisTexto("texto", TesteTQCEntidade.class, "Tomara Que Caia", true);
        this.maisInteiro("inteiro", TesteTQCEntidade.class, 21L, (Boolean)true);
        this.maisReal("real", TesteTQCEntidade.class, 21.0, true);
        this.maisData("data", TesteTQCEntidade.class, new Date(), true);
        this.maisSelecao("selecao", (Class<? extends Object>)TesteTQCEntidade.class, (T[])new String[]{null, "Op\u00e7\u00e3o 1", "Op\u00e7\u00e3o 2", "Op\u00e7\u00e3o 3", "Op\u00e7\u00e3o 4"}, (Boolean)true);
        this.maisSelecaoMultipla("selecaoMultipla", TesteTQCEntidade.class, new String[]{"Op\u00e7\u00e3o 1", "Op\u00e7\u00e3o 2", "Op\u00e7\u00e3o 3", "Op\u00e7\u00e3o 4"}, null, (Boolean)true);
        this.maisSelecionavelTexto("selecionavelTexto", TesteTQCEntidade.class, "Op\u00e7\u00e3o 1", new String[]{"Op\u00e7\u00e3o 1", "Op\u00e7\u00e3o 2", "Op\u00e7\u00e3o 3", "Op\u00e7\u00e3o 4"}, (Boolean)true);
        this.maisBruto("bruto", TesteTQCEntidade.class, null, null, true);
        this.maisArquivo("arquivo", TesteTQCEntidade.class, null, new File(((TesteTQC)this.aplicacao).getRaiz(), "tmp"), true);
        this.maisSenha("senha", TesteTQCEntidade.class, "1234", true);
        this.maisBinario("binario", TesteTQCEntidade.class, false, true);
        this.maisCampo("Imagem:", (Dado)new Imagem("imagem", "img/icone/128/globo.001.png").setTamanho(64, 64));
    }

    @TQCComando(rotulo="OK", nome="ok", ordem=1)
    public void ok(Viagem viagem, Comando comando) throws ValidacaoException, TomaraQueCaiaException {
        this.validarTudo();
        this.setMensagemInformacao("Dados validados com sucesso.");
    }

    @TQCComando(rotulo="", nome="editavel", ordem=2)
    public void editavel(Viagem viagem, Comando comando) throws ValidacaoException, TomaraQueCaiaException {
        this.editavel = !this.editavel;
        this.setEditavel("texto", this.editavel);
        this.setEditavel("inteiro", this.editavel);
        this.setEditavel("real", this.editavel);
        this.setEditavel("data", this.editavel);
        this.setEditavel("selecao", this.editavel);
        this.setEditavel("selecaoMultipla", this.editavel);
        this.setEditavel("selecionavelTexto", this.editavel);
        this.setEditavel("bruto", this.editavel);
        this.setEditavel("arquivo", this.editavel);
        this.setEditavel("senha", this.editavel);
        this.setEditavel("binario", this.editavel);
    }

    @TQCComando(rotulo="", nome="personalizado", ordem=3)
    public void personalizado(Viagem viagem, Comando comando) throws ValidacaoException, TomaraQueCaiaException {
        this.personalizado = !this.personalizado;
        this.setPersonalizada(this.personalizado);
    }

    @TQCComando(rotulo="Sair", nome="sair", imagem="img/iconep/remover.png", funcao=Comando.Funcao.CANCELAR)
    public void sair(Viagem viagem, Comando comando) throws ValidacaoException, TomaraQueCaiaException {
        ((TesteTQC)this.aplicacao).encerrarViagens();
    }

    @TQCComando(rotulo="Teste de Alerta", nome="alerta", adicionar=false)
    public void alerta(Viagem viagem, Comando comando) throws ValidacaoException, TomaraQueCaiaException {
        viagem.mostrar(Alerta.novaInformacao(((TesteTQC)this.aplicacao).getTitulo(), "Teste de Alerta!"));
    }

    @TQCComando(rotulo="Teste de Espera", nome="espera", adicionar=false)
    public void espera(Viagem viagem, Comando comando) throws ValidacaoException, TomaraQueCaiaException {
        try {
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public BaseInformacao<TesteTQC> criarAjuda(TesteTQC aplicacao) throws TomaraQueCaiaException {
        BaseInformacao<TesteTQC> ajuda = new BaseInformacao<TesteTQC>(aplicacao, this.getTitulo(), "Ajuda"){
            {
                this.mais(new Texto("Ajuda sobre a tela '" + TesteTQCFormulario.this.getTitulo() + "'."));
                this.maisEspacoTextual();
                this.mais(new ComandoVoltar("Voltar"));
            }

            @Override
            protected void acao(Viagem viagem, Comando comando) throws ValidacaoException, TomaraQueCaiaException {
            }
        };
        return ajuda;
    }

    @Override
    public boolean possuiAjuda() {
        return true;
    }
}

