/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.teste;

import com.joseflavio.modelo.JFApresentacao;
import com.joseflavio.modelo.JFData;
import com.joseflavio.modelo.JFInteiro;
import com.joseflavio.modelo.JFReal;
import com.joseflavio.modelo.JFTexto;
import com.joseflavio.modelo.JFValidacaoNaoNulo;
import com.joseflavio.modelo.JFValidacaoNaoVazio;
import com.joseflavio.modelo.JFValidacaoPrimitiva;
import com.joseflavio.modelo.JFValidacaoTamanhoLimite;
import com.joseflavio.modelo.JFValidacaoValorLimite;
import com.joseflavio.tqc.aplicacao.AplicacaoTQC_JPA;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

@JFApresentacao(value="Entidade")
@Entity
public class TesteTQCEntidade {
    @JFApresentacao(value="Id")
    @JFInteiro
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    private Long id;
    @JFApresentacao(value="Texto")
    @JFTexto(largura=30, max=30)
    @JFValidacaoPrimitiva(erro="Informe corretamente o texto.")
    @JFValidacaoNaoVazio(erro="Informe o texto.")
    @JFValidacaoTamanhoLimite(erro="O texto deve conter no m\u00e1ximo 30 caracteres.")
    private String texto = null;
    @JFApresentacao(value="Inteiro")
    @JFInteiro(min=10L, max=50L)
    @JFTexto(largura=15)
    @JFValidacaoPrimitiva(erro="Informe corretamente o inteiro.")
    @JFValidacaoNaoNulo(erro="Informe o inteiro.")
    @JFValidacaoValorLimite(erro="O inteiro deve ser um valor entre 10 e 50 (inclusive).")
    private long inteiro = 0L;
    @JFApresentacao(value="Real")
    @JFReal(min=10.5, max=50.63, maxFracao=4)
    @JFTexto(largura=15)
    @JFValidacaoPrimitiva(erro="Informe corretamente o real.")
    @JFValidacaoNaoNulo(erro="Informe o real.")
    @JFValidacaoValorLimite(erro="O real deve ser um valor entre 10,5 e 50,63 (inclusive).")
    private double real = 0.0;
    @JFApresentacao(value="Data")
    @JFData(tipo=JFData.DataTipo.DATA)
    @JFTexto(largura=15)
    @JFValidacaoPrimitiva(erro="Informe corretamente a data.")
    @JFValidacaoNaoNulo(erro="Informe a data.")
    private Date data = null;
    @JFApresentacao(value="Sele\u00e7\u00e3o")
    @JFValidacaoPrimitiva(erro="Informe corretamente a sele\u00e7\u00e3o.")
    @JFValidacaoNaoNulo(erro="Informe a sele\u00e7\u00e3o.")
    private String selecao = null;
    @JFApresentacao(value="Selecion\u00e1vel Texto")
    @JFTexto(largura=30, max=30)
    @JFValidacaoPrimitiva(erro="Informe corretamente o selecion\u00e1vel texto.")
    @JFValidacaoNaoVazio(erro="Informe o selecion\u00e1vel texto.")
    @JFValidacaoTamanhoLimite(erro="O selecion\u00e1vel texto deve conter no m\u00e1ximo 30 caracteres.")
    private String selecionavelTexto = null;
    @JFApresentacao(value="Sele\u00e7\u00e3o M\u00faltipla")
    @JFValidacaoPrimitiva(erro="Escolha corretamente na sele\u00e7\u00e3o m\u00faltipla.")
    @JFValidacaoNaoVazio(erro="Escolha na sele\u00e7\u00e3o m\u00faltipla.")
    private String[] selecaoMultipla = null;
    @JFApresentacao(value="Bruto")
    @JFValidacaoPrimitiva(erro="Informe corretamente o bruto.")
    @JFValidacaoNaoNulo(erro="Informe o bruto.")
    private byte[] bruto = null;
    @JFApresentacao(value="Arquivo")
    @JFValidacaoPrimitiva(erro="Informe corretamente o arquivo.")
    @JFValidacaoNaoNulo(erro="Informe o arquivo.")
    private File arquivo = null;
    @JFApresentacao(value="Senha")
    @JFTexto(largura=15, max=15)
    @JFValidacaoPrimitiva(erro="Informe corretamente a senha.")
    @JFValidacaoNaoVazio(erro="Informe a senha.")
    @JFValidacaoTamanhoLimite(erro="A senha deve conter no m\u00e1ximo 15 caracteres.")
    private String senha = null;
    @JFApresentacao(value="Bin\u00e1rio")
    private boolean binario = false;

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TesteTQCEntidade)) {
            return false;
        }
        TesteTQCEntidade o = (TesteTQCEntidade)obj;
        return this.id == o.id || this.id != null && o.id != null && this.id.equals(o.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.texto;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTexto() {
        return this.texto;
    }

    public void setTexto(String texto) {
        this.texto = texto;
    }

    public long getInteiro() {
        return this.inteiro;
    }

    public void setInteiro(long inteiro) {
        this.inteiro = inteiro;
    }

    public double getReal() {
        return this.real;
    }

    public void setReal(double real) {
        this.real = real;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public String getSelecao() {
        return this.selecao;
    }

    public void setSelecao(String selecao) {
        this.selecao = selecao;
    }

    public String getSelecionavelTexto() {
        return this.selecionavelTexto;
    }

    public void setSelecionavelTexto(String selecionavelTexto) {
        this.selecionavelTexto = selecionavelTexto;
    }

    public String[] getSelecaoMultipla() {
        return this.selecaoMultipla;
    }

    public void setSelecaoMultipla(String[] selecaoMultipla) {
        this.selecaoMultipla = selecaoMultipla;
    }

    public byte[] getBruto() {
        return this.bruto;
    }

    public void setBruto(byte[] bruto) {
        this.bruto = bruto;
    }

    public File getArquivo() {
        return this.arquivo;
    }

    public void setArquivo(File arquivo) {
        this.arquivo = arquivo;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public boolean isBinario() {
        return this.binario;
    }

    public void setBinario(boolean binario) {
        this.binario = binario;
    }

    public static TesteTQCEntidade obter(AplicacaoTQC_JPA aplicacao, Long id) {
        return (TesteTQCEntidade)aplicacao.obter("select o from TesteTQCEntidade o where o.id = :p0", id);
    }

    public static List<TesteTQCEntidade> listar(AplicacaoTQC_JPA aplicacao) {
        return aplicacao.listar("select o from TesteTQCEntidade o order by o.texto asc", new Object[0]);
    }
}

