/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.AnexoControleDeFoco;
import com.joseflavio.tqc.AnexoRolagem;
import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Edicao;
import com.joseflavio.tqc.EspacoLateral;
import com.joseflavio.tqc.EspacoTextual;
import com.joseflavio.tqc.EstiloFonte;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.Menu;
import com.joseflavio.tqc.OpcaoDeMenu;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.aplicacao.ComandoImplementado;
import com.joseflavio.tqc.aplicacao.Formulario;
import com.joseflavio.tqc.aplicacao.Listagem;
import com.joseflavio.tqc.dado.Arquivo;
import com.joseflavio.tqc.dado.Binario;
import com.joseflavio.tqc.dado.Bruto;
import com.joseflavio.tqc.dado.Comando;
import com.joseflavio.tqc.dado.Data;
import com.joseflavio.tqc.dado.Imagem;
import com.joseflavio.tqc.dado.Inteiro;
import com.joseflavio.tqc.dado.Linha;
import com.joseflavio.tqc.dado.LinhaFim;
import com.joseflavio.tqc.dado.Marcador;
import com.joseflavio.tqc.dado.Nativo;
import com.joseflavio.tqc.dado.Objeto;
import com.joseflavio.tqc.dado.QuebraDeLinha;
import com.joseflavio.tqc.dado.Real;
import com.joseflavio.tqc.dado.Selecao;
import com.joseflavio.tqc.dado.SelecaoMultipla;
import com.joseflavio.tqc.dado.SelecionavelTexto;
import com.joseflavio.tqc.dado.Senha;
import com.joseflavio.tqc.dado.Tabela;
import com.joseflavio.tqc.dado.TabelaColuna;
import com.joseflavio.tqc.dado.TabelaColunaFim;
import com.joseflavio.tqc.dado.TabelaFim;
import com.joseflavio.tqc.dado.TabelaLinha;
import com.joseflavio.tqc.dado.TabelaLinhaFim;
import com.joseflavio.tqc.dado.Texto;
import com.joseflavio.tqc.servlet.AlertaImpressao;
import com.joseflavio.tqc.servlet.ArquivoControle;
import com.joseflavio.tqc.servlet.BinarioControle;
import com.joseflavio.tqc.servlet.BrutoControle;
import com.joseflavio.tqc.servlet.ComandoControle;
import com.joseflavio.tqc.servlet.ControleImpressao;
import com.joseflavio.tqc.servlet.DadoControle;
import com.joseflavio.tqc.servlet.DataControle;
import com.joseflavio.tqc.servlet.IdentificacaoImpressao;
import com.joseflavio.tqc.servlet.ImagemControle;
import com.joseflavio.tqc.servlet.InteiroControle;
import com.joseflavio.tqc.servlet.NativoControle;
import com.joseflavio.tqc.servlet.ObjetoControle;
import com.joseflavio.tqc.servlet.RealControle;
import com.joseflavio.tqc.servlet.SelecaoControle;
import com.joseflavio.tqc.servlet.SelecaoMultiplaControle;
import com.joseflavio.tqc.servlet.SelecionavelTextoControle;
import com.joseflavio.tqc.servlet.SenhaControle;
import com.joseflavio.tqc.servlet.TextoControle;
import com.joseflavio.tqc.servlet.TomaraQueCaiaDesktopServlet;
import com.joseflavio.util.Lista;
import com.joseflavio.validacao.ValidacaoException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.Semaphore;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

class TomaraQueCaiaProcesso {
    Semaphore semaforo = new Semaphore(1);
    private Viagem viagem;
    private Informacao info;
    private Dado dado;
    private Comando comando;
    private DadoControle controle;
    private int totalViagens;
    private int totalDados;
    private TextoControle textoControle;
    private SelecionavelTextoControle selecionavelTextoControle;
    private InteiroControle inteiroControle;
    private RealControle realControle;
    private DataControle dataControle;
    private SelecaoControle selecaoControle;
    private SelecaoMultiplaControle selecaoMultiplaControle;
    private ComandoControle comandoControle;
    private ObjetoControle objetoControle;
    private ImagemControle imagemControle;
    private SenhaControle senhaControle;
    private BinarioControle binarioControle;
    private BrutoControle brutoControle;
    private ArquivoControle arquivoControle;
    private NativoControle nativoControle;

    TomaraQueCaiaProcesso() {
    }

    void processar(TomaraQueCaia tqc, HttpServletRequest req, HttpServletResponse resp, HttpSession sessao, ServletContext servletContext, PrintWriter saida) throws TomaraQueCaiaException, ValidacaoException, ServletException, IOException {
        String pele;
        Informacao tmpInfo;
        int i;
        int indiceE;
        if (this.isEncerrada(tqc)) {
            this.encerrar(tqc, resp, sessao, saida, true);
            return;
        }
        if (!this.filtrar(tqc, resp, sessao, saida)) {
            return;
        }
        String informacaoNome = req.getParameter("informacaoTQC");
        if ((this.viagem.getNome() + "@" + this.info.getClass().getName() + "@" + this.viagem.getPasso()).equals(informacaoNome)) {
            try {
                AnexoRolagem rolagem = this.info.getAnexo(AnexoRolagem.class, true);
                rolagem.setHorizontal(new Integer(req.getParameter("rolagemHorizontal")));
                rolagem.setVertical(new Integer(req.getParameter("rolagemVertical")));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                AnexoControleDeFoco foco = this.info.getAnexo(AnexoControleDeFoco.class, true);
                foco.setElemento(req.getParameter("focoDado"));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.comando = null;
            this.totalDados = this.info.getTotalDados();
            for (int d = 0; d < this.totalDados; ++d) {
                Object paramValor;
                this.dado = this.info.getDado(d);
                this.controle = this.getControle(this.dado);
                if (this.controle == null) continue;
                String paramId = "dado" + d;
                if (this.controle.isTransformacaoMultipla()) {
                    String[] paramArray = req.getParameterValues(paramId);
                    if (paramArray == null || paramArray.length == 0) {
                        paramValor = req.getParameter(paramId);
                        if (paramValor != null) {
                            paramValor = paramValor.toString().split("_///_");
                        }
                    } else if (paramArray[0].equals("TQC#SELECAOMULTIPLA")) {
                        int totalValores = Integer.parseInt(req.getParameter(paramId + "_total"));
                        Lista<String> valores = new Lista<String>(totalValores);
                        for (int i2 = 0; i2 < totalValores; ++i2) {
                            String valor = req.getParameter(paramId + "_" + i2);
                            if (valor == null || !valor.equals("v")) continue;
                            valores.add("" + i2);
                        }
                        paramValor = valores.toArray(new String[valores.size()]);
                    } else {
                        paramValor = paramArray;
                    }
                } else {
                    paramValor = req.getParameter(paramId);
                    if (paramValor == null) {
                        paramValor = req.getParameter(paramId + ".x");
                    }
                }
                this.controle.redirecionar(req, resp, tqc, this.viagem, this.info, this.dado, paramId);
                if (this.dado instanceof Comando) {
                    if (paramValor == null) continue;
                    this.comando = (Comando)this.dado;
                    continue;
                }
                if (paramValor == null && (!(this.dado instanceof Edicao) || !((Edicao)((Object)this.dado)).isEditavel())) continue;
                if (this.controle.isTransformacaoMultipla()) {
                    this.controle.transformar(req, tqc, (String[])paramValor, this.dado);
                    continue;
                }
                this.controle.transformar(req, tqc, (String)paramValor, this.dado);
            }
            if (this.comando != null && this.comando.isVisivel()) {
                this.info.acao(tqc, this.viagem, this.comando);
            }
        }
        if (resp.isCommitted()) {
            return;
        }
        if (this.isEncerrada(tqc)) {
            this.encerrar(tqc, resp, sessao, saida, true);
            return;
        }
        String comandoViagem = req.getParameter("comandoViagem");
        if (comandoViagem == null) {
            comandoViagem = "";
        }
        if (comandoViagem.startsWith("confirmar")) {
            Dado alvo;
            boolean buscarComando = true;
            int alvoIndice = -1;
            int indiceE2 = comandoViagem.indexOf(64);
            if (indiceE2 > -1 && indiceE2 < comandoViagem.length() - 1) {
                try {
                    alvoIndice = Integer.parseInt(comandoViagem.substring(indiceE2 + 1 + "dado".length()));
                }
                catch (NumberFormatException e) {
                    alvoIndice = -1;
                }
            }
            Dado dado = alvo = alvoIndice != -1 ? this.info.getDado(alvoIndice) : null;
            if (alvo != null) {
                Comando comandoAuxiliar;
                if (alvo instanceof Comando && alvo.isVisivel()) {
                    buscarComando = false;
                    this.info.acao(tqc, this.viagem, (Comando)alvo);
                } else if (alvo instanceof ComplexoDado && ((ComplexoDado)alvo).getComando() != null && (comandoAuxiliar = ((ComplexoDado)alvo).getComando()).isVisivel()) {
                    if (this.info.contem(comandoAuxiliar)) {
                        buscarComando = false;
                        this.info.acao(tqc, this.viagem, comandoAuxiliar);
                    } else if (comandoAuxiliar instanceof ComandoImplementado) {
                        buscarComando = false;
                        ((ComandoImplementado)comandoAuxiliar).acao(this.viagem);
                    }
                }
            }
            if (buscarComando) {
                Comando comando = null;
                Dado primeiro = null;
                int buscaI = 0;
                int buscaF = this.info.getTotalDados() - 1;
                if (alvo != null) {
                    buscaI = this.info.getIndice(alvo) + 1;
                }
                while (buscaI <= buscaF) {
                    Dado dado2 = this.info.getDado(buscaI);
                    if (dado2 instanceof Comando) {
                        comando = (Comando)dado2;
                        if (primeiro == null) {
                            primeiro = comando;
                        }
                        if (comando.getFuncaoTipo() == Comando.Funcao.CONFIRMAR && comando.isVisivel()) break;
                        comando = null;
                    }
                    ++buscaI;
                }
                if (comando != null) {
                    this.info.acao(tqc, this.viagem, comando);
                } else if (primeiro != null && primeiro.isVisivel()) {
                    this.info.acao(tqc, this.viagem, (Comando)primeiro);
                }
            }
        } else if (comandoViagem.startsWith("cancelar")) {
            boolean cancelada = false;
            for (Comando comando : this.info.getDados(Comando.class)) {
                if (comando.getFuncaoTipo() != Comando.Funcao.CANCELAR || !comando.isVisivel()) continue;
                cancelada = true;
                this.info.acao(tqc, this.viagem, comando);
                break;
            }
            if (!cancelada) {
                this.info.sair(this.viagem);
            }
        } else if (comandoViagem.startsWith("avancar")) {
            for (Comando comando : this.info.getDados(Comando.class)) {
                if (comando.getFuncaoTipo() != Comando.Funcao.AVANCAR || !comando.isVisivel()) continue;
                this.info.acao(tqc, this.viagem, comando);
                break;
            }
        } else if (comandoViagem.startsWith("voltar")) {
            for (Comando comando : this.info.getDados(Comando.class)) {
                if (comando.getFuncaoTipo() != Comando.Funcao.VOLTAR || !comando.isVisivel()) continue;
                this.info.acao(tqc, this.viagem, comando);
                break;
            }
        } else if (comandoViagem.startsWith("comando")) {
            Comando comando;
            String comandoNome = null;
            indiceE = comandoViagem.indexOf(64);
            if (indiceE > -1 && indiceE < comandoViagem.length() - 1) {
                comandoNome = comandoViagem.substring(indiceE + 1);
            }
            if (comandoNome != null && (comando = this.info.getComando(comandoNome)) != null && comando.isVisivel()) {
                this.info.acao(tqc, this.viagem, comando);
            }
        } else if (comandoViagem.startsWith("menu")) {
            OpcaoDeMenu om;
            Menu menu;
            String identificacao = null;
            indiceE = comandoViagem.indexOf(64);
            if (indiceE > -1 && indiceE < comandoViagem.length() - 1) {
                identificacao = comandoViagem.substring(indiceE + 1);
            }
            if (identificacao != null && (menu = this.info.getMenu()) != null && (om = menu.getOpcaoDeMenu(identificacao)) != null && om instanceof Comando) {
                this.info.acao(tqc, this.viagem, (Comando)om);
            }
        } else {
            Informacao ajuda;
            if (comandoViagem.equals("encerrarAplicacao")) {
                this.encerrar(tqc, resp, sessao, saida, true);
                return;
            }
            if (comandoViagem.equals("mostrarAjuda") && (ajuda = this.info.criarAjuda(tqc)) != null) {
                this.viagem.visitar(ajuda);
            }
        }
        if (this.isEncerrada(tqc)) {
            this.encerrar(tqc, resp, sessao, saida, true);
            return;
        }
        this.totalViagens = tqc.getTotalViagens();
        for (i = 0; i < this.totalViagens; ++i) {
            this.viagem = tqc.getViagem(i);
            String comandoEsperado = "fechar_" + this.viagem.getNome();
            if (req.getParameter(comandoEsperado) == null && !comandoViagem.equals(comandoEsperado)) continue;
            this.viagem.encerrar();
            if (this.totalViagens != 1) break;
            this.encerrar(tqc, resp, sessao, saida, true);
            return;
        }
        this.totalViagens = tqc.getTotalViagens();
        for (i = 0; i < this.totalViagens; ++i) {
            this.viagem = tqc.getViagem(i);
            String comandoEsperado = "irpara_" + this.viagem.getNome();
            if (req.getParameter(comandoEsperado) == null && !comandoViagem.equals(comandoEsperado)) continue;
            this.viagem.ativar();
            break;
        }
        do {
            if (!this.filtrar(tqc, resp, sessao, saida)) {
                return;
            }
            tmpInfo = this.info;
            if (this.antesDeMostrar(tqc, resp, sessao, saida)) continue;
            return;
        } while (tmpInfo != this.info);
        if (this.isEncerrada(tqc)) {
            this.encerrar(tqc, resp, sessao, saida, true);
            return;
        }
        if (this.info.isPersonalizada()) {
            String jsp = this.info.getPersonalizadaInterface();
            if (jsp == null) {
                String pacote = this.info.getClass().getPackage().getName();
                jsp = (pacote != null && pacote.length() > 0 ? pacote + "/" : "") + this.info.getClass().getSimpleName();
            }
            jsp = "jsp/" + jsp + ".jsp";
            if (servletContext.getResource("/" + jsp) != null) {
                resp.sendRedirect(jsp + "?tqc=" + tqc.getClass().getName());
                tqc.informacaoMostrada(this.viagem, this.info);
                return;
            }
        }
        String string = pele = this.info.getPele() != null ? this.info.getPele() : tqc.getPele();
        if (this.info instanceof Formulario && servletContext.getResource("/" + pele + "/Formulario.jsp") != null) {
            resp.sendRedirect(pele + "/Formulario.jsp?tqc=" + tqc.getClass().getName());
            tqc.informacaoMostrada(this.viagem, this.info);
            return;
        }
        if (this.info instanceof Listagem && servletContext.getResource("/" + pele + "/Listagem.jsp") != null) {
            resp.sendRedirect(pele + "/Listagem.jsp?tqc=" + tqc.getClass().getName());
            tqc.informacaoMostrada(this.viagem, this.info);
            return;
        }
        if (servletContext.getResource("/" + pele + "/Informacao.jsp") != null) {
            resp.sendRedirect(pele + "/Informacao.jsp?tqc=" + tqc.getClass().getName());
            tqc.informacaoMostrada(this.viagem, this.info);
            return;
        }
        saida.write("<!DOCTYPE html>\n");
        saida.write("<html>\n");
        saida.write("<head>\n");
        saida.write("<title>" + tqc.getTitulo() + "</title>\n");
        saida.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\" />\n");
        saida.write("<link href=\"css/tqc.css\" rel=\"stylesheet\" type=\"text/css\" />\n");
        EstiloFonte[] estiloFontes = tqc.listarEstiloFontes();
        for (int i3 = 0; i3 < estiloFontes.length; ++i3) {
            saida.write("<link href=\"css/" + estiloFontes[i3].getNome() + ".css\" rel=\"stylesheet\" type=\"text/css\" />\n");
        }
        saida.write("<script type=\"text/javascript\" src=\"script/dado.js\"></script>\n");
        saida.write("</head>\n");
        AlertaImpressao.imprimir(this.viagem.removerAlerta(), saida);
        saida.write("<body class=\"fundoGeral\">\n");
        saida.write("<form id=\"formTQC\" name=\"formTQC\" method=\"POST\">\n");
        IdentificacaoImpressao.imprimir(this.viagem, this.info, saida);
        saida.write("\n");
        ControleImpressao.imprimir(tqc, saida);
        saida.write("<div class=\"fundoAplicacao\">\n");
        this.totalDados = this.info.getTotalDados();
        Dado ultimoDado = null;
        for (int d = 0; d < this.totalDados; ++d) {
            this.dado = this.info.getDado(d);
            if (!this.dado.isVisivel()) continue;
            if (this.dado instanceof Linha) {
                this.imprimir((Linha)this.dado, ultimoDado, saida);
            } else if (this.dado instanceof LinhaFim) {
                saida.write("</div>\n");
            } else if (this.dado instanceof QuebraDeLinha) {
                saida.write("<br>");
            } else if (this.dado instanceof Tabela) {
                this.imprimir((Tabela)this.dado, saida);
            } else if (this.dado instanceof TabelaLinha) {
                this.imprimir((TabelaLinha)this.dado, saida);
            } else if (this.dado instanceof TabelaColuna) {
                this.imprimir((TabelaColuna)this.dado, saida);
            } else if (this.dado instanceof TabelaColunaFim) {
                saida.write("</td>\n");
            } else if (this.dado instanceof TabelaLinhaFim) {
                saida.write("</tr>\n");
            } else if (this.dado instanceof TabelaFim) {
                saida.write("</table>\n");
            } else if (!(this.dado instanceof Marcador)) {
                if (this.dado instanceof EspacoTextual) {
                    int quant = ((EspacoTextual)this.dado).getQuantidade();
                    for (int i4 = 0; i4 < quant; ++i4) {
                        saida.write("&nbsp;");
                    }
                } else {
                    this.controle = this.getControle(this.dado);
                    if (this.controle != null) {
                        this.controle.imprimir(req, tqc, this.viagem, this.info, this.dado, "dado" + d, saida);
                    }
                }
            }
            if (this.dado instanceof EspacoLateral && ((EspacoLateral)((Object)this.dado)).isEspacoTextualPosterior()) {
                saida.write("&nbsp;");
            }
            if (this.dado instanceof Marcador) continue;
            ultimoDado = this.dado;
        }
        saida.write("</div>\n");
        saida.write("</form>\n");
        saida.write("</body>\n");
        saida.write("</html>\n");
        tqc.informacaoMostrada(this.viagem, this.info);
    }

    private boolean filtrar(TomaraQueCaia tqc, HttpServletResponse resp, HttpSession sessao, PrintWriter saida) throws TomaraQueCaiaException, ServletException, IOException {
        return this.processarEventos(tqc, resp, sessao, saida, true, false);
    }

    private boolean antesDeMostrar(TomaraQueCaia tqc, HttpServletResponse resp, HttpSession sessao, PrintWriter saida) throws TomaraQueCaiaException, ServletException, IOException {
        return this.processarEventos(tqc, resp, sessao, saida, false, true);
    }

    private boolean processarEventos(TomaraQueCaia tqc, HttpServletResponse resp, HttpSession sessao, PrintWriter saida, boolean filtragem, boolean antesDeMostrar) throws TomaraQueCaiaException, ServletException, IOException {
        if (tqc.isAutoEncerrarViagensVazias()) {
            tqc.encerrarViagensVazias();
        }
        this.viagem = tqc.getViagemAtiva();
        if (this.viagem == null) {
            this.encerrar(tqc, resp, sessao, saida, true);
            return false;
        }
        do {
            this.info = this.viagem.getAtual();
            if (this.info == null) {
                return false;
            }
            if (filtragem && !tqc.filtrar(this.viagem)) {
                tqc.permissaoNegada(this.viagem, this.info);
            }
            if (antesDeMostrar) {
                this.info.antesDeMostrar(tqc, this.viagem);
            }
            if (!filtragem && !antesDeMostrar) continue;
            if (tqc.isAutoEncerrarViagensVazias()) {
                tqc.encerrarViagensVazias();
            }
            this.viagem = tqc.getViagemAtiva();
            if (this.viagem != null) continue;
            this.encerrar(tqc, resp, sessao, saida, true);
            return false;
        } while (this.info != this.viagem.getAtual());
        return true;
    }

    private boolean isEncerrada(TomaraQueCaia tqc) {
        return tqc.isEncerrada() || tqc.getTotalViagens() == 0 || tqc.getViagemAtiva() == null;
    }

    void encerrar(TomaraQueCaia tqc, HttpServletResponse resp, HttpSession sessao, PrintWriter saida, boolean imprimirPaginaFinal) throws ServletException, IOException {
        String tqcClassName = tqc.getClass().getName();
        String pele = tqc.getPele();
        sessao.removeAttribute("tqc_" + tqcClassName);
        sessao.removeAttribute("tqc_url_" + tqcClassName);
        sessao.removeAttribute("tqc_query_" + tqcClassName);
        sessao.removeAttribute("tqc_proc_" + tqcClassName);
        if (!sessao.getAttributeNames().hasMoreElements()) {
            sessao.invalidate();
        }
        if (!this.isEncerrada(tqc)) {
            tqc.encerrar();
        }
        if (imprimirPaginaFinal) {
            resp.sendRedirect((pele != null ? pele : "padrao") + "/Fim.jsp?tqc=" + tqcClassName);
        }
    }

    private boolean fimDeLinha(Dado dado) {
        if (dado == null) {
            return false;
        }
        return dado instanceof QuebraDeLinha || dado instanceof LinhaFim;
    }

    private void imprimir(Linha dado, Dado anterior, PrintWriter saida) throws ValidacaoException, IOException {
        if (anterior != null && !this.fimDeLinha(anterior)) {
            saida.write("<br>\n");
        }
        saida.write("<div");
        TomaraQueCaiaDesktopServlet.imprimirEstilo(dado, null, saida);
        saida.write(">");
    }

    private void imprimir(Tabela dado, PrintWriter saida) throws ValidacaoException, IOException {
        saida.write("<table cellspacing=\"2\" cellpadding=\"2\"");
        TomaraQueCaiaDesktopServlet.imprimirEstilo(dado, "dadoTabela", saida);
        saida.write(">\n");
    }

    private void imprimir(TabelaLinha dado, PrintWriter saida) throws ValidacaoException, IOException {
        saida.write("<tr");
        TomaraQueCaiaDesktopServlet.imprimirEstilo(dado, null, saida);
        saida.write(">\n");
    }

    private void imprimir(TabelaColuna dado, PrintWriter saida) throws ValidacaoException, IOException {
        saida.write("<td");
        TomaraQueCaiaDesktopServlet.imprimirEstilo(dado, null, saida);
        saida.write(">");
    }

    DadoControle getControle(Dado dado) {
        if (dado instanceof Texto) {
            if (this.textoControle == null) {
                this.textoControle = new TextoControle();
            }
            return this.textoControle;
        }
        if (dado instanceof SelecionavelTexto) {
            if (this.selecionavelTextoControle == null) {
                this.selecionavelTextoControle = new SelecionavelTextoControle();
            }
            return this.selecionavelTextoControle;
        }
        if (dado instanceof Comando) {
            if (this.comandoControle == null) {
                this.comandoControle = new ComandoControle();
            }
            return this.comandoControle;
        }
        if (dado instanceof Inteiro) {
            if (this.inteiroControle == null) {
                this.inteiroControle = new InteiroControle();
            }
            return this.inteiroControle;
        }
        if (dado instanceof Real) {
            if (this.realControle == null) {
                this.realControle = new RealControle();
            }
            return this.realControle;
        }
        if (dado instanceof Data) {
            if (this.dataControle == null) {
                this.dataControle = new DataControle();
            }
            return this.dataControle;
        }
        if (dado instanceof Selecao) {
            if (this.selecaoControle == null) {
                this.selecaoControle = new SelecaoControle();
            }
            return this.selecaoControle;
        }
        if (dado instanceof SelecaoMultipla) {
            if (this.selecaoMultiplaControle == null) {
                this.selecaoMultiplaControle = new SelecaoMultiplaControle();
            }
            return this.selecaoMultiplaControle;
        }
        if (dado instanceof Objeto) {
            if (this.objetoControle == null) {
                this.objetoControle = new ObjetoControle();
            }
            return this.objetoControle;
        }
        if (dado instanceof Imagem) {
            if (this.imagemControle == null) {
                this.imagemControle = new ImagemControle();
            }
            return this.imagemControle;
        }
        if (dado instanceof Senha) {
            if (this.senhaControle == null) {
                this.senhaControle = new SenhaControle();
            }
            return this.senhaControle;
        }
        if (dado instanceof Binario) {
            if (this.binarioControle == null) {
                this.binarioControle = new BinarioControle();
            }
            return this.binarioControle;
        }
        if (dado instanceof Bruto) {
            if (this.brutoControle == null) {
                this.brutoControle = new BrutoControle();
            }
            return this.brutoControle;
        }
        if (dado instanceof Arquivo) {
            if (this.arquivoControle == null) {
                this.arquivoControle = new ArquivoControle();
            }
            return this.arquivoControle;
        }
        if (dado instanceof Nativo) {
            if (this.nativoControle == null) {
                this.nativoControle = new NativoControle();
            }
            return this.nativoControle;
        }
        return null;
    }
}

