/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.Estilo;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.ValidavelDado;
import com.joseflavio.tqc.aplicacao.AplicacaoTQC;
import com.joseflavio.tqc.servlet.Bilhete;
import com.joseflavio.tqc.servlet.TomaraQueCaiaProcesso;
import com.joseflavio.validacao.TextoLimite;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class TomaraQueCaiaDesktopServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PREFIXO_TQC_SESSAO = "tqc_";
    public static final String PREFIXO_TQC_URL = "tqc_url_";
    public static final String PREFIXO_TQC_QUERY = "tqc_query_";
    public static final String PREFIXO_TQC_PROCESSO = "tqc_proc_";
    public static final String PREFIXO_TQC_BILHETE = "tqc_bilhete_";
    public static final String PREFIXO_DADO = "dado";
    public static final String PREFIXO_PARAMETRO = "tqc";
    private Class<? extends TomaraQueCaia> tqcClasse;
    private String tqcClasseName;

    public TomaraQueCaiaDesktopServlet(Class<? extends TomaraQueCaia> tqcClasse) {
        this.tqcClasse = tqcClasse;
        this.tqcClasseName = tqcClasse.getName();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html; charset=iso-8859-1");
        HttpSession sessao = req.getSession(true);
        PrintWriter saida = resp.getWriter();
        TomaraQueCaia tqc = (TomaraQueCaia)sessao.getAttribute(PREFIXO_TQC_SESSAO + this.tqcClasseName);
        TomaraQueCaiaProcesso proc = (TomaraQueCaiaProcesso)sessao.getAttribute(PREFIXO_TQC_PROCESSO + this.tqcClasseName);
        String query = (String)sessao.getAttribute(PREFIXO_TQC_QUERY + this.tqcClasseName);
        String queryAtual = req.getQueryString();
        if (tqc == null) {
            try {
                tqc = this.tqcClasse.newInstance();
                tqc.setRaiz(new File(this.getServletContext().getRealPath("/")));
                HashMap<String, String> parametros = new HashMap<String, String>();
                Enumeration parameterNames = req.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String chave = (String)parameterNames.nextElement();
                    if (!chave.startsWith(PREFIXO_PARAMETRO)) continue;
                    parametros.put(chave.substring(PREFIXO_PARAMETRO.length()), req.getParameter(chave));
                }
                proc = new TomaraQueCaiaProcesso();
                tqc.inicio(parametros);
                String url = req.getRequestURL() + (queryAtual != null && queryAtual.length() > 0 ? "?" + queryAtual : "");
                String banner = tqc instanceof AplicacaoTQC ? ((AplicacaoTQC)tqc).getBanner() : null;
                sessao.setAttribute(PREFIXO_TQC_SESSAO + this.tqcClasseName, (Object)tqc);
                sessao.setAttribute(PREFIXO_TQC_URL + this.tqcClasseName, (Object)url);
                sessao.setAttribute(PREFIXO_TQC_QUERY + this.tqcClasseName, (Object)queryAtual);
                sessao.setAttribute(PREFIXO_TQC_PROCESSO + this.tqcClasseName, (Object)proc);
                sessao.setAttribute(PREFIXO_TQC_BILHETE + this.tqcClasseName, (Object)new Bilhete(url, tqc.getTitulo(), banner));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else if (!(query == queryAtual || query != null && queryAtual != null && query.equals(queryAtual))) {
            proc.encerrar(tqc, resp, sessao, saida, false);
            this.doGet(req, resp);
            return;
        }
        if (proc.semaforo.tryAcquire()) {
            try {
                proc.processar(tqc, req, resp, sessao, this.getServletContext(), saida);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                proc.semaforo.release();
            }
        } else {
            resp.sendRedirect(req.getContextPath() + "/" + tqc.getPele() + "/Espera.jsp?tqc=" + this.tqcClasseName);
            return;
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public static void imprimirEstilo(Estilo estilo, String padrao, Writer saida) throws IOException {
        if (estilo == null || estilo.getEstilo() == null) {
            if (padrao != null) {
                saida.write(" class=\"" + padrao + "\"");
            }
        } else {
            saida.write(" class=\"" + estilo.getEstilo() + "\"");
        }
    }

    public static int maxCaracteres(ValidavelDado dado) {
        TextoLimite v = (TextoLimite)dado.getValidacao(TextoLimite.class);
        return v != null ? v.getMaxCaracteres() : 0;
    }

    public static Informacao getInformacaoAtual(HttpSession session, HttpServletRequest request) {
        String tqcClassName = request.getParameter(PREFIXO_PARAMETRO);
        TomaraQueCaia tqc = (TomaraQueCaia)session.getAttribute(PREFIXO_TQC_SESSAO + tqcClassName);
        return tqc.getViagemAtiva().getAtual();
    }
}

