/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.dado.Texto;
import com.joseflavio.tqc.servlet.DadoControle;
import com.joseflavio.tqc.servlet.TQCServletUtil;
import com.joseflavio.tqc.servlet.TomaraQueCaiaDesktopServlet;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class TextoControle
implements DadoControle {
    TextoControle() {
    }

    @Override
    public boolean isTransformacaoMultipla() {
        return false;
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String conteudo, Dado destino) {
        Texto textoDado = (Texto)destino;
        textoDado.setTexto(conteudo != null ? conteudo : "");
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String[] conteudo, Dado destino) {
    }

    @Override
    public String transcrever(HttpServletRequest request, TomaraQueCaia tqc, Dado dado) {
        Texto textoDado = (Texto)dado;
        String texto = textoDado.getTexto();
        return texto != null ? texto : "";
    }

    @Override
    public void imprimir(HttpServletRequest request, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id, Writer saida) throws IOException {
        Texto textoDado = (Texto)dado;
        String texto = TextoControle.converterParaHTML(textoDado.getTexto(), !textoDado.isEditavel());
        if (textoDado.isEditavel()) {
            int maxCaracs = TomaraQueCaiaDesktopServlet.maxCaracteres(textoDado);
            if (textoDado.isMultiplaLinha()) {
                saida.write("<textarea id=\"" + id + "\" name=\"" + id + "\"");
                if (textoDado.getLarguraTextual() > 0) {
                    saida.write(" cols=\"" + textoDado.getLarguraTextual() + "\"");
                }
                if (textoDado.getAlturaTextual() > 0) {
                    saida.write(" rows=\"" + textoDado.getAlturaTextual() + "\"");
                }
                saida.write(" wrap=\"" + (textoDado.isQuebraDeLinhaAutomatica() ? "soft" : "off") + "\"");
                TomaraQueCaiaDesktopServlet.imprimirEstilo(textoDado, "dadoTextoEditavel", saida);
                saida.write(">" + texto + "</textarea>");
            } else {
                saida.write("<input type=\"text\" id=\"" + id + "\" name=\"" + id + "\" value=\"" + texto + "\"");
                if (textoDado.getLarguraTextual() > 0) {
                    saida.write(" size=\"" + textoDado.getLarguraTextual() + "\"");
                }
                if (maxCaracs > 0) {
                    saida.write(" maxlength=\"" + maxCaracs + "\"");
                }
                TomaraQueCaiaDesktopServlet.imprimirEstilo(textoDado, "dadoTextoEditavel", saida);
                saida.write(" />");
            }
        } else {
            saida.write("<span");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(textoDado, "dadoTexto", saida);
            saida.write(">" + texto + "</span>");
        }
    }

    @Override
    public void redirecionar(HttpServletRequest request, HttpServletResponse response, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id) throws IOException {
    }

    public static String converterParaHTML(String texto) {
        return TQCServletUtil.converterParaHTML(texto);
    }

    public static String converterParaHTML(String texto, boolean considerarTags) {
        return TQCServletUtil.converterParaHTML(texto, considerarTags);
    }
}

