/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.dado.Senha;
import com.joseflavio.tqc.servlet.DadoControle;
import com.joseflavio.tqc.servlet.TomaraQueCaiaDesktopServlet;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class SenhaControle
implements DadoControle {
    SenhaControle() {
    }

    @Override
    public boolean isTransformacaoMultipla() {
        return false;
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String conteudo, Dado destino) {
        Senha senhaDado = (Senha)destino;
        if (conteudo == null) {
            senhaDado.setSenha("");
            return;
        }
        senhaDado.setSenha(conteudo);
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String[] conteudo, Dado destino) {
    }

    @Override
    public String transcrever(HttpServletRequest request, TomaraQueCaia tqc, Dado dado) {
        String texto = ((Senha)dado).getSenha();
        return texto != null ? texto : "";
    }

    @Override
    public void imprimir(HttpServletRequest request, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id, Writer saida) throws IOException {
        Senha senhaDado = (Senha)dado;
        String texto = senhaDado.getSenha();
        if (texto == null) {
            texto = "";
        }
        if (senhaDado.isEditavel()) {
            int maxCaracs = TomaraQueCaiaDesktopServlet.maxCaracteres(senhaDado);
            saida.write("<input type=\"password\" id=\"" + id + "\" name=\"" + id + "\" value=\"" + texto + "\"");
            if (senhaDado.getLarguraTextual() > 0) {
                saida.write(" size=\"" + senhaDado.getLarguraTextual() + "\"");
            }
            if (maxCaracs > 0) {
                saida.write(" maxlength=\"" + maxCaracs + "\"");
            }
            TomaraQueCaiaDesktopServlet.imprimirEstilo(senhaDado, "dadoTextoEditavel", saida);
            saida.write(" />");
        } else {
            saida.write("<span");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(senhaDado, "dadoTexto", saida);
            saida.write(">");
            int len = texto.length() < senhaDado.getLarguraTextual() ? texto.length() : senhaDado.getLarguraTextual();
            for (int i = 0; i < len; ++i) {
                saida.write(42);
            }
            saida.write("</span>");
        }
    }

    @Override
    public void redirecionar(HttpServletRequest request, HttpServletResponse response, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id) throws IOException {
    }
}

