/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.dado.SelecionavelTexto;
import com.joseflavio.tqc.servlet.DadoControle;
import com.joseflavio.tqc.servlet.TomaraQueCaiaDesktopServlet;
import com.joseflavio.util.TextoUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class SelecionavelTextoControle
implements DadoControle {
    SelecionavelTextoControle() {
    }

    @Override
    public boolean isTransformacaoMultipla() {
        return false;
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String conteudo, Dado destino) {
        SelecionavelTexto selecionavelTextoDado = (SelecionavelTexto)destino;
        if (conteudo == null) {
            selecionavelTextoDado.setTexto("");
            return;
        }
        selecionavelTextoDado.setTexto(conteudo);
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String[] conteudo, Dado destino) {
    }

    @Override
    public String transcrever(HttpServletRequest request, TomaraQueCaia tqc, Dado dado) {
        String texto = ((SelecionavelTexto)dado).getTexto();
        return texto != null ? texto : "";
    }

    @Override
    public void imprimir(HttpServletRequest request, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id, Writer saida) throws IOException {
        SelecionavelTexto selecionavelTextoDado = (SelecionavelTexto)dado;
        String texto = selecionavelTextoDado.getTexto();
        if (texto == null) {
            texto = "";
        }
        int larguraTextual = selecionavelTextoDado.getLarguraTextual();
        if (selecionavelTextoDado.isEditavel()) {
            int i;
            saida.write("<select id=\"" + id + "\" name=\"" + id + "\"");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(selecionavelTextoDado, "dadoSelecaoEditavel", saida);
            saida.write(">\n");
            List<String> opcoes = selecionavelTextoDado.getOpcoes();
            int total = opcoes.size();
            int selecionado = -1;
            int maxCaracs = texto.length();
            for (i = 0; i < total; ++i) {
                String op = opcoes.get(i);
                if (op.equals(texto)) {
                    selecionado = i;
                }
                if (op.length() <= maxCaracs) continue;
                maxCaracs = op.length();
            }
            saida.write("<option value=\"" + texto + "\"");
            if (selecionado == -1) {
                saida.write(" selected");
            }
            saida.write(">");
            saida.write(TextoUtil.limitarComprimento(texto, larguraTextual, true));
            saida.write("</option>\n");
            saida.write("<option value=\"" + texto + "\" disabled>");
            for (i = 0; i < maxCaracs; ++i) {
                saida.write(95);
            }
            saida.write("</option>\n");
            for (i = 0; i < total; ++i) {
                texto = opcoes.get(i);
                saida.write("<option value=\"" + texto + "\"");
                if (i == selecionado) {
                    saida.write(" selected");
                }
                saida.write(">");
                saida.write(TextoUtil.limitarComprimento(texto, larguraTextual, true));
                saida.write("</option>\n");
            }
            saida.write("</select>");
            saida.write("<input type=\"button\" id=\"selTexto_" + id + "\" name=\"selTexto_" + id + "\" class=\"dadoComando\" value=\">\" onclick=\"javascript:selecionavelTextoEditar( '" + id + "', '' )\" />");
        } else {
            saida.write("<span");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(selecionavelTextoDado, "dadoSelecao", saida);
            saida.write(">");
            saida.write(TextoUtil.limitarComprimento(texto, larguraTextual, true));
            saida.write("</span>");
        }
    }

    @Override
    public void redirecionar(HttpServletRequest request, HttpServletResponse response, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id) throws IOException {
    }
}

