/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.dado.Selecao;
import com.joseflavio.tqc.servlet.DadoControle;
import com.joseflavio.tqc.servlet.TomaraQueCaiaDesktopServlet;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class SelecaoControle
implements DadoControle {
    SelecaoControle() {
    }

    @Override
    public boolean isTransformacaoMultipla() {
        return false;
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String conteudo, Dado destino) {
        Selecao selecaoDado = (Selecao)destino;
        selecaoDado.setConteudoInvalido(null);
        if (conteudo == null || conteudo.length() == 0) {
            selecaoDado.setIndiceSelecionado(-1);
            return;
        }
        try {
            int indice = Integer.parseInt(conteudo);
            selecaoDado.setIndiceSelecionado(indice);
        }
        catch (Exception e) {
            selecaoDado.setConteudoInvalido(conteudo);
        }
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String[] conteudo, Dado destino) {
    }

    @Override
    public String transcrever(HttpServletRequest request, TomaraQueCaia tqc, Dado dado) {
        return null;
    }

    @Override
    public void imprimir(HttpServletRequest request, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id, Writer saida) throws IOException {
        Selecao selecaoDado = (Selecao)dado;
        if (selecaoDado.isEditavel()) {
            saida.write("<select id=\"" + id + "\" name=\"" + id + "\"");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(selecaoDado, "dadoSelecaoEditavel", saida);
            saida.write(">\n");
            int total = selecaoDado.getTotalOpcoes();
            int selecionado = selecaoDado.getIndiceSelecionado();
            for (int i = 0; i < total; ++i) {
                saida.write("<option value=\"" + i + "\"");
                if (i == selecionado) {
                    saida.write(" selected");
                }
                saida.write(">");
                this.imprimir(i, selecaoDado, saida);
                saida.write("</option>\n");
            }
            saida.write("</select>");
        } else {
            saida.write("<span");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(selecaoDado, "dadoSelecao", saida);
            saida.write(">");
            this.imprimir(selecaoDado.getIndiceSelecionado(), selecaoDado, saida);
            saida.write("</span>");
        }
    }

    private void imprimir(int i, Selecao<?> selecaoDado, Writer saida) throws IOException {
        if (i < 0) {
            return;
        }
        String texto = selecaoDado.getTexto(i);
        if (texto != null) {
            saida.write(texto);
            return;
        }
        Object opcao = selecaoDado.getOpcao(i);
        if (opcao != null) {
            saida.write(opcao.toString());
            return;
        }
    }

    @Override
    public void redirecionar(HttpServletRequest request, HttpServletResponse response, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id) throws IOException {
    }
}

