/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.cultura.NumeroTransformacao;
import com.joseflavio.cultura.TransformacaoException;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.dado.Real;
import com.joseflavio.tqc.servlet.DadoControle;
import com.joseflavio.tqc.servlet.TomaraQueCaiaDesktopServlet;
import com.joseflavio.util.TextoUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class RealControle
implements DadoControle {
    private NumeroTransformacao transformacao = Cultura.getPadrao().novoNumeroTransformacao();

    @Override
    public boolean isTransformacaoMultipla() {
        return false;
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String conteudo, Dado destino) {
        if (!this.transformacao.getCultura().equals(tqc.getCultura())) {
            this.transformacao = tqc.getCultura().novoNumeroTransformacao();
        }
        Real realDado = (Real)destino;
        realDado.setConteudoInvalido(null);
        if (conteudo == null || conteudo.length() == 0) {
            realDado.setNumero(null);
            return;
        }
        try {
            this.preparar(realDado);
            double numero = this.transformacao.transformarReal(conteudo);
            realDado.setNumero(numero);
        }
        catch (TransformacaoException e) {
            realDado.setConteudoInvalido(conteudo);
        }
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String[] conteudo, Dado destino) {
    }

    @Override
    public String transcrever(HttpServletRequest request, TomaraQueCaia tqc, Dado dado) {
        Real realDado;
        if (!this.transformacao.getCultura().equals(tqc.getCultura())) {
            this.transformacao = tqc.getCultura().novoNumeroTransformacao();
        }
        if ((realDado = (Real)dado).getConteudoInvalido() != null) {
            return realDado.getConteudoInvalido().toString();
        }
        try {
            this.preparar(realDado);
            Double numero = realDado.getNumero();
            return numero != null ? this.transformacao.transcrever(numero) : "";
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    @Override
    public void imprimir(HttpServletRequest request, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id, Writer saida) throws IOException {
        Real realDado = (Real)dado;
        String texto = this.transcrever(request, tqc, realDado);
        if (texto == null) {
            texto = "";
        }
        if (realDado.isEditavel()) {
            int maxCaracs = TomaraQueCaiaDesktopServlet.maxCaracteres(realDado);
            saida.write("<input type=\"text\" id=\"" + id + "\" name=\"" + id + "\" value=\"" + texto + "\"");
            if (realDado.getLarguraTextual() > 0) {
                saida.write(" size=\"" + realDado.getLarguraTextual() + "\"");
            }
            if (maxCaracs > 0) {
                saida.write(" maxlength=\"" + maxCaracs + "\"");
            }
            TomaraQueCaiaDesktopServlet.imprimirEstilo(realDado, "dadoTextoEditavel", saida);
            saida.write(" />");
        } else {
            saida.write("<span");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(realDado, "dadoTexto", saida);
            saida.write(">");
            saida.write(TextoUtil.limitarComprimento(texto, realDado.getLarguraTextual(), true));
            saida.write("</span>");
        }
    }

    private void preparar(Real real) {
        int digitosNaFracao = real.getDigitosNaFracao();
        if (digitosNaFracao >= 0) {
            this.transformacao.setMinimoDigitosNaFracao(digitosNaFracao);
            this.transformacao.setMaximoDigitosNaFracao(digitosNaFracao);
        } else {
            this.transformacao.setMinimoDigitosNaFracao(0);
            this.transformacao.setMaximoDigitosNaFracao(10);
        }
    }

    @Override
    public void redirecionar(HttpServletRequest request, HttpServletResponse response, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id) throws IOException {
    }
}

