/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.cultura.NumeroTransformacao;
import com.joseflavio.cultura.TransformacaoException;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.dado.Inteiro;
import com.joseflavio.tqc.servlet.DadoControle;
import com.joseflavio.tqc.servlet.TomaraQueCaiaDesktopServlet;
import com.joseflavio.util.TextoUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class InteiroControle
implements DadoControle {
    private NumeroTransformacao transformacao = Cultura.getPadrao().novoNumeroTransformacao();

    public InteiroControle() {
        this.transformacao.setMaximoDigitosNaFracao(0);
        this.transformacao.setMinimoDigitosNaFracao(0);
        this.transformacao.setUsarMilha(false);
    }

    @Override
    public boolean isTransformacaoMultipla() {
        return false;
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String conteudo, Dado destino) {
        Inteiro inteiroDado = (Inteiro)destino;
        inteiroDado.setConteudoInvalido(null);
        if (conteudo == null || conteudo.length() == 0) {
            inteiroDado.setNumero(null);
            return;
        }
        try {
            long numero = this.transformacao.transformarInteiro(conteudo);
            inteiroDado.setNumero(numero);
        }
        catch (TransformacaoException e) {
            inteiroDado.setConteudoInvalido(conteudo);
        }
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String[] conteudo, Dado destino) {
    }

    @Override
    public String transcrever(HttpServletRequest request, TomaraQueCaia tqc, Dado dado) {
        Inteiro inteiroDado = (Inteiro)dado;
        if (inteiroDado.getConteudoInvalido() != null) {
            return inteiroDado.getConteudoInvalido().toString();
        }
        try {
            Long numero = inteiroDado.getNumero();
            return numero != null ? this.transformacao.transcrever(numero) : "";
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    @Override
    public void imprimir(HttpServletRequest request, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id, Writer saida) throws IOException {
        Inteiro inteiroDado = (Inteiro)dado;
        String texto = this.transcrever(request, tqc, inteiroDado);
        if (texto == null) {
            texto = "";
        }
        if (inteiroDado.isEditavel()) {
            int maxCaracs = TomaraQueCaiaDesktopServlet.maxCaracteres(inteiroDado);
            saida.write("<input type=\"text\" id=\"" + id + "\" name=\"" + id + "\" value=\"" + texto + "\"");
            if (inteiroDado.getLarguraTextual() > 0) {
                saida.write(" size=\"" + inteiroDado.getLarguraTextual() + "\"");
            }
            if (maxCaracs > 0) {
                saida.write(" maxlength=\"" + maxCaracs + "\"");
            }
            TomaraQueCaiaDesktopServlet.imprimirEstilo(inteiroDado, "dadoTextoEditavel", saida);
            saida.write(" />");
        } else {
            saida.write("<span");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(inteiroDado, "dadoTexto", saida);
            saida.write(">");
            saida.write(TextoUtil.limitarComprimento(texto, inteiroDado.getLarguraTextual(), true));
            saida.write("</span>");
        }
    }

    @Override
    public void redirecionar(HttpServletRequest request, HttpServletResponse response, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id) throws IOException {
    }
}

