/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.aplicacao.Formulario;
import com.joseflavio.tqc.servlet.TQCBodyTagSupport;
import javax.servlet.jsp.JspException;

public class FormularioCamposTag
extends TQCBodyTagSupport {
    private static final long serialVersionUID = 1L;
    private Formulario<?> formulario;
    private int total;
    private int totalSelecionado;
    private int campo;
    private String rotulo;
    private Dado[] dados;

    public int doStartTag() throws JspException {
        TomaraQueCaia tqc = this.tqc();
        Viagem viagem = tqc.getViagemAtiva();
        Informacao info = viagem.getAtual();
        if (info instanceof Formulario) {
            this.formulario = (Formulario)info;
            this.total = this.formulario.getTotalDeCamposVisiveis();
            this.totalSelecionado = 0;
            this.campo = 0;
            if (this.total > 0) {
                if (!this.proximo()) {
                    return 0;
                }
                return 1;
            }
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        if (this.totalSelecionado < this.total) {
            if (!this.proximo()) {
                return 0;
            }
            return 2;
        }
        return 0;
    }

    private boolean proximo() {
        ++this.campo;
        Object rotuloDado = this.formulario.getDado("tqc_formulario_rotulo_" + this.campo);
        if (rotuloDado == null) {
            return false;
        }
        if (!((Dado)rotuloDado).isVisivel()) {
            return this.proximo();
        }
        ++this.totalSelecionado;
        Object rotuloObj = ((Dado)rotuloDado).getConteudo();
        this.rotulo = rotuloObj != null ? rotuloObj.toString() : "";
        int i = this.formulario.getIndice("tqc_formulario_campo_" + this.campo + "_i");
        int f = this.formulario.getIndice("tqc_formulario_campo_" + this.campo + "_f");
        int x = f - i - 1;
        this.dados = new Dado[x > 0 ? x : 0];
        x = 0;
        ++i;
        while (i < f) {
            this.dados[x] = this.formulario.getDado(i);
            ++x;
            ++i;
        }
        return true;
    }

    public int doEndTag() throws JspException {
        this.release();
        return 6;
    }

    public void release() {
        this.formulario = null;
        this.rotulo = null;
        this.dados = null;
    }

    public Formulario<?> getFormulario() {
        return this.formulario;
    }

    public String getRotulo() {
        return this.rotulo;
    }

    public Dado[] getDados() {
        return this.dados;
    }
}

