/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.dado.Arquivo;
import com.joseflavio.tqc.dado.Bruto;
import com.joseflavio.util.ArquivoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            TomaraQueCaia tqc = (TomaraQueCaia)req.getSession().getAttribute("tqc_" + req.getParameter("tqc"));
            if (tqc == null) {
                return;
            }
            Viagem viagem = tqc.getViagem(req.getParameter("viagem"));
            long passo = Long.parseLong(req.getParameter("passo"));
            if (viagem.getPasso() != passo) {
                return;
            }
            Informacao info = viagem.getAtual();
            int indice = Integer.parseInt(req.getParameter("dado"));
            if (info == null || indice >= info.getTotalDados()) {
                return;
            }
            Dado dado = info.getDado(indice);
            if (dado instanceof Bruto) {
                Bruto bruto = (Bruto)dado;
                byte[] valor = bruto.getValor();
                resp.setContentType(ArquivoUtil.getHTMLContentType(bruto.getValorRotulo()));
                resp.setHeader("Content-Disposition", "attachment;filename=" + bruto.getValorRotulo());
                resp.setContentLength(valor.length);
                ServletOutputStream out = resp.getOutputStream();
                out.write(valor);
                out.flush();
            } else if (dado instanceof Arquivo) {
                int ch;
                Arquivo arquivo = (Arquivo)dado;
                File f = arquivo.getArquivo();
                resp.setContentType(ArquivoUtil.getHTMLContentType(f.getName()));
                resp.setHeader("Content-Disposition", "attachment;filename=" + f.getName());
                resp.setContentLength((int)f.length());
                FileInputStream in = new FileInputStream(f);
                ServletOutputStream out = resp.getOutputStream();
                while ((ch = in.read()) != -1) {
                    out.write(ch);
                }
                out.flush();
                in.close();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

