/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.cultura.DataTransformacao;
import com.joseflavio.cultura.TransformacaoException;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.dado.Data;
import com.joseflavio.tqc.servlet.DadoControle;
import com.joseflavio.tqc.servlet.TomaraQueCaiaDesktopServlet;
import com.joseflavio.util.TextoUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class DataControle
implements DadoControle {
    private DataTransformacao transformacao = Cultura.getPadrao().novaDataTransformacaoNumerica();
    private static final int tamanhoData = 10;
    private static final int tamanhoHora = 5;
    private static final int tamanhoDataHora = 16;

    @Override
    public boolean isTransformacaoMultipla() {
        return false;
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String conteudo, Dado destino) {
        if (!this.transformacao.getCultura().equals(tqc.getCultura())) {
            this.transformacao = tqc.getCultura().novaDataTransformacaoNumerica();
        }
        Data dataDado = (Data)destino;
        dataDado.setConteudoInvalido(null);
        if (conteudo == null || conteudo.length() == 0) {
            dataDado.setData(null);
            return;
        }
        try {
            Date data;
            switch (dataDado.getTipo()) {
                case DATA: {
                    data = this.transformacao.transformarData(DataControle.completar(conteudo));
                    break;
                }
                case HORA: {
                    data = this.transformacao.transformarHora(DataControle.completar(conteudo));
                    break;
                }
                default: {
                    data = this.transformacao.transformarDataHora(DataControle.completar(conteudo));
                }
            }
            dataDado.setData(data);
        }
        catch (TransformacaoException e) {
            dataDado.setConteudoInvalido(conteudo);
        }
    }

    @Override
    public void transformar(HttpServletRequest request, TomaraQueCaia tqc, String[] conteudo, Dado destino) {
    }

    @Override
    public String transcrever(HttpServletRequest request, TomaraQueCaia tqc, Dado dado) {
        Data dataDado;
        if (!this.transformacao.getCultura().equals(tqc.getCultura())) {
            this.transformacao = tqc.getCultura().novaDataTransformacaoNumerica();
        }
        if ((dataDado = (Data)dado).getConteudoInvalido() != null) {
            return dataDado.getConteudoInvalido().toString();
        }
        Date data = dataDado.getData();
        if (data == null) {
            return "";
        }
        try {
            switch (dataDado.getTipo()) {
                case DATA: {
                    return this.transformacao.transcreverData(data);
                }
                case HORA: {
                    return this.transformacao.transcreverHora(data);
                }
            }
            return this.transformacao.transcreverDataHora(data);
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    @Override
    public void imprimir(HttpServletRequest request, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id, Writer saida) throws IOException {
        Data dataDado = (Data)dado;
        String texto = this.transcrever(request, tqc, dataDado);
        if (texto == null) {
            texto = "";
        }
        if (dataDado.isEditavel()) {
            saida.write("<input type=\"text\" id=\"" + id + "\" name=\"" + id + "\" value=\"" + texto + "\"");
            int tamanho = this.larguraTextual(dataDado);
            if (dataDado.getLarguraTextual() > tamanho) {
                tamanho = dataDado.getLarguraTextual();
            }
            saida.write(" size=\"" + tamanho + "\"");
            saida.write(" maxlength=\"" + tamanho + "\"");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(dataDado, "dadoTextoEditavel", saida);
            saida.write(" />");
        } else {
            saida.write("<span");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(dataDado, "dadoTexto", saida);
            saida.write(">");
            saida.write(TextoUtil.limitarComprimento(texto, dataDado.getLarguraTextual(), true));
            saida.write("</span>");
        }
    }

    private int larguraTextual(Data dataDado) {
        switch (dataDado.getTipo()) {
            case DATA: {
                return 10;
            }
            case HORA: {
                return 5;
            }
        }
        return 16;
    }

    @Override
    public void redirecionar(HttpServletRequest request, HttpServletResponse response, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Dado dado, String id) throws IOException {
    }

    private static String completar(String dh) {
        if (dh == null) {
            return null;
        }
        dh = dh.trim();
        int len = dh.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(dh.charAt(i))) continue;
            return dh;
        }
        switch (len) {
            case 4: {
                return new StringBuilder(dh).insert(2, ':').toString();
            }
            case 6: {
                return new StringBuilder(dh).insert(2, '/').insert(5, '/').insert(6, '2').insert(7, '0').toString();
            }
            case 8: {
                return new StringBuilder(dh).insert(2, '/').insert(5, '/').toString();
            }
            case 12: {
                return new StringBuilder(dh).insert(2, '/').insert(5, '/').insert(10, ' ').insert(13, ':').toString();
            }
            case 13: {
                return new StringBuilder(dh).insert(2, '/').insert(5, '/').insert(13, ':').toString();
            }
        }
        return dh;
    }
}

