/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.servlet.TQCBodyTagSupport;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class DadosTag
extends TQCBodyTagSupport {
    private static final long serialVersionUID = 1L;
    private Informacao informacao;
    private String nomeInicial;
    private String nomeFinal;
    private boolean inclusive = false;
    private int passo = 1;
    private int posI;
    private int posF;

    public int doStartTag() throws JspException {
        TomaraQueCaia tqc = this.tqc();
        Viagem viagem = tqc.getViagemAtiva();
        this.informacao = viagem.getAtual();
        int total = this.informacao.getTotalDados();
        if (total == 0) {
            return 0;
        }
        if (this.nomeInicial != null) {
            this.posI = this.informacao.getIndice(this.nomeInicial);
            if (this.posI < 0) {
                this.posI = 0;
            } else if (!this.inclusive) {
                ++this.posI;
            }
        } else {
            this.posI = 0;
        }
        if (this.nomeFinal != null) {
            this.posF = this.informacao.getIndice(this.nomeFinal);
            if (this.posF < 0) {
                this.posF = total - 1;
            } else if (!this.inclusive) {
                --this.posF;
            }
        } else {
            this.posF = total - 1;
        }
        if (this.posI <= this.posF) {
            this.proximo();
            return 1;
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        if (this.posI <= this.posF) {
            this.proximo();
            return 2;
        }
        return 0;
    }

    private void proximo() {
        ((HttpServletRequest)this.pageContext.getRequest()).setAttribute("TQC_Dado_Corrente", (Object)this.informacao.getDado(this.posI));
        this.posI += this.passo;
    }

    public int doEndTag() throws JspException {
        this.release();
        return 6;
    }

    public void release() {
        this.informacao = null;
        this.nomeInicial = null;
        this.nomeFinal = null;
    }

    public String getNomeInicial() {
        return this.nomeInicial;
    }

    public void setNomeInicial(String nomeInicial) {
        this.nomeInicial = nomeInicial;
    }

    public String getNomeFinal() {
        return this.nomeFinal;
    }

    public void setNomeFinal(String nomeFinal) {
        this.nomeFinal = nomeFinal;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public void setInclusive(boolean inclusive) {
        this.inclusive = inclusive;
    }

    public int getPasso() {
        return this.passo;
    }

    public void setPasso(int passo) {
        this.passo = passo;
    }
}

