/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.servlet.TQCBodyTagSupport;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class DadoRelativoTag
extends TQCBodyTagSupport {
    private static final long serialVersionUID = 1L;
    private int distancia = 0;

    public int doStartTag() throws JspException {
        try {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            TomaraQueCaia tqc = this.tqc();
            Viagem viagem = tqc.getViagemAtiva();
            Informacao info = viagem.getAtual();
            Dado corrente = (Dado)request.getAttribute("TQC_Dado_Corrente");
            if (corrente == null) {
                throw new JspException("Dado corrente indefinido.");
            }
            if (this.distancia == 0) {
                return 1;
            }
            int indice = info.getIndice(corrente);
            int indiceNovo = indice + this.distancia;
            int total = info.getTotalDados();
            if (indiceNovo < 0 || indiceNovo >= total) {
                throw new JspException("Dist\u00e2ncia relativa inv\u00e1lida.");
            }
            request.setAttribute("TQC_Dado_Corrente", (Object)info.getDado(indiceNovo));
            return 1;
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        this.release();
        return 6;
    }

    public void release() {
    }

    public int getDistancia() {
        return this.distancia;
    }

    public void setDistancia(int distancia) {
        this.distancia = distancia;
    }
}

